/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.uber.m3.tally.Scope;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowOptions;
import io.temporal.common.metadata.POJOWorkflowImplMetadata;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.testing.TestWorkflowEnvironment;
import io.temporal.testing.WorkflowInitialTime;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.workflow.DynamicWorkflow;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.support.AnnotationSupport;

public class TestWorkflowExtension
implements ParameterResolver,
TestWatcher,
BeforeEachCallback,
AfterEachCallback {
    private static final String TEST_ENVIRONMENT_KEY = "testEnvironment";
    private static final String WORKER_KEY = "worker";
    private static final String WORKFLOW_OPTIONS_KEY = "workflowOptions";
    private final WorkerOptions workerOptions;
    private final WorkflowClientOptions workflowClientOptions;
    private final WorkerFactoryOptions workerFactoryOptions;
    private final Class<?>[] workflowTypes;
    private final Object[] activityImplementations;
    private final boolean useExternalService;
    private final String target;
    private final boolean doNotStart;
    private final long initialTimeMillis;
    private final boolean useTimeskipping;
    @Nonnull
    private final Map<String, IndexedValueType> searchAttributes;
    private final Scope metricsScope;
    private final Set<Class<?>> supportedParameterTypes = new HashSet();
    private boolean includesDynamicWorkflow;

    private TestWorkflowExtension(Builder builder) {
        this.workerOptions = builder.workerOptions;
        this.workflowClientOptions = builder.workflowClientOptions != null ? builder.workflowClientOptions : WorkflowClientOptions.newBuilder().setNamespace(builder.namespace).build();
        this.workerFactoryOptions = builder.workerFactoryOptions;
        this.workflowTypes = builder.workflowTypes;
        this.activityImplementations = builder.activityImplementations;
        this.useExternalService = builder.useExternalService;
        this.target = builder.target;
        this.doNotStart = builder.doNotStart;
        this.initialTimeMillis = builder.initialTimeMillis;
        this.useTimeskipping = builder.useTimeskipping;
        this.searchAttributes = builder.searchAttributes;
        this.metricsScope = builder.metricsScope;
        this.supportedParameterTypes.add(TestWorkflowEnvironment.class);
        this.supportedParameterTypes.add(WorkflowClient.class);
        this.supportedParameterTypes.add(WorkflowOptions.class);
        this.supportedParameterTypes.add(Worker.class);
        for (Class<?> workflowType : this.workflowTypes) {
            if (DynamicWorkflow.class.isAssignableFrom(workflowType)) {
                this.includesDynamicWorkflow = true;
                continue;
            }
            POJOWorkflowImplMetadata metadata = POJOWorkflowImplMetadata.newInstance(workflowType);
            for (POJOWorkflowInterfaceMetadata workflowInterface : metadata.getWorkflowInterfaces()) {
                this.supportedParameterTypes.add(workflowInterface.getInterfaceClass());
            }
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        if (parameter.getDeclaringExecutable() instanceof Constructor) {
            return false;
        }
        Class<?> parameterType = parameter.getType();
        if (this.supportedParameterTypes.contains(parameterType)) {
            return true;
        }
        if (!this.includesDynamicWorkflow) {
            return false;
        }
        try {
            POJOWorkflowInterfaceMetadata.newInstance(parameterType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType == TestWorkflowEnvironment.class) {
            return this.getTestEnvironment(extensionContext);
        }
        if (parameterType == WorkflowClient.class) {
            return this.getTestEnvironment(extensionContext).getWorkflowClient();
        }
        if (parameterType == WorkflowOptions.class) {
            return this.getWorkflowOptions(extensionContext);
        }
        if (parameterType == Worker.class) {
            return this.getWorker(extensionContext);
        }
        return this.getTestEnvironment(extensionContext).getWorkflowClient().newWorkflowStub(parameterType, this.getWorkflowOptions(extensionContext));
    }

    public void beforeEach(ExtensionContext context) {
        long currentInitialTimeMillis = AnnotationSupport.findAnnotation((Optional)context.getElement(), WorkflowInitialTime.class).map(annotation -> Instant.parse(annotation.value()).toEpochMilli()).orElse(this.initialTimeMillis);
        TestWorkflowEnvironment testEnvironment = TestWorkflowEnvironment.newInstance(this.createTestEnvOptions(currentInitialTimeMillis));
        String taskQueue = String.format("WorkflowTest-%s-%s", context.getDisplayName(), context.getUniqueId());
        Worker worker = testEnvironment.newWorker(taskQueue, this.workerOptions);
        worker.registerWorkflowImplementationTypes((Class[])this.workflowTypes);
        worker.registerActivitiesImplementations(this.activityImplementations);
        if (!this.doNotStart) {
            testEnvironment.start();
        }
        this.setTestEnvironment(context, testEnvironment);
        this.setWorker(context, worker);
        this.setWorkflowOptions(context, WorkflowOptions.newBuilder().setTaskQueue(taskQueue).build());
    }

    protected TestEnvironmentOptions createTestEnvOptions(long initialTimeMillis) {
        return TestEnvironmentOptions.newBuilder().setWorkflowClientOptions(this.workflowClientOptions).setWorkerFactoryOptions(this.workerFactoryOptions).setUseExternalService(this.useExternalService).setUseTimeskipping(this.useTimeskipping).setTarget(this.target).setInitialTimeMillis(initialTimeMillis).setMetricsScope(this.metricsScope).setSearchAttributes(this.searchAttributes).build();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        TestWorkflowEnvironment testEnvironment = this.getTestEnvironment(context);
        testEnvironment.close();
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        TestWorkflowEnvironment testEnvironment = this.getTestEnvironment(context);
        System.err.println("Workflow execution histories:\n" + testEnvironment.getDiagnostics());
    }

    private TestWorkflowEnvironment getTestEnvironment(ExtensionContext context) {
        return (TestWorkflowEnvironment)this.getStore(context).get((Object)TEST_ENVIRONMENT_KEY, TestWorkflowEnvironment.class);
    }

    private void setTestEnvironment(ExtensionContext context, TestWorkflowEnvironment testEnvironment) {
        this.getStore(context).put((Object)TEST_ENVIRONMENT_KEY, (Object)testEnvironment);
    }

    private Worker getWorker(ExtensionContext context) {
        return (Worker)this.getStore(context).get((Object)WORKER_KEY, Worker.class);
    }

    private void setWorker(ExtensionContext context, Worker worker) {
        this.getStore(context).put((Object)WORKER_KEY, (Object)worker);
    }

    private WorkflowOptions getWorkflowOptions(ExtensionContext context) {
        return (WorkflowOptions)this.getStore(context).get((Object)WORKFLOW_OPTIONS_KEY, WorkflowOptions.class);
    }

    private void setWorkflowOptions(ExtensionContext context, WorkflowOptions taskQueue) {
        this.getStore(context).put((Object)WORKFLOW_OPTIONS_KEY, (Object)taskQueue);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{TestWorkflowExtension.class, context.getRequiredTestMethod()});
        return context.getStore(namespace);
    }

    public static class Builder {
        private static final Class<?>[] NO_WORKFLOWS = new Class[0];
        private static final Object[] NO_ACTIVITIES = new Object[0];
        private WorkerOptions workerOptions = WorkerOptions.getDefaultInstance();
        private WorkflowClientOptions workflowClientOptions;
        private WorkerFactoryOptions workerFactoryOptions;
        private String namespace = "UnitTest";
        private Class<?>[] workflowTypes = NO_WORKFLOWS;
        private Object[] activityImplementations = NO_ACTIVITIES;
        private boolean useExternalService = false;
        private String target = null;
        private boolean doNotStart = false;
        private long initialTimeMillis;
        private boolean useTimeskipping = TestEnvironmentOptions.getDefaultInstance().isUseTimeskipping();
        @Nonnull
        private Map<String, IndexedValueType> searchAttributes = new HashMap<String, IndexedValueType>();
        private Scope metricsScope;

        private Builder() {
        }

        public Builder setWorkerOptions(WorkerOptions options) {
            this.workerOptions = options;
            return this;
        }

        public Builder setWorkflowClientOptions(WorkflowClientOptions workflowClientOptions) {
            this.workflowClientOptions = workflowClientOptions;
            return this;
        }

        public Builder setWorkerFactoryOptions(WorkerFactoryOptions workerFactoryOptions) {
            this.workerFactoryOptions = workerFactoryOptions;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setWorkflowTypes(Class<?> ... workflowTypes) {
            this.workflowTypes = workflowTypes;
            return this;
        }

        public Builder setActivityImplementations(Object ... activityImplementations) {
            this.activityImplementations = activityImplementations;
            return this;
        }

        public Builder useExternalService() {
            return this.useExternalService(null);
        }

        public Builder useExternalService(String target) {
            this.useExternalService = true;
            this.target = target;
            return this;
        }

        public Builder useInternalService() {
            this.useExternalService = false;
            this.target = null;
            return this;
        }

        public Builder setDoNotStart(boolean doNotStart) {
            this.doNotStart = doNotStart;
            return this;
        }

        public Builder setInitialTimeMillis(long initialTimeMillis) {
            this.initialTimeMillis = initialTimeMillis;
            return this;
        }

        public Builder setInitialTime(Instant initialTime) {
            this.initialTimeMillis = initialTime.toEpochMilli();
            return this;
        }

        public Builder setUseTimeskipping(boolean useTimeskipping) {
            this.useTimeskipping = useTimeskipping;
            return this;
        }

        public Builder registerSearchAttribute(String name, IndexedValueType type) {
            this.searchAttributes.put(name, type);
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public TestWorkflowExtension build() {
            return new TestWorkflowExtension(this);
        }
    }
}

