/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing.internal;

import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowQueryException;
import io.temporal.client.WorkflowStub;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.internal.common.DebugModeUtils;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.testing.TestWorkflowEnvironment;
import io.temporal.testing.TestWorkflowRule;
import io.temporal.testing.internal.SDKTestOptions;
import io.temporal.testing.internal.TracingWorkerInterceptor;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKTestWorkflowRule
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(SDKTestWorkflowRule.class);
    private static final long DEFAULT_TEST_TIMEOUT_SECONDS = 10L;
    private static final long BUSY_WAIT_SLEEP_MS = 100L;
    public static final String NAMESPACE = "UnitTest";
    public static final String UUID_REGEXP = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    public static final boolean REGENERATE_JSON_FILES = false;
    public static final boolean useExternalService = Boolean.parseBoolean(System.getenv("USE_DOCKER_SERVICE"));
    public static final String temporalServiceAddress = System.getenv("TEMPORAL_SERVICE_ADDRESS");
    private static final List<ScheduledFuture<?>> delayedCallbacks = new ArrayList();
    private static final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    @Nullable
    private final Timeout globalTimeout;
    private final TestWorkflowRule testWorkflowRule;

    private SDKTestWorkflowRule(Builder builder) {
        if (useExternalService) {
            builder.testWorkflowRuleBuilder.setUseExternalService(true);
            if (temporalServiceAddress != null) {
                builder.testWorkflowRuleBuilder.setTarget(temporalServiceAddress);
            }
        }
        this.globalTimeout = !DebugModeUtils.isTemporalDebugModeOn() ? Timeout.seconds((long)(builder.testTimeoutSeconds == 0L ? 10L : builder.testTimeoutSeconds)) : null;
        this.testWorkflowRule = builder.testWorkflowRuleBuilder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Statement apply(@Nonnull Statement base, Description description) {
        boolean timeoutIsOverriddenOnTestAnnotation;
        Statement testWorkflowStatement = base;
        Test annotation = (Test)description.getAnnotation(Test.class);
        boolean bl = timeoutIsOverriddenOnTestAnnotation = annotation != null && annotation.timeout() > 0L;
        if (this.globalTimeout != null && !timeoutIsOverriddenOnTestAnnotation) {
            testWorkflowStatement = this.globalTimeout.apply(testWorkflowStatement, description);
        }
        return this.testWorkflowRule.apply(testWorkflowStatement, description);
    }

    public <T extends WorkerInterceptor> T getInterceptor(Class<T> type) {
        return this.testWorkflowRule.getInterceptor(type);
    }

    public String getTaskQueue() {
        return this.testWorkflowRule.getTaskQueue();
    }

    public Worker getWorker() {
        return this.testWorkflowRule.getWorker();
    }

    public History getHistory(WorkflowExecution execution) {
        return this.testWorkflowRule.getHistory(execution);
    }

    public WorkflowExecutionHistory getExecutionHistory(WorkflowExecution execution) {
        return new WorkflowExecutionHistory(this.testWorkflowRule.getHistory(execution));
    }

    public List<HistoryEvent> getHistoryEvents(WorkflowExecution execution, EventType eventType) {
        ArrayList<HistoryEvent> result = new ArrayList<HistoryEvent>();
        History history = this.getHistory(execution);
        for (HistoryEvent event : history.getEventsList()) {
            if (eventType != event.getEventType()) continue;
            result.add(event);
        }
        return result;
    }

    public HistoryEvent getHistoryEvent(WorkflowExecution execution, EventType eventType) {
        History history = this.getHistory(execution);
        for (HistoryEvent event : history.getEventsList()) {
            if (eventType != event.getEventType()) continue;
            return event;
        }
        throw new IllegalArgumentException("No event of " + eventType + " found in the history");
    }

    public void assertHistoryEvent(WorkflowExecution execution, EventType eventType) {
        History history = this.getHistory(execution);
        for (HistoryEvent event : history.getEventsList()) {
            if (eventType != event.getEventType()) continue;
            return;
        }
        Assert.fail((String)("No event of " + eventType + " found in the history"));
    }

    public void assertNoHistoryEvent(WorkflowExecution execution, EventType eventType) {
        History history = this.getHistory(execution);
        SDKTestWorkflowRule.assertNoHistoryEvent(history, eventType);
    }

    public static void assertNoHistoryEvent(History history, EventType eventType) {
        for (HistoryEvent event : history.getEventsList()) {
            if (eventType != event.getEventType()) continue;
            Assert.fail((String)("Event of " + eventType + " found in the history"));
        }
    }

    public void waitForTheEndOfWFT(WorkflowExecution execution) {
        WorkflowExecutionHistory initialHistory = this.getExecutionHistory(execution);
        HistoryEvent lastEvent = initialHistory.getLastEvent();
        if (SDKTestWorkflowRule.isWFTInProgress(lastEvent)) {
            long startEventId = lastEvent.getEventId();
            while (true) {
                History history = this.getHistory(execution);
                ListIterator historyEventListIterator = history.getEventsList().listIterator(history.getEventsList().size());
                HistoryEvent previous = (HistoryEvent)historyEventListIterator.previous();
                while (historyEventListIterator.hasPrevious() && previous.getEventId() > startEventId) {
                    if (!SDKTestWorkflowRule.isWFTInProgress((HistoryEvent)historyEventListIterator.previous())) {
                        return;
                    }
                    previous = (HistoryEvent)historyEventListIterator.previous();
                }
                SDKTestWorkflowRule.busyWaitSleep();
            }
        }
    }

    public WorkflowClient getWorkflowClient() {
        return this.testWorkflowRule.getWorkflowClient();
    }

    public WorkflowServiceStubs getWorkflowServiceStubs() {
        return this.testWorkflowRule.getWorkflowServiceStubs();
    }

    public boolean isUseExternalService() {
        return useExternalService;
    }

    public TestWorkflowEnvironment getTestEnvironment() {
        return this.testWorkflowRule.getTestEnvironment();
    }

    public <T> T newWorkflowStub(Class<T> workflow) {
        return this.testWorkflowRule.newWorkflowStub(workflow);
    }

    public <T> T newWorkflowStubTimeoutOptions(Class<T> workflow) {
        return (T)this.getWorkflowClient().newWorkflowStub(workflow, SDKTestOptions.newWorkflowOptionsWithTimeouts(this.getTaskQueue()));
    }

    public <T> T newWorkflowStub200sTimeoutOptions(Class<T> workflow) {
        return (T)this.getWorkflowClient().newWorkflowStub(workflow, SDKTestOptions.newWorkflowOptionsForTaskQueue200sTimeout(this.getTaskQueue()));
    }

    public WorkflowStub newUntypedWorkflowStub(String workflow) {
        return this.testWorkflowRule.newUntypedWorkflowStub(workflow);
    }

    public WorkflowStub newUntypedWorkflowStubTimeoutOptions(String workflow) {
        return this.getWorkflowClient().newUntypedWorkflowStub(workflow, SDKTestOptions.newWorkflowOptionsWithTimeouts(this.getTaskQueue()));
    }

    public static void waitForOKQuery(Object anyStub) {
        WorkflowStub untypedStub = anyStub instanceof WorkflowStub ? (WorkflowStub)anyStub : WorkflowStub.fromTyped((Object)anyStub);
        while (true) {
            try {
                String stackTrace;
                while ((stackTrace = (String)untypedStub.query("__stack_trace", String.class, new Object[0])).isEmpty()) {
                    SDKTestWorkflowRule.busyWaitSleep();
                }
            }
            catch (WorkflowQueryException workflowQueryException) {
                continue;
            }
            break;
        }
    }

    public <R> void addWorkflowImplementationFactory(Class<R> factoryImpl, Functions.Func<R> factoryFunc) {
        this.getTestEnvironment().getWorkerFactory().getWorker(this.getTaskQueue()).addWorkflowImplementationFactory(factoryImpl, factoryFunc);
    }

    public void regenerateHistoryForReplay(WorkflowExecution execution, String fileName) {
    }

    public void registerDelayedCallback(Duration delay, Runnable r) {
        if (useExternalService) {
            ScheduledFuture<?> result = scheduledExecutor.schedule(r, delay.toMillis(), TimeUnit.MILLISECONDS);
            delayedCallbacks.add(result);
        } else {
            this.testWorkflowRule.getTestEnvironment().registerDelayedCallback(delay, r);
        }
    }

    protected void shutdown() throws Throwable {
        this.getTestEnvironment().shutdown();
        TracingWorkerInterceptor tracer = this.getInterceptor(TracingWorkerInterceptor.class);
        if (tracer != null) {
            tracer.assertExpected();
        }
        for (ScheduledFuture<?> result : delayedCallbacks) {
            if (!result.isDone() || result.isCancelled()) continue;
            try {
                result.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    public void sleep(Duration d) {
        if (useExternalService) {
            try {
                Thread.sleep(d.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted", e);
            }
        } else {
            this.testWorkflowRule.getTestEnvironment().sleep(d);
        }
    }

    public void invalidateWorkflowCache() {
        WorkerFactory workerFactory = this.testWorkflowRule.getTestEnvironment().getWorkerFactory();
        try {
            Method getCache = WorkerFactory.class.getDeclaredMethod("getCache", new Class[0]);
            getCache.setAccessible(true);
            WorkflowExecutorCache cache = (WorkflowExecutorCache)getCache.invoke((Object)workerFactory, new Object[0]);
            cache.invalidateAll();
            while (cache.size() > 0L) {
                SDKTestWorkflowRule.busyWaitSleep();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isWFTInProgress(HistoryEvent event) {
        EventType eventType = event.getEventType();
        switch (eventType) {
            case EVENT_TYPE_WORKFLOW_TASK_STARTED: 
            case EVENT_TYPE_WORKFLOW_TASK_SCHEDULED: {
                return true;
            }
        }
        return false;
    }

    private static void busyWaitSleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private long testTimeoutSeconds;
        private boolean workerFactoryOptionsAreSet = false;
        private final TestWorkflowRule.Builder testWorkflowRuleBuilder = TestWorkflowRule.newBuilder();

        public Builder setWorkerOptions(WorkerOptions options) {
            this.testWorkflowRuleBuilder.setWorkerOptions(options);
            return this;
        }

        public Builder setWorkerFactoryOptions(WorkerFactoryOptions options) {
            options = options.getWorkerInterceptors() == null ? WorkerFactoryOptions.newBuilder((WorkerFactoryOptions)options).setWorkerInterceptors(new WorkerInterceptor[]{new TracingWorkerInterceptor(new TracingWorkerInterceptor.FilteredTrace())}).build() : options;
            this.testWorkflowRuleBuilder.setWorkerFactoryOptions(options);
            this.workerFactoryOptionsAreSet = true;
            return this;
        }

        public Builder setWorkflowClientOptions(WorkflowClientOptions workflowClientOptions) {
            this.testWorkflowRuleBuilder.setWorkflowClientOptions(workflowClientOptions);
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.testWorkflowRuleBuilder.setNamespace(namespace);
            return this;
        }

        public Builder setWorkflowTypes(Class<?> ... workflowTypes) {
            this.testWorkflowRuleBuilder.setWorkflowTypes(workflowTypes);
            return this;
        }

        public Builder setWorkflowTypes(WorkflowImplementationOptions implementationOptions, Class<?> ... workflowTypes) {
            this.testWorkflowRuleBuilder.setWorkflowTypes(implementationOptions, workflowTypes);
            return this;
        }

        public Builder setActivityImplementations(Object ... activityImplementations) {
            this.testWorkflowRuleBuilder.setActivityImplementations(activityImplementations);
            return this;
        }

        public Builder setUseExternalService(boolean useExternalService) {
            this.testWorkflowRuleBuilder.setUseExternalService(useExternalService);
            return this;
        }

        public Builder setTarget(String target) {
            this.testWorkflowRuleBuilder.setTarget(target);
            return this;
        }

        public Builder setTestTimeoutSeconds(long testTimeoutSeconds) {
            this.testTimeoutSeconds = testTimeoutSeconds;
            return this;
        }

        public Builder setInitialTimeMillis(long initialTimeMillis) {
            this.testWorkflowRuleBuilder.setInitialTimeMillis(initialTimeMillis);
            return this;
        }

        public Builder setDoNotStart(boolean doNotStart) {
            this.testWorkflowRuleBuilder.setDoNotStart(doNotStart);
            return this;
        }

        public Builder setUseTimeskipping(boolean useTimeskipping) {
            this.testWorkflowRuleBuilder.setUseTimeskipping(useTimeskipping);
            return this;
        }

        public Builder registerSearchAttribute(String name, IndexedValueType type) {
            this.testWorkflowRuleBuilder.registerSearchAttribute(name, type);
            return this;
        }

        public Builder setMetricsScope(Scope scope) {
            this.testWorkflowRuleBuilder.setMetricsScope(scope);
            return this;
        }

        public SDKTestWorkflowRule build() {
            if (!this.workerFactoryOptionsAreSet) {
                this.testWorkflowRuleBuilder.setWorkerFactoryOptions(WorkerFactoryOptions.newBuilder().setWorkerInterceptors(new WorkerInterceptor[]{new TracingWorkerInterceptor(new TracingWorkerInterceptor.FilteredTrace())}).build());
            }
            return new SDKTestWorkflowRule(this);
        }
    }
}

