/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.DummySyncWorkflowContext;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class DeterministicRunnerWrapper
implements InvocationHandler {
    private final InvocationHandler invocationHandler;
    private final WorkflowThreadExecutor workflowThreadExecutor;

    public DeterministicRunnerWrapper(InvocationHandler invocationHandler, WorkflowThreadExecutor workflowThreadExecutor) {
        this.invocationHandler = Objects.requireNonNull(invocationHandler);
        this.workflowThreadExecutor = Objects.requireNonNull(workflowThreadExecutor);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CompletableFuture result = new CompletableFuture();
        DeterministicRunnerImpl runner = new DeterministicRunnerImpl(this.workflowThreadExecutor, DummySyncWorkflowContext.newDummySyncWorkflowContext(), () -> {
            try {
                result.complete(this.invocationHandler.invoke(proxy, method, args));
            }
            catch (Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        });
        runner.runUntilAllBlocked(Long.MAX_VALUE);
        try {
            return result.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

