/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.annotations.VisibleForTesting;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.worker.WorkerFactoryOptions;
import java.time.Instant;

@VisibleForTesting
public final class TestEnvironmentOptions {
    private static final TestEnvironmentOptions DEFAULT_INSTANCE = TestEnvironmentOptions.newBuilder().build();
    private final WorkerFactoryOptions workerFactoryOptions;
    private final WorkflowClientOptions workflowClientOptions;
    private final Scope metricsScope;
    private final boolean useExternalService;
    private final String target;
    private final long initialTimeMillis;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(TestEnvironmentOptions options) {
        return new Builder(options);
    }

    public static TestEnvironmentOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private TestEnvironmentOptions(WorkflowClientOptions workflowClientOptions, WorkerFactoryOptions workerFactoryOptions, boolean useExternalService, String target, long initialTimeMillis, Scope metricsScope) {
        this.workflowClientOptions = workflowClientOptions;
        this.workerFactoryOptions = workerFactoryOptions;
        this.metricsScope = metricsScope;
        this.useExternalService = useExternalService;
        this.target = target;
        this.initialTimeMillis = initialTimeMillis;
    }

    public WorkerFactoryOptions getWorkerFactoryOptions() {
        return this.workerFactoryOptions;
    }

    public WorkflowClientOptions getWorkflowClientOptions() {
        return this.workflowClientOptions;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean isUseExternalService() {
        return this.useExternalService;
    }

    public String getTarget() {
        return this.target;
    }

    public long getInitialTimeMillis() {
        return this.initialTimeMillis;
    }

    public String toString() {
        return "TestEnvironmentOptions{workerFactoryOptions=" + this.workerFactoryOptions + ", workflowClientOptions=" + this.workflowClientOptions + ", metricsScope=" + this.metricsScope + ", useExternalService=" + this.useExternalService + ", target=" + this.target + ", initialTimeMillis=" + this.initialTimeMillis + '}';
    }

    public static final class Builder {
        private WorkerFactoryOptions workerFactoryOptions;
        private WorkflowClientOptions workflowClientOptions;
        private Scope metricsScope;
        private boolean useExternalService;
        private String target;
        private long initialTimeMillis;

        private Builder() {
        }

        private Builder(TestEnvironmentOptions o) {
            this.workerFactoryOptions = o.workerFactoryOptions;
            this.workflowClientOptions = o.workflowClientOptions;
            this.useExternalService = o.useExternalService;
            this.target = o.target;
        }

        public Builder setWorkflowClientOptions(WorkflowClientOptions workflowClientOptions) {
            this.workflowClientOptions = workflowClientOptions;
            return this;
        }

        public Builder setWorkerFactoryOptions(WorkerFactoryOptions options) {
            this.workerFactoryOptions = options;
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this;
        }

        public Builder setUseExternalService(boolean useExternalService) {
            this.useExternalService = useExternalService;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setInitialTimeMillis(long initialTimeMillis) {
            this.initialTimeMillis = initialTimeMillis;
            return this;
        }

        public Builder setInitialTime(Instant initialTime) {
            this.initialTimeMillis = initialTime.toEpochMilli();
            return this;
        }

        public TestEnvironmentOptions build() {
            return new TestEnvironmentOptions(this.workflowClientOptions, this.workerFactoryOptions, this.useExternalService, this.target, this.initialTimeMillis, this.metricsScope);
        }

        public TestEnvironmentOptions validateAndBuildWithDefaults() {
            return new TestEnvironmentOptions(WorkflowClientOptions.newBuilder((WorkflowClientOptions)this.workflowClientOptions).validateAndBuildWithDefaults(), WorkerFactoryOptions.newBuilder((WorkerFactoryOptions)this.workerFactoryOptions).validateAndBuildWithDefaults(), this.useExternalService, this.target, this.initialTimeMillis, (Scope)(this.metricsScope == null ? new NoopScope() : this.metricsScope));
        }
    }
}

