/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.grpc.Deadline;
import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.HistoryEventFilterType;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.internal.testservice.SelfAdvancingTimerImpl;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestWorkflowStoreImpl
implements TestWorkflowStore {
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowStoreImpl.class);
    private final Lock lock = new ReentrantLock();
    private final Map<ExecutionId, HistoryStore> histories = new HashMap<ExecutionId, HistoryStore>();
    private final Map<TestWorkflowStore.TaskQueueId, BlockingQueue<PollActivityTaskQueueResponse.Builder>> activityTaskQueues = new HashMap<TestWorkflowStore.TaskQueueId, BlockingQueue<PollActivityTaskQueueResponse.Builder>>();
    private final Map<TestWorkflowStore.TaskQueueId, BlockingQueue<PollWorkflowTaskQueueResponse.Builder>> workflowTaskQueues = new HashMap<TestWorkflowStore.TaskQueueId, BlockingQueue<PollWorkflowTaskQueueResponse.Builder>>();
    private final SelfAdvancingTimer timerService;

    public TestWorkflowStoreImpl(long initialTimeMillis) {
        this.timerService = new SelfAdvancingTimerImpl(initialTimeMillis);
        this.timerService.lockTimeSkipping("TestWorkflowStoreImpl constructor");
    }

    @Override
    public SelfAdvancingTimer getTimer() {
        return this.timerService;
    }

    @Override
    public Timestamp currentTime() {
        return Timestamps.fromMillis((long)this.timerService.getClock().getAsLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long save(RequestContext ctx) {
        List<RequestContext.Timer> timers;
        List<TestWorkflowStore.ActivityTask> activityTasks;
        long result;
        this.lock.lock();
        boolean historiesEmpty = this.histories.isEmpty();
        try {
            ExecutionId executionId = ctx.getExecutionId();
            HistoryStore history = this.histories.get(executionId);
            List<HistoryEvent> events = ctx.getEvents();
            if (history == null) {
                if (events.isEmpty() || events.get(0).getEventType() != EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED) {
                    throw new IllegalStateException("No history found for " + executionId);
                }
                history = new HistoryStore(executionId, this.lock);
                this.histories.put(executionId, history);
            }
            history.checkNextEventId(ctx.getInitialEventId());
            history.addAllLocked(events, ctx.currentTime());
            result = history.getNextEventIdLocked();
            this.timerService.updateLocks(ctx.getTimerLocks());
            ctx.fireCallbacks(history.getEventsLocked().size());
        }
        finally {
            if (historiesEmpty && !this.histories.isEmpty()) {
                this.timerService.unlockTimeSkipping("TestWorkflowStoreImpl save");
            }
            this.lock.unlock();
        }
        TestWorkflowStore.WorkflowTask workflowTask = ctx.getWorkflowTask();
        if (workflowTask != null) {
            StickyExecutionAttributes attributes = ctx.getWorkflowMutableState().getStickyExecutionAttributes();
            TestWorkflowStore.TaskQueueId id = new TestWorkflowStore.TaskQueueId(workflowTask.getTaskQueueId().getNamespace(), attributes == null ? workflowTask.getTaskQueueId().getTaskQueueName() : attributes.getWorkerTaskQueue().getName());
            if (id.getTaskQueueName().isEmpty() || id.getNamespace().isEmpty()) {
                throw Status.INTERNAL.withDescription("Invalid TaskQueueId: " + id).asRuntimeException();
            }
            BlockingQueue<PollWorkflowTaskQueueResponse.Builder> workflowTaskQueue = this.getWorkflowTaskQueueQueue(id);
            workflowTaskQueue.add(workflowTask.getTask());
        }
        if ((activityTasks = ctx.getActivityTasks()) != null) {
            for (TestWorkflowStore.ActivityTask activityTask : activityTasks) {
                BlockingQueue<PollActivityTaskQueueResponse.Builder> activityTaskQueue = this.getActivityTaskQueueQueue(activityTask.getTaskQueueId());
                activityTaskQueue.add(activityTask.getTask());
            }
        }
        if ((timers = ctx.getTimers()) != null) {
            for (RequestContext.Timer t : timers) {
                log.trace("scheduling timer with " + t.getDelay() + "delay. Current time=" + this.currentTime());
                Functions.Proc cancellationHandle = this.timerService.schedule(t.getDelay(), t.getCallback(), t.getTaskInfo());
                t.setCancellationHandle(cancellationHandle);
            }
        }
        return result;
    }

    @Override
    public void applyTimersAndLocks(RequestContext ctx) {
        this.lock.lock();
        try {
            this.timerService.updateLocks(ctx.getTimerLocks());
        }
        finally {
            this.lock.unlock();
        }
        List<RequestContext.Timer> timers = ctx.getTimers();
        if (timers != null) {
            for (RequestContext.Timer t : timers) {
                Functions.Proc cancellationHandle = this.timerService.schedule(t.getDelay(), t.getCallback(), t.getTaskInfo());
                t.setCancellationHandle(cancellationHandle);
            }
        }
        ctx.clearTimersAndLocks();
    }

    @Override
    public void registerDelayedCallback(Duration delay, Runnable r) {
        this.timerService.schedule(delay, r, "registerDelayedCallback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<PollActivityTaskQueueResponse.Builder> getActivityTaskQueueQueue(TestWorkflowStore.TaskQueueId taskQueueId) {
        this.lock.lock();
        try {
            BlockingQueue<PollActivityTaskQueueResponse.Builder> activityTaskQueue = this.activityTaskQueues.get(taskQueueId);
            if (activityTaskQueue == null) {
                activityTaskQueue = new LinkedBlockingQueue<PollActivityTaskQueueResponse.Builder>();
                this.activityTaskQueues.put(taskQueueId, activityTaskQueue);
            }
            BlockingQueue<PollActivityTaskQueueResponse.Builder> blockingQueue = activityTaskQueue;
            return blockingQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<PollWorkflowTaskQueueResponse.Builder> getWorkflowTaskQueueQueue(TestWorkflowStore.TaskQueueId taskQueueId) {
        this.lock.lock();
        try {
            BlockingQueue<PollWorkflowTaskQueueResponse.Builder> workflowTaskQueue = this.workflowTaskQueues.get(taskQueueId);
            if (workflowTaskQueue == null) {
                workflowTaskQueue = new LinkedBlockingQueue<PollWorkflowTaskQueueResponse.Builder>();
                this.workflowTaskQueues.put(taskQueueId, workflowTaskQueue);
            }
            BlockingQueue<PollWorkflowTaskQueueResponse.Builder> blockingQueue = workflowTaskQueue;
            return blockingQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Optional<PollWorkflowTaskQueueResponse.Builder> pollWorkflowTaskQueue(PollWorkflowTaskQueueRequest pollRequest, Deadline deadline) {
        TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(pollRequest.getNamespace(), pollRequest.getTaskQueue().getName());
        BlockingQueue<PollWorkflowTaskQueueResponse.Builder> workflowTaskQueue = this.getWorkflowTaskQueueQueue(taskQueueId);
        if (log.isTraceEnabled()) {
            log.trace("Poll request on workflow task queue about to block waiting for a task on " + taskQueueId);
        }
        PollWorkflowTaskQueueResponse.Builder result = null;
        try {
            result = deadline == null ? workflowTaskQueue.take() : workflowTaskQueue.poll(deadline.timeRemaining(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Optional.ofNullable(result);
    }

    @Override
    public Optional<PollActivityTaskQueueResponse.Builder> pollActivityTaskQueue(PollActivityTaskQueueRequest pollRequest, Deadline deadline) {
        TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(pollRequest.getNamespace(), pollRequest.getTaskQueue().getName());
        BlockingQueue<PollActivityTaskQueueResponse.Builder> activityTaskQueue = this.getActivityTaskQueueQueue(taskQueueId);
        PollActivityTaskQueueResponse.Builder result = null;
        try {
            result = deadline == null ? activityTaskQueue.take() : activityTaskQueue.poll(deadline.timeRemaining(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Optional.ofNullable(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueryTask(ExecutionId executionId, TestWorkflowStore.TaskQueueId taskQueue, PollWorkflowTaskQueueResponse.Builder task) {
        this.lock.lock();
        try {
            HistoryStore historyStore = this.getHistoryStore(executionId);
            ArrayList<HistoryEvent> events = new ArrayList<HistoryEvent>(historyStore.getEventsLocked());
            History.Builder history = History.newBuilder();
            PeekingIterator iterator = Iterators.peekingIterator(events.iterator());
            long startedEventId = 0L;
            long previousStaredEventId = 0L;
            while (iterator.hasNext()) {
                HistoryEvent event = (HistoryEvent)iterator.next();
                if (event.getEventType() == EventType.EVENT_TYPE_WORKFLOW_TASK_STARTED) {
                    if (iterator.hasNext() && ((HistoryEvent)iterator.peek()).getEventType() != EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED) continue;
                    previousStaredEventId = startedEventId;
                    startedEventId = event.getEventId();
                    continue;
                }
                if (!WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent((HistoryEventOrBuilder)event)) continue;
                previousStaredEventId = startedEventId;
                startedEventId = 0L;
                if (!iterator.hasNext()) continue;
                throw Status.INTERNAL.withDescription("Unexpected event after the completion event: " + iterator.peek()).asRuntimeException();
            }
            task.setPreviousStartedEventId(previousStaredEventId);
            task.setStartedEventId(startedEventId);
            if (taskQueue.getTaskQueueName().equals(task.getWorkflowExecutionTaskQueue().getName())) {
                history.addAllEvents(events);
            } else {
                history.addAllEvents(new ArrayList());
            }
            task.setHistory(history);
        }
        finally {
            this.lock.unlock();
        }
        BlockingQueue<PollWorkflowTaskQueueResponse.Builder> workflowTaskQueue = this.getWorkflowTaskQueueQueue(taskQueue);
        workflowTaskQueue.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(ExecutionId executionId, GetWorkflowExecutionHistoryRequest getRequest, Deadline deadline) {
        long expectedNextEventId;
        HistoryStore history;
        this.lock.lock();
        try {
            history = this.getHistoryStore(executionId);
            if (!getRequest.getWaitNewEvent() && getRequest.getHistoryEventFilterType() != HistoryEventFilterType.HISTORY_EVENT_FILTER_TYPE_CLOSE_EVENT) {
                List<HistoryEvent> events = history.getEventsLocked();
                ArrayList<HistoryEvent> eventsCopy = new ArrayList<HistoryEvent>(events);
                GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistoryResponse = GetWorkflowExecutionHistoryResponse.newBuilder().setHistory(History.newBuilder().addAllEvents(eventsCopy)).build();
                return getWorkflowExecutionHistoryResponse;
            }
            expectedNextEventId = history.getNextEventIdLocked();
        }
        finally {
            this.lock.unlock();
        }
        List<HistoryEvent> events = history.waitForNewEvents(expectedNextEventId, getRequest.getHistoryEventFilterType(), deadline);
        GetWorkflowExecutionHistoryResponse.Builder result = GetWorkflowExecutionHistoryResponse.newBuilder();
        if (events != null) {
            result.setHistory(History.newBuilder().addAllEvents(events));
        }
        return result.build();
    }

    private HistoryStore getHistoryStore(ExecutionId executionId) {
        HistoryStore result = this.histories.get(executionId);
        if (result == null) {
            WorkflowExecution execution = executionId.getExecution();
            throw Status.NOT_FOUND.withDescription(String.format("Workflow execution result not found.  WorkflowId: %s, RunId: %s", execution.getWorkflowId(), execution.getRunId())).asRuntimeException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDiagnostics(StringBuilder result) {
        result.append("Stored Workflows:\n");
        this.lock.lock();
        try {
            for (Map.Entry<ExecutionId, HistoryStore> entry : this.histories.entrySet()) {
                result.append(entry.getKey());
                result.append("\n");
                result.append(WorkflowExecutionUtils.prettyPrintHistory(entry.getValue().getEventsLocked().iterator(), (boolean)true));
                result.append("\n");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<WorkflowExecutionInfo> listWorkflows(TestWorkflowStore.WorkflowState state, Optional<String> filterWorkflowId) {
        ArrayList<WorkflowExecutionInfo> result = new ArrayList<WorkflowExecutionInfo>();
        for (Map.Entry<ExecutionId, HistoryStore> entry : this.histories.entrySet()) {
            WorkflowExecutionInfo info;
            List<HistoryEvent> history;
            String workflowId;
            ExecutionId executionId;
            if (state == TestWorkflowStore.WorkflowState.OPEN) {
                if (entry.getValue().isCompleted()) continue;
                executionId = entry.getKey();
                workflowId = executionId.getWorkflowId().getWorkflowId();
                if (filterWorkflowId.isPresent() && !workflowId.equals(filterWorkflowId.get())) continue;
                history = entry.getValue().getHistory();
                info = WorkflowExecutionInfo.newBuilder().setExecution(executionId.getExecution()).setHistoryLength((long)history.size()).setStartTime(history.get(0).getEventTime()).setType(history.get(0).getWorkflowExecutionStartedEventAttributes().getWorkflowType()).build();
                result.add(info);
                continue;
            }
            if (!entry.getValue().isCompleted()) continue;
            executionId = entry.getKey();
            workflowId = executionId.getWorkflowId().getWorkflowId();
            if (filterWorkflowId.isPresent() && !workflowId.equals(filterWorkflowId.get())) continue;
            history = entry.getValue().getHistory();
            info = WorkflowExecutionInfo.newBuilder().setExecution(executionId.getExecution()).setHistoryLength((long)history.size()).setStartTime(history.get(0).getEventTime()).setType(history.get(0).getWorkflowExecutionStartedEventAttributes().getWorkflowType()).setStatus(WorkflowExecutionUtils.getCloseStatus((HistoryEvent)history.get(history.size() - 1))).build();
            result.add(info);
        }
        return result;
    }

    @Override
    public void close() {
        this.timerService.shutdown();
    }

    private static class HistoryStore {
        private final Lock lock;
        private final Condition newEventsCondition;
        private final ExecutionId id;
        private final List<HistoryEvent> history = new ArrayList<HistoryEvent>();
        private boolean completed;

        private HistoryStore(ExecutionId id, Lock lock) {
            this.id = id;
            this.lock = lock;
            this.newEventsCondition = lock.newCondition();
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public List<HistoryEvent> getHistory() {
            return this.history;
        }

        private void checkNextEventId(long nextEventId) {
            if (nextEventId != (long)this.history.size() + 1L && nextEventId != 0L && this.history.size() != 0) {
                throw new IllegalStateException("NextEventId=" + nextEventId + ", historySize=" + this.history.size() + " for " + this.id);
            }
        }

        void addAllLocked(List<HistoryEvent> events, Timestamp eventTime) {
            for (HistoryEvent event : events) {
                HistoryEvent.Builder eBuilder = event.toBuilder();
                if (this.completed) {
                    throw Status.FAILED_PRECONDITION.withDescription("Attempt to add an eBuilder after a completion eBuilder: " + WorkflowExecutionUtils.prettyPrintObject((MessageOrBuilder)eBuilder)).asRuntimeException();
                }
                eBuilder.setEventId((long)this.history.size() + 1L);
                if (Timestamps.toMillis((Timestamp)eBuilder.getEventTime()) == 0L) {
                    eBuilder.setEventTime(eventTime);
                }
                this.history.add(eBuilder.build());
                this.completed = this.completed || WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent((HistoryEventOrBuilder)eBuilder);
            }
            this.newEventsCondition.signal();
        }

        long getNextEventIdLocked() {
            return (long)this.history.size() + 1L;
        }

        List<HistoryEvent> getEventsLocked() {
            return this.history;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        List<HistoryEvent> waitForNewEvents(long expectedNextEventId, HistoryEventFilterType filterType, Deadline deadline) {
            block15: {
                start = System.currentTimeMillis();
                this.lock.lock();
                while (true) {
                    if (this.completed || this.getNextEventIdLocked() > expectedNextEventId) {
                        if (filterType == HistoryEventFilterType.HISTORY_EVENT_FILTER_TYPE_CLOSE_EVENT) {
                            if (this.completed) {
                                result = new ArrayList<HistoryEvent>(1);
                                result.add(this.history.get(this.history.size() - 1));
                                var8_9 = result;
                                return var8_9;
                            }
                            expectedNextEventId = this.getNextEventIdLocked();
                            continue;
                        }
                        break block15;
                    }
                    if (deadline == null) ** GOTO lbl25
                    toWait = deadline.timeRemaining(TimeUnit.MILLISECONDS) - System.currentTimeMillis() + start;
                    if (toWait <= 0L) {
                        var9_13 = null;
                        return var9_13;
                    }
                    try {
                        this.newEventsCondition.await(toWait, TimeUnit.MILLISECONDS);
                        continue;
lbl25:
                        // 1 sources

                        this.newEventsCondition.await();
                    }
                    catch (InterruptedException e) {
                        var8_12 = null;
                        return var8_12;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            result = new ArrayList<HistoryEvent>((int)(this.getNextEventIdLocked() - expectedNextEventId));
            i = (int)expectedNextEventId;
            while (true) {
                if ((long)i >= this.getNextEventIdLocked()) {
                    var8_11 = result;
                    return var8_11;
                }
                result.add(this.history.get(i));
                ++i;
            }
        }
    }
}

