/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.Duration;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.command.v1.CancelTimerCommandAttributes;
import io.temporal.api.command.v1.CancelWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.CompleteWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.FailWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.RequestCancelActivityTaskCommandAttributes;
import io.temporal.api.command.v1.RequestCancelExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartTimerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.CancelExternalWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.enums.v1.SignalExternalWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.StartChildWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.TimeoutType;
import io.temporal.api.errordetails.v1.QueryFailedFailure;
import io.temporal.api.failure.v1.ApplicationFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.failure.v1.TimeoutFailureInfo;
import io.temporal.api.history.v1.ActivityTaskCancelRequestedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskCanceledEventAttributes;
import io.temporal.api.history.v1.ActivityTaskCompletedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskFailedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskScheduledEventAttributes;
import io.temporal.api.history.v1.ActivityTaskStartedEventAttributes;
import io.temporal.api.history.v1.ActivityTaskTimedOutEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionCanceledEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionCompletedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionStartedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionTimedOutEventAttributes;
import io.temporal.api.history.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes;
import io.temporal.api.history.v1.ExternalWorkflowExecutionSignaledEventAttributes;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.RequestCancelExternalWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes;
import io.temporal.api.history.v1.SignalExternalWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.SignalExternalWorkflowExecutionInitiatedEventAttributes;
import io.temporal.api.history.v1.StartChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.StartChildWorkflowExecutionInitiatedEventAttributes;
import io.temporal.api.history.v1.TimerCanceledEventAttributes;
import io.temporal.api.history.v1.TimerFiredEventAttributes;
import io.temporal.api.history.v1.TimerStartedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionCancelRequestedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionCanceledEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionCompletedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionTerminatedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionTimedOutEventAttributes;
import io.temporal.api.history.v1.WorkflowTaskCompletedEventAttributes;
import io.temporal.api.history.v1.WorkflowTaskFailedEventAttributes;
import io.temporal.api.history.v1.WorkflowTaskScheduledEventAttributes;
import io.temporal.api.history.v1.WorkflowTaskStartedEventAttributes;
import io.temporal.api.history.v1.WorkflowTaskTimedOutEventAttributes;
import io.temporal.api.query.v1.WorkflowQueryResult;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.StatusUtils;
import io.temporal.internal.testservice.ActivityId;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.StateMachine;
import io.temporal.internal.testservice.TestServiceRetryState;
import io.temporal.internal.testservice.TestWorkflowMutableState;
import io.temporal.internal.testservice.TestWorkflowMutableStateImpl;
import io.temporal.internal.testservice.TestWorkflowService;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.internal.testservice.WorkflowTaskToken;
import io.temporal.workflow.Functions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateMachines {
    private static final Logger log = LoggerFactory.getLogger(StateMachines.class);
    static final int NO_EVENT_ID = -1;
    static final Duration DEFAULT_ACTIVITY_RETRY_INITIAL_INTERVAL = Durations.fromSeconds((long)1L);
    static final double DEFAULT_ACTIVITY_RETRY_BACKOFF_COEFFICIENT = 2.0;
    static final int DEFAULT_ACTIVITY_RETRY_MAXIMUM_ATTEMPTS = 0;
    static final int DEFAULT_ACTIVITY_MAXIMUM_INTERVAL_COEFFICIENT = 100;
    public static final long DEFAULT_WORKFLOW_EXECUTION_TIMEOUT_MILLISECONDS = 315360000000L;
    public static final long DEFAULT_WORKFLOW_TASK_TIMEOUT_MILLISECONDS = 10000L;
    public static final long MAX_WORKFLOW_TASK_TIMEOUT_MILLISECONDS = 60000L;

    StateMachines() {
    }

    static StateMachine<WorkflowData> newWorkflowStateMachine(WorkflowData data) {
        return new StateMachine<WorkflowData>(data).add(State.NONE, Action.START, State.STARTED, StateMachines::startWorkflow).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeWorkflow).add(State.STARTED, Action.CONTINUE_AS_NEW, State.CONTINUED_AS_NEW, StateMachines::continueAsNewWorkflow).add(State.STARTED, Action.FAIL, State.FAILED, StateMachines::failWorkflow).add(State.STARTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutWorkflow).add(State.STARTED, Action.REQUEST_CANCELLATION, State.CANCELLATION_REQUESTED, StateMachines::requestWorkflowCancellation).add(State.STARTED, Action.TERMINATE, State.TERMINATED, StateMachines::terminateWorkflow).add(State.CANCELLATION_REQUESTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeWorkflow).add(State.CANCELLATION_REQUESTED, Action.CANCEL, State.CANCELED, StateMachines::cancelWorkflow).add(State.CANCELLATION_REQUESTED, Action.TERMINATE, State.TERMINATED, StateMachines::terminateWorkflow).add(State.CANCELLATION_REQUESTED, Action.FAIL, State.FAILED, StateMachines::failWorkflow).add(State.CANCELLATION_REQUESTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutWorkflow);
    }

    static StateMachine<WorkflowTaskData> newCommandStateMachine(TestWorkflowStore store, StartWorkflowExecutionRequest startRequest) {
        return new StateMachine<WorkflowTaskData>(new WorkflowTaskData(store, startRequest)).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::scheduleWorkflowTask).add(State.STARTED, Action.QUERY, State.STARTED, StateMachines::bufferQuery).add(State.INITIATED, Action.INITIATE, State.INITIATED, StateMachines::noop).add(State.INITIATED, Action.QUERY, State.INITIATED, StateMachines::queryWhileScheduled).add(State.INITIATED, Action.START, State.STARTED, StateMachines::startWorkflowTask).add(State.STARTED, Action.COMPLETE, State.NONE, StateMachines::completeWorkflowTask).add(State.STARTED, Action.FAIL, State.NONE, StateMachines::failWorkflowTask).add(State.STARTED, Action.TIME_OUT, State.NONE, StateMachines::timeoutWorkflowTask).add(State.STARTED, Action.INITIATE, State.STARTED, StateMachines::needsWorkflowTask);
    }

    public static StateMachine<ActivityTaskData> newActivityStateMachine(TestWorkflowStore store, StartWorkflowExecutionRequest workflowStartedEvent) {
        return new StateMachine<ActivityTaskData>(new ActivityTaskData(store, workflowStartedEvent)).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::scheduleActivityTask).add(State.INITIATED, Action.START, State.STARTED, StateMachines::startActivityTask).add(State.INITIATED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutActivityTask).add(State.INITIATED, Action.REQUEST_CANCELLATION, State.CANCELLATION_REQUESTED, StateMachines::requestActivityCancellation).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeActivityTask).add(State.STARTED, Action.FAIL, new State[]{State.FAILED, State.INITIATED}, StateMachines::failActivityTask).add(State.STARTED, Action.TIME_OUT, new State[]{State.TIMED_OUT, State.INITIATED}, StateMachines::timeoutActivityTask).add(State.STARTED, Action.UPDATE, State.STARTED, StateMachines::heartbeatActivityTask).add(State.STARTED, Action.REQUEST_CANCELLATION, State.CANCELLATION_REQUESTED, StateMachines::requestActivityCancellation).add(State.CANCELLATION_REQUESTED, Action.CANCEL, State.CANCELED, StateMachines::reportActivityTaskCancellation).add(State.CANCELLATION_REQUESTED, Action.COMPLETE, State.COMPLETED, StateMachines::completeActivityTask).add(State.CANCELLATION_REQUESTED, Action.UPDATE, State.CANCELLATION_REQUESTED, StateMachines::heartbeatActivityTask).add(State.CANCELLATION_REQUESTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutActivityTask).add(State.CANCELLATION_REQUESTED, Action.FAIL, State.FAILED, StateMachines::failActivityTask);
    }

    public static StateMachine<ChildWorkflowData> newChildWorkflowStateMachine(TestWorkflowService service) {
        return new StateMachine<ChildWorkflowData>(new ChildWorkflowData(service)).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::initiateChildWorkflow).add(State.INITIATED, Action.START, State.STARTED, StateMachines::childWorkflowStarted).add(State.INITIATED, Action.FAIL, State.FAILED, StateMachines::startChildWorkflowFailed).add(State.INITIATED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutChildWorkflow).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::childWorkflowCompleted).add(State.STARTED, Action.FAIL, State.FAILED, StateMachines::childWorkflowFailed).add(State.STARTED, Action.TIME_OUT, State.TIMED_OUT, StateMachines::timeoutChildWorkflow).add(State.STARTED, Action.CANCEL, State.CANCELED, StateMachines::childWorkflowCanceled);
    }

    public static StateMachine<TimerData> newTimerStateMachine() {
        return new StateMachine<TimerData>(new TimerData()).add(State.NONE, Action.START, State.STARTED, StateMachines::startTimer).add(State.STARTED, Action.COMPLETE, State.COMPLETED, StateMachines::fireTimer).add(State.STARTED, Action.CANCEL, State.CANCELED, StateMachines::cancelTimer);
    }

    public static StateMachine<SignalExternalData> newSignalExternalStateMachine() {
        return new StateMachine<SignalExternalData>(new SignalExternalData()).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::initiateExternalSignal).add(State.INITIATED, Action.FAIL, State.FAILED, StateMachines::failExternalSignal).add(State.INITIATED, Action.COMPLETE, State.COMPLETED, StateMachines::completeExternalSignal);
    }

    public static StateMachine<CancelExternalData> newCancelExternalStateMachine() {
        return new StateMachine<CancelExternalData>(new CancelExternalData()).add(State.NONE, Action.INITIATE, State.INITIATED, StateMachines::initiateExternalCancellation).add(State.INITIATED, Action.FAIL, State.FAILED, StateMachines::failExternalCancellation).add(State.INITIATED, Action.START, State.STARTED, StateMachines::reportExternalCancellationRequested);
    }

    private static <T, A> void noop(RequestContext ctx, T data, A a, long notUsed) {
    }

    private static void timeoutChildWorkflow(RequestContext ctx, ChildWorkflowData data, RetryState retryState, long notUsed) {
        StartChildWorkflowExecutionInitiatedEventAttributes ie = data.initiatedEvent;
        ChildWorkflowExecutionTimedOutEventAttributes a = ChildWorkflowExecutionTimedOutEventAttributes.newBuilder().setNamespace(ie.getNamespace()).setStartedEventId(data.startedEventId).setWorkflowExecution(data.execution).setWorkflowType(ie.getWorkflowType()).setRetryState(retryState).setInitiatedEventId(data.initiatedEventId).build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_TIMED_OUT).setChildWorkflowExecutionTimedOutEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void startChildWorkflowFailed(RequestContext ctx, ChildWorkflowData data, StartChildWorkflowExecutionFailedEventAttributes a, long notUsed) {
        StartChildWorkflowExecutionFailedEventAttributes.Builder updatedAttr = a.toBuilder().setInitiatedEventId(data.initiatedEventId).setWorkflowType(data.initiatedEvent.getWorkflowType()).setWorkflowId(data.initiatedEvent.getWorkflowId());
        if (!data.initiatedEvent.getNamespace().isEmpty()) {
            updatedAttr.setNamespace(data.initiatedEvent.getNamespace());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_FAILED).setStartChildWorkflowExecutionFailedEventAttributes(updatedAttr.build()).build();
        ctx.addEvent(event);
    }

    private static void childWorkflowStarted(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionStartedEventAttributes a, long notUsed) {
        ChildWorkflowExecutionStartedEventAttributes updatedAttr = a.toBuilder().setInitiatedEventId(data.initiatedEventId).build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_STARTED).setChildWorkflowExecutionStartedEventAttributes(updatedAttr).build();
        long startedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.startedEventId = startedEventId;
            data.execution = updatedAttr.getWorkflowExecution();
        });
    }

    private static void childWorkflowCompleted(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionCompletedEventAttributes a, long notUsed) {
        ChildWorkflowExecutionCompletedEventAttributes updatedAttr = a.toBuilder().setInitiatedEventId(data.initiatedEventId).setStartedEventId(data.startedEventId).build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_COMPLETED).setChildWorkflowExecutionCompletedEventAttributes(updatedAttr).build();
        ctx.addEvent(event);
    }

    private static void childWorkflowFailed(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionFailedEventAttributes a, long notUsed) {
        ChildWorkflowExecutionFailedEventAttributes.Builder updatedAttr = a.toBuilder().setInitiatedEventId(data.initiatedEventId).setStartedEventId(data.startedEventId).setWorkflowExecution(data.execution).setWorkflowType(data.initiatedEvent.getWorkflowType());
        if (!data.initiatedEvent.getNamespace().isEmpty()) {
            updatedAttr.setNamespace(data.initiatedEvent.getNamespace());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_FAILED).setChildWorkflowExecutionFailedEventAttributes(updatedAttr.build()).build();
        ctx.addEvent(event);
    }

    private static void childWorkflowCanceled(RequestContext ctx, ChildWorkflowData data, ChildWorkflowExecutionCanceledEventAttributes a, long notUsed) {
        ChildWorkflowExecutionCanceledEventAttributes updatedAttr = a.toBuilder().setInitiatedEventId(data.initiatedEventId).setStartedEventId(data.startedEventId).build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_CANCELED).setChildWorkflowExecutionCanceledEventAttributes(updatedAttr).build();
        ctx.addEvent(event);
    }

    private static void initiateChildWorkflow(RequestContext ctx, ChildWorkflowData data, StartChildWorkflowExecutionCommandAttributes d, long workflowTaskCompletedEventId) {
        StartChildWorkflowExecutionInitiatedEventAttributes.Builder a = StartChildWorkflowExecutionInitiatedEventAttributes.newBuilder().setControl(d.getControl()).setInput(d.getInput()).setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId).setNamespace(d.getNamespace().isEmpty() ? ctx.getNamespace() : d.getNamespace()).setWorkflowExecutionTimeout(d.getWorkflowExecutionTimeout()).setWorkflowRunTimeout(d.getWorkflowRunTimeout()).setWorkflowTaskTimeout(d.getWorkflowTaskTimeout()).setTaskQueue(d.getTaskQueue()).setWorkflowId(d.getWorkflowId()).setWorkflowIdReusePolicy(d.getWorkflowIdReusePolicy()).setWorkflowType(d.getWorkflowType()).setCronSchedule(d.getCronSchedule()).setParentClosePolicy(d.getParentClosePolicy());
        if (d.hasHeader()) {
            a.setHeader(d.getHeader());
        }
        if (d.hasMemo()) {
            a.setMemo(d.getMemo());
        }
        if (d.hasRetryPolicy()) {
            a.setRetryPolicy(d.getRetryPolicy());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_INITIATED).setStartChildWorkflowExecutionInitiatedEventAttributes(a).build();
        long initiatedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.initiatedEventId = initiatedEventId;
            data.initiatedEvent = a.build();
            StartWorkflowExecutionRequest.Builder startChild = StartWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setNamespace(d.getNamespace().isEmpty() ? ctx.getNamespace() : d.getNamespace()).setWorkflowExecutionTimeout(d.getWorkflowExecutionTimeout()).setWorkflowRunTimeout(d.getWorkflowRunTimeout()).setWorkflowTaskTimeout(d.getWorkflowTaskTimeout()).setTaskQueue(d.getTaskQueue()).setWorkflowId(d.getWorkflowId()).setWorkflowIdReusePolicy(d.getWorkflowIdReusePolicy()).setWorkflowType(d.getWorkflowType()).setCronSchedule(d.getCronSchedule());
            if (d.hasHeader()) {
                startChild.setHeader(d.getHeader());
            }
            if (d.hasMemo()) {
                startChild.setMemo(d.getMemo());
            }
            if (d.hasRetryPolicy()) {
                startChild.setRetryPolicy(d.getRetryPolicy());
            }
            if (d.hasInput()) {
                startChild.setInput(d.getInput());
            }
            StateMachines.addStartChildTask(ctx, data, initiatedEventId, startChild.build());
        });
    }

    private static void addStartChildTask(RequestContext ctx, ChildWorkflowData data, long initiatedEventId, StartWorkflowExecutionRequest startChild) {
        ForkJoinPool.commonPool().execute(() -> {
            try {
                data.service.startWorkflowExecutionImpl(startChild, java.time.Duration.ZERO, Optional.of(ctx.getWorkflowMutableState()), OptionalLong.of(data.initiatedEventId), Optional.empty());
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.ALREADY_EXISTS) {
                    StartChildWorkflowExecutionFailedEventAttributes failRequest = StartChildWorkflowExecutionFailedEventAttributes.newBuilder().setInitiatedEventId(initiatedEventId).setCause(StartChildWorkflowExecutionFailedCause.START_CHILD_WORKFLOW_EXECUTION_FAILED_CAUSE_WORKFLOW_ALREADY_EXISTS).build();
                    try {
                        ctx.getWorkflowMutableState().failStartChildWorkflow(data.initiatedEvent.getWorkflowId(), failRequest);
                    }
                    catch (Throwable ee) {
                        log.error("Unexpected failure inserting failStart for a child workflow", ee);
                    }
                } else {
                    log.error("Unexpected failure starting a child workflow", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("Unexpected failure starting a child workflow", (Throwable)e);
            }
        });
    }

    private static void startWorkflow(RequestContext ctx, WorkflowData data, StartWorkflowExecutionRequest request, long notUsed) {
        Optional<TestWorkflowMutableState> parent;
        String cronSchedule;
        if (Durations.compare((Duration)request.getWorkflowExecutionTimeout(), (Duration)Durations.ZERO) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("negative workflowExecution timeout").asRuntimeException();
        }
        if (Durations.compare((Duration)request.getWorkflowRunTimeout(), (Duration)Durations.ZERO) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("negative workflowRun timeout").asRuntimeException();
        }
        if (Durations.compare((Duration)request.getWorkflowTaskTimeout(), (Duration)Durations.ZERO) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("negative workflowTaskTimeoutSeconds").asRuntimeException();
        }
        WorkflowExecutionStartedEventAttributes.Builder a = WorkflowExecutionStartedEventAttributes.newBuilder().setWorkflowType(request.getWorkflowType()).setWorkflowRunTimeout(request.getWorkflowRunTimeout()).setWorkflowTaskTimeout(request.getWorkflowTaskTimeout()).setWorkflowExecutionTimeout(request.getWorkflowExecutionTimeout()).setIdentity(request.getIdentity()).setInput(request.getInput()).setTaskQueue(request.getTaskQueue()).setAttempt(1);
        if (data.retryState.isPresent()) {
            a.setAttempt(data.retryState.get().getAttempt());
        }
        a.setOriginalExecutionRunId(data.originalExecutionRunId);
        if (data.continuedExecutionRunId.isPresent()) {
            a.setContinuedExecutionRunId(data.continuedExecutionRunId.get());
        }
        if (data.lastCompletionResult != null) {
            a.setLastCompletionResult(data.lastCompletionResult);
        }
        if (data.lastFailure.isPresent()) {
            a.setContinuedFailure(data.lastFailure.get());
        }
        if (request.hasMemo()) {
            a.setMemo(request.getMemo());
        }
        if (request.hasSearchAttributes()) {
            a.setSearchAttributes(request.getSearchAttributes());
        }
        if (request.hasHeader()) {
            a.setHeader(request.getHeader());
        }
        if (!(cronSchedule = request.getCronSchedule()).trim().isEmpty()) {
            try {
                TestWorkflowMutableStateImpl.parseCron(cronSchedule);
                a.setCronSchedule(cronSchedule);
            }
            catch (Exception e) {
                throw Status.INVALID_ARGUMENT.withDescription("Invalid cron expression \"" + cronSchedule + "\": " + e.getMessage()).withCause((Throwable)e).asRuntimeException();
            }
        }
        if ((parent = ctx.getWorkflowMutableState().getParent()).isPresent()) {
            ExecutionId parentExecutionId = parent.get().getExecutionId();
            a.setParentWorkflowNamespace(parentExecutionId.getNamespace());
            a.setParentWorkflowExecution(parentExecutionId.getExecution());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED).setWorkflowExecutionStartedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void completeWorkflow(RequestContext ctx, WorkflowData data, CompleteWorkflowExecutionCommandAttributes d, long workflowTaskCompletedEventId) {
        WorkflowExecutionCompletedEventAttributes.Builder a = WorkflowExecutionCompletedEventAttributes.newBuilder().setResult(d.getResult()).setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_COMPLETED).setWorkflowExecutionCompletedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void continueAsNewWorkflow(RequestContext ctx, WorkflowData data, ContinueAsNewWorkflowExecutionCommandAttributes d, long workflowTaskCompletedEventId) {
        StartWorkflowExecutionRequest sr = ctx.getWorkflowMutableState().getStartRequest();
        WorkflowExecutionContinuedAsNewEventAttributes.Builder a = WorkflowExecutionContinuedAsNewEventAttributes.newBuilder();
        a.setInput(d.getInput());
        if (Durations.compare((Duration)d.getWorkflowRunTimeout(), (Duration)Durations.ZERO) > 0) {
            a.setWorkflowRunTimeout(d.getWorkflowRunTimeout());
        } else {
            a.setWorkflowRunTimeout(sr.getWorkflowRunTimeout());
        }
        if (d.hasTaskQueue()) {
            a.setTaskQueue(d.getTaskQueue());
        } else {
            a.setTaskQueue(sr.getTaskQueue());
        }
        if (d.hasWorkflowType()) {
            a.setWorkflowType(d.getWorkflowType());
        } else {
            a.setWorkflowType(sr.getWorkflowType());
        }
        if (Durations.compare((Duration)d.getWorkflowTaskTimeout(), (Duration)Durations.ZERO) > 0) {
            a.setWorkflowTaskTimeout(d.getWorkflowTaskTimeout());
        } else {
            a.setWorkflowTaskTimeout(sr.getWorkflowTaskTimeout());
        }
        a.setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId);
        a.setBackoffStartInterval(d.getBackoffStartInterval());
        if (d.hasLastCompletionResult()) {
            a.setLastCompletionResult(d.getLastCompletionResult());
        }
        if (d.hasFailure()) {
            a.setFailure(d.getFailure());
        }
        a.setNewExecutionRunId(UUID.randomUUID().toString());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_CONTINUED_AS_NEW).setWorkflowExecutionContinuedAsNewEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void failWorkflow(RequestContext ctx, WorkflowData data, FailWorkflowExecutionCommandAttributes d, long workflowTaskCompletedEventId) {
        WorkflowExecutionFailedEventAttributes.Builder a = WorkflowExecutionFailedEventAttributes.newBuilder().setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId);
        if (d.hasFailure()) {
            a.setFailure(d.getFailure());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_FAILED).setWorkflowExecutionFailedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void timeoutWorkflow(RequestContext ctx, WorkflowData data, RetryState retryState, long notUsed) {
        WorkflowExecutionTimedOutEventAttributes.Builder a = WorkflowExecutionTimedOutEventAttributes.newBuilder().setRetryState(retryState);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_TIMED_OUT).setWorkflowExecutionTimedOutEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void cancelWorkflow(RequestContext ctx, WorkflowData data, CancelWorkflowExecutionCommandAttributes d, long workflowTaskCompletedEventId) {
        WorkflowExecutionCanceledEventAttributes.Builder a = WorkflowExecutionCanceledEventAttributes.newBuilder().setDetails(d.getDetails()).setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_CANCELED).setWorkflowExecutionCanceledEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void terminateWorkflow(RequestContext ctx, WorkflowData data, TerminateWorkflowExecutionRequest d, long workflowTaskCompletedEventId) {
        WorkflowExecutionTerminatedEventAttributes.Builder a = WorkflowExecutionTerminatedEventAttributes.newBuilder().setDetails(d.getDetails()).setIdentity(d.getIdentity()).setReason(d.getReason());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_TERMINATED).setWorkflowExecutionTerminatedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void requestWorkflowCancellation(RequestContext ctx, WorkflowData data, RequestCancelWorkflowExecutionRequest cancelRequest, long notUsed) {
        WorkflowExecutionCancelRequestedEventAttributes.Builder a = WorkflowExecutionCancelRequestedEventAttributes.newBuilder().setIdentity(cancelRequest.getIdentity());
        HistoryEvent cancelRequested = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_CANCEL_REQUESTED).setWorkflowExecutionCancelRequestedEventAttributes(a).build();
        ctx.addEvent(cancelRequested);
    }

    private static void scheduleActivityTask(RequestContext ctx, ActivityTaskData data, ScheduleActivityTaskCommandAttributes d, long workflowTaskCompletedEventId) {
        RetryPolicy retryPolicy = StateMachines.ensureDefaultFieldsForActivityRetryPolicy(d.getRetryPolicy());
        Duration expirationInterval = d.getScheduleToCloseTimeout();
        Timestamp expirationTime = Timestamps.add((Timestamp)data.store.currentTime(), (Duration)expirationInterval);
        TestServiceRetryState retryState = new TestServiceRetryState(retryPolicy, expirationTime);
        ActivityTaskScheduledEventAttributes.Builder a = ActivityTaskScheduledEventAttributes.newBuilder().setInput(d.getInput()).setActivityId(d.getActivityId()).setActivityType(d.getActivityType()).setNamespace(d.getNamespace().isEmpty() ? ctx.getNamespace() : d.getNamespace()).setHeartbeatTimeout(d.getHeartbeatTimeout()).setRetryPolicy(retryPolicy).setScheduleToCloseTimeout(d.getScheduleToCloseTimeout()).setScheduleToStartTimeout(d.getScheduleToStartTimeout()).setStartToCloseTimeout(d.getStartToCloseTimeout()).setTaskQueue(d.getTaskQueue()).setHeader(d.getHeader()).setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId);
        data.scheduledEvent = a.build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_SCHEDULED).setActivityTaskScheduledEventAttributes(a).build();
        long scheduledEventId = ctx.addEvent(event);
        PollActivityTaskQueueResponse.Builder taskResponse = PollActivityTaskQueueResponse.newBuilder().setWorkflowNamespace(ctx.getNamespace()).setWorkflowType(data.startWorkflowExecutionRequest.getWorkflowType()).setActivityType(d.getActivityType()).setWorkflowExecution(ctx.getExecution()).setActivityId(d.getActivityId()).setInput(d.getInput()).setHeartbeatTimeout(d.getHeartbeatTimeout()).setScheduleToCloseTimeout(d.getScheduleToCloseTimeout()).setStartToCloseTimeout(d.getStartToCloseTimeout()).setScheduledTime(ctx.currentTime()).setCurrentAttemptScheduledTime(ctx.currentTime()).setHeader(d.getHeader()).setAttempt(1);
        TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(ctx.getNamespace(), d.getTaskQueue().getName());
        TestWorkflowStore.ActivityTask activityTask = new TestWorkflowStore.ActivityTask(taskQueueId, taskResponse);
        ctx.addActivityTask(activityTask);
        ctx.onCommit(historySize -> {
            data.scheduledEventId = scheduledEventId;
            data.activityTask = activityTask;
            data.retryState = retryState;
        });
    }

    private static void requestActivityCancellation(RequestContext ctx, ActivityTaskData data, RequestCancelActivityTaskCommandAttributes d, long workflowTaskCompletedEventId) {
        ActivityTaskCancelRequestedEventAttributes.Builder a = ActivityTaskCancelRequestedEventAttributes.newBuilder().setScheduledEventId(d.getScheduledEventId()).setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_CANCEL_REQUESTED).setActivityTaskCancelRequestedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void scheduleWorkflowTask(RequestContext ctx, WorkflowTaskData data, Object notUsedRequest, long notUsed) {
        StartWorkflowExecutionRequest request = data.startRequest;
        WorkflowTaskScheduledEventAttributes a = WorkflowTaskScheduledEventAttributes.newBuilder().setStartToCloseTimeout(request.getWorkflowTaskTimeout()).setTaskQueue(request.getTaskQueue()).setAttempt(data.attempt).build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_SCHEDULED).setWorkflowTaskScheduledEventAttributes(a).build();
        long scheduledEventId = ctx.addEvent(event);
        PollWorkflowTaskQueueResponse.Builder workflowTaskResponse = PollWorkflowTaskQueueResponse.newBuilder();
        workflowTaskResponse.setWorkflowExecution(ctx.getExecution());
        workflowTaskResponse.setWorkflowType(request.getWorkflowType());
        workflowTaskResponse.setAttempt(data.attempt);
        workflowTaskResponse.setScheduledTime(ctx.currentTime());
        TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(ctx.getNamespace(), request.getTaskQueue().getName());
        TestWorkflowStore.WorkflowTask workflowTask = new TestWorkflowStore.WorkflowTask(taskQueueId, workflowTaskResponse);
        ctx.setWorkflowTask(workflowTask);
        ctx.onCommit(historySize -> {
            data.scheduledEventId = scheduledEventId;
            data.workflowTask = workflowTaskResponse;
        });
    }

    private static void convertQueryWorkflowTaskToReal(RequestContext ctx, WorkflowTaskData data, Object notUsedRequest, long notUsed) {
        StartWorkflowExecutionRequest request = data.startRequest;
        WorkflowTaskScheduledEventAttributes a = WorkflowTaskScheduledEventAttributes.newBuilder().setStartToCloseTimeout(request.getWorkflowTaskTimeout()).setTaskQueue(request.getTaskQueue()).setAttempt(data.attempt).build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_SCHEDULED).setWorkflowTaskScheduledEventAttributes(a).build();
        long scheduledEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.scheduledEventId = scheduledEventId;
        });
    }

    private static void scheduleQueryWorkflowTask(RequestContext ctx, WorkflowTaskData data, TestWorkflowMutableStateImpl.ConsistentQuery query, long notUsed) {
        ctx.lockTimer("scheduleQueryWorkflowTask");
        StartWorkflowExecutionRequest request = data.startRequest;
        PollWorkflowTaskQueueResponse.Builder workflowTaskResponse = PollWorkflowTaskQueueResponse.newBuilder();
        StickyExecutionAttributes stickyAttributes = ctx.getWorkflowMutableState().getStickyExecutionAttributes();
        String taskQueue = stickyAttributes == null ? request.getTaskQueue().getName() : stickyAttributes.getWorkerTaskQueue().getName();
        workflowTaskResponse.setWorkflowExecution(ctx.getExecution());
        workflowTaskResponse.setWorkflowType(request.getWorkflowType());
        workflowTaskResponse.setAttempt(data.attempt);
        TestWorkflowStore.TaskQueueId taskQueueId = new TestWorkflowStore.TaskQueueId(ctx.getNamespace(), taskQueue);
        TestWorkflowStore.WorkflowTask workflowTask = new TestWorkflowStore.WorkflowTask(taskQueueId, workflowTaskResponse);
        ctx.setWorkflowTask(workflowTask);
        ctx.onCommit(historySize -> {
            if (data.lastSuccessfulStartedEventId > 0L) {
                workflowTaskResponse.setPreviousStartedEventId(data.lastSuccessfulStartedEventId);
            }
            data.scheduledEventId = -1L;
            data.workflowTask = workflowTaskResponse;
            if (query != null) {
                data.consistentQueryRequests.put(query.getKey(), query);
            }
        });
    }

    private static void queryWhileScheduled(RequestContext ctx, WorkflowTaskData data, TestWorkflowMutableStateImpl.ConsistentQuery query, long notUsed) {
        data.consistentQueryRequests.put(query.getKey(), query);
    }

    private static void bufferQuery(RequestContext ctx, WorkflowTaskData data, TestWorkflowMutableStateImpl.ConsistentQuery query, long notUsed) {
        data.queryBuffer.put(query.getKey(), query);
    }

    private static void startWorkflowTask(RequestContext ctx, WorkflowTaskData data, PollWorkflowTaskQueueRequest request, long notUsed) {
        WorkflowTaskStartedEventAttributes a = WorkflowTaskStartedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).build();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_STARTED).setWorkflowTaskStartedEventAttributes(a).build();
        long startedEventId = ctx.addEvent(event);
        StateMachines.startWorkflowTaskImpl(ctx, data, request, startedEventId, false);
    }

    private static void startQueryOnlyWorkflowTask(RequestContext ctx, WorkflowTaskData data, PollWorkflowTaskQueueRequest request, long notUsed) {
        StateMachines.startWorkflowTaskImpl(ctx, data, request, -1L, true);
    }

    private static void startWorkflowTaskImpl(RequestContext ctx, WorkflowTaskData data, PollWorkflowTaskQueueRequest request, long startedEventId, boolean queryOnly) {
        ctx.onCommit(historySize -> {
            PollWorkflowTaskQueueResponse.Builder task = data.workflowTask;
            task.setStartedEventId(data.scheduledEventId + 1L);
            WorkflowTaskToken taskToken = new WorkflowTaskToken(ctx.getExecutionId(), historySize);
            task.setTaskToken(taskToken.toBytes());
            GetWorkflowExecutionHistoryRequest getRequest = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(request.getNamespace()).setExecution(ctx.getExecution()).build();
            List<HistoryEvent> events = data.store.getWorkflowExecutionHistory(ctx.getExecutionId(), getRequest, null).getHistory().getEventsList();
            long lastEventId = ((HistoryEvent)events.get(events.size() - 1)).getEventId();
            if (ctx.getWorkflowMutableState().getStickyExecutionAttributes() != null) {
                events = events.subList((int)data.lastSuccessfulStartedEventId, events.size());
            }
            if (queryOnly && !data.workflowCompleted) {
                events = new ArrayList(events);
                WorkflowTaskScheduledEventAttributes scheduledAttributes = WorkflowTaskScheduledEventAttributes.newBuilder().setStartToCloseTimeout(data.startRequest.getWorkflowTaskTimeout()).setTaskQueue(request.getTaskQueue()).setAttempt(data.attempt).build();
                HistoryEvent scheduledEvent = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_SCHEDULED).setEventId(lastEventId + 1L).setWorkflowTaskScheduledEventAttributes(scheduledAttributes).build();
                events.add(scheduledEvent);
                WorkflowTaskStartedEventAttributes startedAttributes = WorkflowTaskStartedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setScheduledEventId(lastEventId + 1L).build();
                HistoryEvent startedEvent = HistoryEvent.newBuilder().setEventId(lastEventId + 1L).setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_STARTED).setWorkflowTaskStartedEventAttributes(startedAttributes).build();
                events.add(startedEvent);
                task.setStartedEventId(lastEventId + 2L);
            }
            task.setHistory(History.newBuilder().addAllEvents((Iterable)events));
            Map<String, TestWorkflowMutableStateImpl.ConsistentQuery> queries = data.consistentQueryRequests;
            for (Map.Entry<String, TestWorkflowMutableStateImpl.ConsistentQuery> queryEntry : queries.entrySet()) {
                QueryWorkflowRequest queryWorkflowRequest = queryEntry.getValue().getRequest();
                task.putQueries(queryEntry.getKey(), queryWorkflowRequest.getQuery());
            }
            if (data.lastSuccessfulStartedEventId > 0L) {
                task.setPreviousStartedEventId(data.lastSuccessfulStartedEventId);
            }
            if (!queryOnly) {
                data.startedEventId = startedEventId;
                ++data.attempt;
            }
        });
    }

    private static void startActivityTask(RequestContext ctx, ActivityTaskData data, PollActivityTaskQueueRequest request, long notUsed) {
        ActivityTaskStartedEventAttributes.Builder a = ActivityTaskStartedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId);
        a.setAttempt(data.getAttempt());
        Timestamp timestamp = data.store.currentTime();
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_STARTED).setEventTime(timestamp).setActivityTaskStartedEventAttributes(a).build();
        long startedEventId = -1L;
        ctx.onCommit(historySize -> {
            data.startedEventId = startedEventId;
            data.startedEvent = event;
            PollActivityTaskQueueResponse.Builder task = data.activityTask.getTask();
            task.setTaskToken(new ActivityId(ctx.getExecutionId(), data.scheduledEventId).toBytes());
            task.setStartedTime(timestamp);
        });
    }

    private static void completeWorkflowTask(RequestContext ctx, WorkflowTaskData data, RespondWorkflowTaskCompletedRequest request, long notUsed) {
        WorkflowTaskCompletedEventAttributes.Builder a = WorkflowTaskCompletedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setBinaryChecksum(request.getBinaryChecksum()).setScheduledEventId(data.scheduledEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED).setWorkflowTaskCompletedEventAttributes(a).build();
        ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.lastSuccessfulStartedEventId = data.startedEventId;
            data.clear();
        });
    }

    private static void completeQuery(RequestContext ctx, WorkflowTaskData data, RespondWorkflowTaskCompletedRequest request, long notUsed) {
        Map responses = request.getQueryResultsMap();
        block4: for (Map.Entry resultEntry : responses.entrySet()) {
            TestWorkflowMutableStateImpl.ConsistentQuery query = data.consistentQueryRequests.remove(resultEntry.getKey());
            if (query == null) continue;
            WorkflowQueryResult value = (WorkflowQueryResult)resultEntry.getValue();
            CompletableFuture<QueryWorkflowResponse> result = query.getResult();
            switch (value.getResultType()) {
                case QUERY_RESULT_TYPE_ANSWERED: {
                    QueryWorkflowResponse response = QueryWorkflowResponse.newBuilder().setQueryResult(value.getAnswer()).build();
                    result.complete(response);
                    continue block4;
                }
                case QUERY_RESULT_TYPE_FAILED: {
                    result.completeExceptionally(StatusUtils.newException((Status)Status.INTERNAL.withDescription(value.getErrorMessage()), (GeneratedMessageV3)QueryFailedFailure.getDefaultInstance()));
                    continue block4;
                }
            }
            throw Status.INVALID_ARGUMENT.withDescription("Invalid query result type: " + value.getResultType()).asRuntimeException();
        }
        ctx.onCommit(historySize -> {
            data.clear();
            ctx.unlockTimer("completeQuery");
        });
    }

    private static void failQueryWorkflowTask(RequestContext ctx, WorkflowTaskData data, Object unused, long notUsed) {
        Iterator<Map.Entry<String, TestWorkflowMutableStateImpl.ConsistentQuery>> iterator = data.consistentQueryRequests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TestWorkflowMutableStateImpl.ConsistentQuery> entry = iterator.next();
            if (!entry.getValue().getResult().isCancelled()) continue;
            iterator.remove();
        }
        if (!data.consistentQueryRequests.isEmpty()) {
            ctx.setNeedWorkflowTask(true);
        }
        ctx.unlockTimer("failQueryWorkflowTask");
    }

    private static void failWorkflowTask(RequestContext ctx, WorkflowTaskData data, RespondWorkflowTaskFailedRequest request, long notUsed) {
        WorkflowTaskFailedEventAttributes.Builder a = WorkflowTaskFailedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId).setScheduledEventId(data.scheduledEventId);
        if (request.hasFailure()) {
            a.setFailure(request.getFailure());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_FAILED).setWorkflowTaskFailedEventAttributes(a).build();
        ctx.addEvent(event);
        ctx.setNeedWorkflowTask(true);
    }

    private static void timeoutWorkflowTask(RequestContext ctx, WorkflowTaskData data, Object ignored, long notUsed) {
        WorkflowTaskTimedOutEventAttributes.Builder a = WorkflowTaskTimedOutEventAttributes.newBuilder().setStartedEventId(data.startedEventId).setTimeoutType(TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE).setScheduledEventId(data.scheduledEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_TASK_TIMED_OUT).setWorkflowTaskTimedOutEventAttributes(a).build();
        ctx.addEvent(event);
        ctx.setNeedWorkflowTask(true);
    }

    private static void needsWorkflowTask(RequestContext requestContext, WorkflowTaskData workflowTaskData, Object notUsedRequest, long notUsed) {
        requestContext.setNeedWorkflowTask(true);
    }

    private static void completeActivityTask(RequestContext ctx, ActivityTaskData data, Object request, long notUsed) {
        data.startedEventId = ctx.addEvent(data.startedEvent);
        if (request instanceof RespondActivityTaskCompletedRequest) {
            StateMachines.completeActivityTaskByTaskToken(ctx, data, (RespondActivityTaskCompletedRequest)request);
        } else if (request instanceof RespondActivityTaskCompletedByIdRequest) {
            StateMachines.completeActivityTaskById(ctx, data, (RespondActivityTaskCompletedByIdRequest)request);
        } else {
            throw new IllegalArgumentException("Unknown request: " + request);
        }
    }

    private static void completeActivityTaskByTaskToken(RequestContext ctx, ActivityTaskData data, RespondActivityTaskCompletedRequest request) {
        ActivityTaskCompletedEventAttributes.Builder a = ActivityTaskCompletedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setResult(request.getResult()).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_COMPLETED).setActivityTaskCompletedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void completeActivityTaskById(RequestContext ctx, ActivityTaskData data, RespondActivityTaskCompletedByIdRequest request) {
        ActivityTaskCompletedEventAttributes.Builder a = ActivityTaskCompletedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setResult(request.getResult()).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_COMPLETED).setActivityTaskCompletedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static State failActivityTask(RequestContext ctx, ActivityTaskData data, Object request, long notUsed) {
        if (request instanceof RespondActivityTaskFailedRequest) {
            return StateMachines.failActivityTaskByTaskToken(ctx, data, (RespondActivityTaskFailedRequest)request);
        }
        if (request instanceof RespondActivityTaskFailedByIdRequest) {
            return StateMachines.failActivityTaskById(ctx, data, (RespondActivityTaskFailedByIdRequest)request);
        }
        throw new IllegalArgumentException("Unknown request: " + request);
    }

    private static State failActivityTaskByTaskToken(RequestContext ctx, ActivityTaskData data, RespondActivityTaskFailedRequest request) {
        if (!request.getFailure().hasApplicationFailureInfo()) {
            throw new IllegalArgumentException("application failure expected: " + request.getFailure());
        }
        Failure failure = request.getFailure();
        RetryState retryState = StateMachines.attemptActivityRetry(ctx, Optional.of(failure), data);
        if (retryState == RetryState.RETRY_STATE_IN_PROGRESS) {
            return State.INITIATED;
        }
        data.startedEventId = ctx.addEvent(data.startedEvent);
        ActivityTaskFailedEventAttributes.Builder a = ActivityTaskFailedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setFailure(request.getFailure()).setRetryState(retryState).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_FAILED).setActivityTaskFailedEventAttributes(a).build();
        ctx.addEvent(event);
        return State.FAILED;
    }

    private static State failActivityTaskById(RequestContext ctx, ActivityTaskData data, RespondActivityTaskFailedByIdRequest request) {
        if (!request.getFailure().hasApplicationFailureInfo()) {
            throw new IllegalArgumentException("application failure expected: " + request.getFailure());
        }
        Failure failure = request.getFailure();
        RetryState retryState = StateMachines.attemptActivityRetry(ctx, Optional.of(failure), data);
        if (retryState == RetryState.RETRY_STATE_IN_PROGRESS) {
            return State.INITIATED;
        }
        data.startedEventId = ctx.addEvent(data.startedEvent);
        ActivityTaskFailedEventAttributes.Builder a = ActivityTaskFailedEventAttributes.newBuilder().setIdentity(request.getIdentity()).setScheduledEventId(data.scheduledEventId).setFailure(request.getFailure()).setRetryState(retryState).setIdentity(request.getIdentity()).setStartedEventId(data.startedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_FAILED).setActivityTaskFailedEventAttributes(a).build();
        ctx.addEvent(event);
        return State.FAILED;
    }

    private static State timeoutActivityTask(RequestContext ctx, ActivityTaskData data, TimeoutType timeoutType, long notUsed) {
        RetryState retryState;
        if (timeoutType != TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_START) {
            retryState = StateMachines.attemptActivityRetry(ctx, Optional.empty(), data);
            if (retryState == RetryState.RETRY_STATE_IN_PROGRESS) {
                return State.INITIATED;
            }
        } else {
            retryState = RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE;
        }
        Failure failure = timeoutType == TimeoutType.TIMEOUT_TYPE_HEARTBEAT || timeoutType == TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE ? StateMachines.newTimeoutFailure(TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE, Optional.ofNullable(data.heartbeatDetails), Optional.of(StateMachines.newTimeoutFailure(timeoutType, Optional.empty(), Optional.empty()))) : StateMachines.newTimeoutFailure(timeoutType, Optional.ofNullable(data.heartbeatDetails), Optional.empty());
        ActivityTaskTimedOutEventAttributes.Builder a = ActivityTaskTimedOutEventAttributes.newBuilder().setScheduledEventId(data.scheduledEventId).setRetryState(retryState).setStartedEventId(data.startedEventId).setFailure(failure);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT).setActivityTaskTimedOutEventAttributes(a).build();
        ctx.addEvent(event);
        return State.TIMED_OUT;
    }

    private static Failure newTimeoutFailure(TimeoutType timeoutType, Optional<Payloads> lastHeartbeatDetails, Optional<Failure> cause) {
        TimeoutFailureInfo.Builder info = TimeoutFailureInfo.newBuilder().setTimeoutType(timeoutType);
        if (lastHeartbeatDetails.isPresent()) {
            info.setLastHeartbeatDetails(lastHeartbeatDetails.get());
        }
        Failure.Builder result = Failure.newBuilder().setTimeoutFailureInfo(info);
        if (cause.isPresent()) {
            result.setCause(cause.get());
        }
        return result.build();
    }

    private static RetryState attemptActivityRetry(RequestContext ctx, Optional<Failure> failure, ActivityTaskData data) {
        if (data.retryState == null) {
            throw new IllegalStateException("RetryPolicy is always present");
        }
        Optional<ApplicationFailureInfo> info = failure.map(f -> f.getApplicationFailureInfo());
        if (info.isPresent() && info.get().getNonRetryable()) {
            return RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE;
        }
        TestServiceRetryState nextAttempt = data.retryState.getNextAttempt(failure);
        TestServiceRetryState.BackoffInterval backoffInterval = data.retryState.getBackoffIntervalInSeconds(info.map(i -> i.getType()), data.store.currentTime());
        if (backoffInterval.getRetryState() == RetryState.RETRY_STATE_IN_PROGRESS) {
            data.nextBackoffInterval = ProtobufTimeUtils.toProtoDuration((java.time.Duration)backoffInterval.getInterval());
            PollActivityTaskQueueResponse.Builder task = data.activityTask.getTask();
            if (data.heartbeatDetails != null) {
                task.setHeartbeatDetails(data.heartbeatDetails);
            }
            ctx.onCommit(historySize -> {
                data.retryState = nextAttempt;
                task.setAttempt(nextAttempt.getAttempt());
                task.setCurrentAttemptScheduledTime(ctx.currentTime());
            });
        } else {
            data.nextBackoffInterval = Durations.ZERO;
        }
        return backoffInterval.getRetryState();
    }

    private static void reportActivityTaskCancellation(RequestContext ctx, ActivityTaskData data, Object request, long notUsed) {
        Optional details;
        RespondActivityTaskCanceledRequest cr;
        if (request instanceof RespondActivityTaskCanceledRequest) {
            cr = (RespondActivityTaskCanceledRequest)request;
            details = cr.hasDetails() ? Optional.of(cr.getDetails()) : Optional.empty();
        } else if (request instanceof RespondActivityTaskCanceledByIdRequest) {
            cr = (RespondActivityTaskCanceledByIdRequest)request;
            details = cr.hasDetails() ? Optional.of(cr.getDetails()) : Optional.empty();
        } else {
            throw Status.INTERNAL.withDescription("Unexpected request type: " + request).asRuntimeException();
        }
        ActivityTaskCanceledEventAttributes.Builder a = ActivityTaskCanceledEventAttributes.newBuilder().setScheduledEventId(data.scheduledEventId).setStartedEventId(data.startedEventId);
        if (details.isPresent()) {
            a.setDetails((Payloads)details.get());
        }
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_ACTIVITY_TASK_CANCELED).setActivityTaskCanceledEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void heartbeatActivityTask(RequestContext nullCtx, ActivityTaskData data, Payloads details, long notUsed) {
        data.heartbeatDetails = details;
    }

    private static void startTimer(RequestContext ctx, TimerData data, StartTimerCommandAttributes d, long workflowTaskCompletedEventId) {
        TimerStartedEventAttributes.Builder a = TimerStartedEventAttributes.newBuilder().setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId).setStartToFireTimeout(d.getStartToFireTimeout()).setTimerId(d.getTimerId());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_TIMER_STARTED).setTimerStartedEventAttributes(a).build();
        long startedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.startedEvent = a.build();
            data.startedEventId = startedEventId;
        });
    }

    private static void fireTimer(RequestContext ctx, TimerData data, Object ignored, long notUsed) {
        TimerFiredEventAttributes.Builder a = TimerFiredEventAttributes.newBuilder().setTimerId(data.startedEvent.getTimerId()).setStartedEventId(data.startedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_TIMER_FIRED).setTimerFiredEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void cancelTimer(RequestContext ctx, TimerData data, CancelTimerCommandAttributes d, long workflowTaskCompletedEventId) {
        TimerCanceledEventAttributes.Builder a = TimerCanceledEventAttributes.newBuilder().setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId).setTimerId(d.getTimerId()).setStartedEventId(data.startedEventId);
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_TIMER_CANCELED).setTimerCanceledEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void initiateExternalSignal(RequestContext ctx, SignalExternalData data, SignalExternalWorkflowExecutionCommandAttributes d, long workflowTaskCompletedEventId) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder a = SignalExternalWorkflowExecutionInitiatedEventAttributes.newBuilder().setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId).setControl(d.getControl()).setInput(d.getInput()).setNamespace(d.getNamespace()).setChildWorkflowOnly(d.getChildWorkflowOnly()).setSignalName(d.getSignalName()).setWorkflowExecution(d.getExecution());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED).setSignalExternalWorkflowExecutionInitiatedEventAttributes(a).build();
        long initiatedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.initiatedEventId = initiatedEventId;
            data.initiatedEvent = a.build();
        });
    }

    private static void failExternalSignal(RequestContext ctx, SignalExternalData data, SignalExternalWorkflowExecutionFailedCause cause, long notUsed) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent = data.initiatedEvent;
        SignalExternalWorkflowExecutionFailedEventAttributes.Builder a = SignalExternalWorkflowExecutionFailedEventAttributes.newBuilder().setInitiatedEventId(data.initiatedEventId).setWorkflowExecution(initiatedEvent.getWorkflowExecution()).setControl(initiatedEvent.getControl()).setCause(cause).setNamespace(initiatedEvent.getNamespace());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED).setSignalExternalWorkflowExecutionFailedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void completeExternalSignal(RequestContext ctx, SignalExternalData data, String runId, long notUsed) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent = data.initiatedEvent;
        WorkflowExecution signaledExecution = initiatedEvent.getWorkflowExecution().toBuilder().setRunId(runId).build();
        ExternalWorkflowExecutionSignaledEventAttributes.Builder a = ExternalWorkflowExecutionSignaledEventAttributes.newBuilder().setInitiatedEventId(data.initiatedEventId).setWorkflowExecution(signaledExecution).setControl(initiatedEvent.getControl()).setNamespace(initiatedEvent.getNamespace());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_SIGNALED).setExternalWorkflowExecutionSignaledEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void initiateExternalCancellation(RequestContext ctx, CancelExternalData data, RequestCancelExternalWorkflowExecutionCommandAttributes d, long workflowTaskCompletedEventId) {
        RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder a = RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.newBuilder().setWorkflowTaskCompletedEventId(workflowTaskCompletedEventId).setControl(d.getControl()).setNamespace(d.getNamespace()).setChildWorkflowOnly(d.getChildWorkflowOnly()).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId(d.getWorkflowId()).setRunId(d.getRunId()).build());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED).setRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(a).build();
        long initiatedEventId = ctx.addEvent(event);
        ctx.onCommit(historySize -> {
            data.initiatedEventId = initiatedEventId;
            data.initiatedEvent = a.build();
        });
    }

    private static void reportExternalCancellationRequested(RequestContext ctx, CancelExternalData data, String runId, long notUsed) {
        RequestCancelExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent = data.initiatedEvent;
        ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder a = ExternalWorkflowExecutionCancelRequestedEventAttributes.newBuilder().setInitiatedEventId(data.initiatedEventId).setWorkflowExecution(WorkflowExecution.newBuilder().setRunId(runId).setWorkflowId(initiatedEvent.getWorkflowExecution().getWorkflowId()).build()).setNamespace(initiatedEvent.getNamespace());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED).setExternalWorkflowExecutionCancelRequestedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    private static void failExternalCancellation(RequestContext ctx, CancelExternalData data, CancelExternalWorkflowExecutionFailedCause cause, long notUsed) {
        RequestCancelExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent = data.initiatedEvent;
        RequestCancelExternalWorkflowExecutionFailedEventAttributes.Builder a = RequestCancelExternalWorkflowExecutionFailedEventAttributes.newBuilder().setInitiatedEventId(data.initiatedEventId).setWorkflowExecution(initiatedEvent.getWorkflowExecution()).setControl(initiatedEvent.getControl()).setCause(cause).setNamespace(initiatedEvent.getNamespace());
        HistoryEvent event = HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED).setRequestCancelExternalWorkflowExecutionFailedEventAttributes(a).build();
        ctx.addEvent(event);
    }

    static RetryPolicy ensureDefaultFieldsForActivityRetryPolicy(RetryPolicy originalPolicy) {
        Duration initialInterval = Durations.compare((Duration)originalPolicy.getInitialInterval(), (Duration)Durations.ZERO) == 0 ? DEFAULT_ACTIVITY_RETRY_INITIAL_INTERVAL : originalPolicy.getInitialInterval();
        return RetryPolicy.newBuilder().setInitialInterval(initialInterval).addAllNonRetryableErrorTypes((Iterable)originalPolicy.getNonRetryableErrorTypesList()).setMaximumInterval(Durations.compare((Duration)originalPolicy.getMaximumInterval(), (Duration)Durations.ZERO) == 0 ? Durations.fromMillis((long)(100L * Durations.toMillis((Duration)initialInterval))) : originalPolicy.getMaximumInterval()).setBackoffCoefficient(originalPolicy.getBackoffCoefficient() == 0.0 ? 2.0 : originalPolicy.getBackoffCoefficient()).setMaximumAttempts(originalPolicy.getMaximumAttempts() == 0 ? 0 : originalPolicy.getMaximumAttempts()).build();
    }

    static final class TimerData {
        TimerStartedEventAttributes startedEvent;
        public long startedEventId;

        TimerData() {
        }

        public String toString() {
            return "TimerData{startedEvent=" + this.startedEvent + ", startedEventId=" + this.startedEventId + '}';
        }
    }

    static final class ChildWorkflowData {
        final TestWorkflowService service;
        StartChildWorkflowExecutionInitiatedEventAttributes initiatedEvent;
        long initiatedEventId;
        long startedEventId;
        WorkflowExecution execution;

        public ChildWorkflowData(TestWorkflowService service) {
            this.service = service;
        }

        public String toString() {
            return "ChildWorkflowData{service=" + this.service + ", initiatedEvent=" + this.initiatedEvent + ", initiatedEventId=" + this.initiatedEventId + ", startedEventId=" + this.startedEventId + ", execution=" + this.execution + '}';
        }
    }

    static final class CancelExternalData {
        long initiatedEventId = -1L;
        public RequestCancelExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent;

        CancelExternalData() {
        }

        public String toString() {
            return "CancelExternalData{initiatedEventId=" + this.initiatedEventId + ", initiatedEvent=" + this.initiatedEvent + '}';
        }
    }

    static final class SignalExternalData {
        long initiatedEventId = -1L;
        public SignalExternalWorkflowExecutionInitiatedEventAttributes initiatedEvent;

        SignalExternalData() {
        }

        public String toString() {
            return "SignalExternalData{initiatedEventId=" + this.initiatedEventId + ", initiatedEvent=" + this.initiatedEvent + '}';
        }
    }

    static final class ActivityTaskData {
        StartWorkflowExecutionRequest startWorkflowExecutionRequest;
        ActivityTaskScheduledEventAttributes scheduledEvent;
        TestWorkflowStore.ActivityTask activityTask;
        final TestWorkflowStore store;
        long scheduledEventId = -1L;
        long startedEventId = -1L;
        public HistoryEvent startedEvent;
        Payloads heartbeatDetails;
        long lastHeartbeatTime;
        TestServiceRetryState retryState;
        Duration nextBackoffInterval;

        ActivityTaskData(TestWorkflowStore store, StartWorkflowExecutionRequest startWorkflowExecutionRequest) {
            this.store = store;
            this.startWorkflowExecutionRequest = startWorkflowExecutionRequest;
        }

        public String toString() {
            return "ActivityTaskData{startWorkflowExecutionRequest=" + this.startWorkflowExecutionRequest + ", scheduledEvent=" + this.scheduledEvent + ", activityTask=" + this.activityTask + ", store=" + this.store + ", scheduledEventId=" + this.scheduledEventId + ", startedEventId=" + this.startedEventId + ", startedEvent=" + this.startedEvent + ", heartbeatDetails=" + this.heartbeatDetails + ", lastHeartbeatTime=" + this.lastHeartbeatTime + ", retryState=" + this.retryState + ", nextBackoffInterval=" + this.nextBackoffInterval + '}';
        }

        public int getAttempt() {
            return this.retryState != null ? this.retryState.getAttempt() : 1;
        }
    }

    static final class WorkflowTaskData {
        final TestWorkflowStore store;
        boolean workflowCompleted;
        long lastSuccessfulStartedEventId;
        final StartWorkflowExecutionRequest startRequest;
        long startedEventId = -1L;
        PollWorkflowTaskQueueResponse.Builder workflowTask;
        final List<RequestContext> bufferedEvents = new ArrayList<RequestContext>();
        long scheduledEventId = -1L;
        int attempt = 1;
        final Map<String, TestWorkflowMutableStateImpl.ConsistentQuery> queryBuffer = new HashMap<String, TestWorkflowMutableStateImpl.ConsistentQuery>();
        final Map<String, TestWorkflowMutableStateImpl.ConsistentQuery> consistentQueryRequests = new HashMap<String, TestWorkflowMutableStateImpl.ConsistentQuery>();

        WorkflowTaskData(TestWorkflowStore store, StartWorkflowExecutionRequest startRequest) {
            this.store = store;
            this.startRequest = startRequest;
        }

        void clear() {
            this.startedEventId = -1L;
            this.workflowTask = null;
            this.scheduledEventId = -1L;
            this.attempt = 1;
        }

        public String toString() {
            return "WorkflowTaskData{store=" + this.store + ", workflowCompleted=" + this.workflowCompleted + ", lastSuccessfulStartedEventId=" + this.lastSuccessfulStartedEventId + ", startRequest=" + this.startRequest + ", startedEventId=" + this.startedEventId + ", workflowTask=" + this.workflowTask + ", bufferedEvents=" + this.bufferedEvents + ", scheduledEventId=" + this.scheduledEventId + ", attempt=" + this.attempt + ", queryBuffer=" + this.queryBuffer + ", consistentQueryRequests=" + this.consistentQueryRequests + '}';
        }
    }

    static final class WorkflowData {
        Optional<TestServiceRetryState> retryState;
        Duration backoffStartInterval;
        String cronSchedule;
        Payloads lastCompletionResult;
        Optional<Failure> lastFailure;
        String originalExecutionRunId;
        Optional<String> continuedExecutionRunId;
        Functions.Proc runTimerCancellationHandle;

        WorkflowData(Optional<TestServiceRetryState> retryState, Duration backoffStartInterval, String cronSchedule, Payloads lastCompletionResult, Optional<Failure> lastFailure, String originalExecutionRunId, Optional<String> continuedExecutionRunId) {
            this.retryState = retryState;
            this.backoffStartInterval = backoffStartInterval;
            this.cronSchedule = cronSchedule;
            this.lastCompletionResult = lastCompletionResult;
            this.originalExecutionRunId = originalExecutionRunId;
            this.continuedExecutionRunId = continuedExecutionRunId;
            this.lastFailure = Objects.requireNonNull(lastFailure);
        }

        public String toString() {
            return "WorkflowData{retryState=" + this.retryState + ", backoffStartInterval=" + this.backoffStartInterval + ", cronSchedule='" + this.cronSchedule + '\'' + ", lastCompletionResult=" + this.lastCompletionResult + ", originalExecutionRunId='" + this.originalExecutionRunId + '\'' + ", continuedExecutionRunId=" + this.continuedExecutionRunId + '}';
        }
    }

    static enum Action {
        INITIATE,
        START,
        FAIL,
        TIME_OUT,
        REQUEST_CANCELLATION,
        CANCEL,
        TERMINATE,
        UPDATE,
        COMPLETE,
        CONTINUE_AS_NEW,
        QUERY;

    }

    static enum State {
        NONE,
        INITIATED,
        INITIATED_QUERY_ONLY,
        STARTED,
        STARTED_QUERY_ONLY,
        FAILED,
        TIMED_OUT,
        CANCELLATION_REQUESTED,
        CANCELED,
        COMPLETED,
        CONTINUED_AS_NEW,
        TERMINATED;

    }
}

