/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import io.grpc.stub.StreamObserver;
import io.temporal.api.testservice.v1.GetCurrentTimeResponse;
import io.temporal.api.testservice.v1.LockTimeSkippingRequest;
import io.temporal.api.testservice.v1.LockTimeSkippingResponse;
import io.temporal.api.testservice.v1.SleepRequest;
import io.temporal.api.testservice.v1.SleepResponse;
import io.temporal.api.testservice.v1.SleepUntilRequest;
import io.temporal.api.testservice.v1.TestServiceGrpc;
import io.temporal.api.testservice.v1.UnlockTimeSkippingRequest;
import io.temporal.api.testservice.v1.UnlockTimeSkippingResponse;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.testservice.SelfAdvancingTimer;
import io.temporal.internal.testservice.TestWorkflowStore;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

final class TestService
extends TestServiceGrpc.TestServiceImplBase
implements Closeable {
    private final SelfAdvancingTimer selfAdvancingTimer;
    private final TestWorkflowStore workflowStore;

    public TestService(TestWorkflowStore workflowStore, SelfAdvancingTimer selfAdvancingTimer, boolean lockTimeSkipping) {
        this.workflowStore = workflowStore;
        this.selfAdvancingTimer = selfAdvancingTimer;
        if (lockTimeSkipping) {
            selfAdvancingTimer.lockTimeSkipping("TestService constructor");
        }
    }

    @Override
    public void lockTimeSkipping(LockTimeSkippingRequest request, StreamObserver<LockTimeSkippingResponse> responseObserver) {
        this.selfAdvancingTimer.lockTimeSkipping("External Caller");
        responseObserver.onNext((Object)LockTimeSkippingResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void unlockTimeSkipping(UnlockTimeSkippingRequest request, StreamObserver<UnlockTimeSkippingResponse> responseObserver) {
        this.selfAdvancingTimer.unlockTimeSkipping("External Caller");
        responseObserver.onNext((Object)UnlockTimeSkippingResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void sleep(SleepRequest request, StreamObserver<SleepResponse> responseObserver) {
        CompletableFuture result = new CompletableFuture();
        this.selfAdvancingTimer.schedule(ProtobufTimeUtils.toJavaDuration((Duration)request.getDuration()), () -> result.complete(null), "TestService sleep");
        try {
            result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        responseObserver.onNext((Object)SleepResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void sleepUntil(SleepUntilRequest request, StreamObserver<SleepResponse> responseObserver) {
        CompletableFuture result = new CompletableFuture();
        this.selfAdvancingTimer.scheduleAt(ProtobufTimeUtils.toJavaInstant((Timestamp)request.getTimestamp()), () -> result.complete(null), "TestService sleepUntil");
        try {
            result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        responseObserver.onNext((Object)SleepResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void unlockTimeSkippingWithSleep(SleepRequest request, StreamObserver<SleepResponse> responseObserver) {
        this.unlockTimeSkippingWhileSleep(ProtobufTimeUtils.toJavaDuration((Duration)request.getDuration()));
        responseObserver.onNext((Object)SleepResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void getCurrentTime(Empty request, StreamObserver<GetCurrentTimeResponse> responseObserver) {
        Timestamp timestamp = this.workflowStore.currentTime();
        responseObserver.onNext((Object)GetCurrentTimeResponse.newBuilder().setTime(timestamp).build());
        responseObserver.onCompleted();
    }

    private void unlockTimeSkippingWhileSleep(java.time.Duration duration) {
        CompletableFuture result = new CompletableFuture();
        this.selfAdvancingTimer.schedule(duration, () -> {
            this.selfAdvancingTimer.lockTimeSkipping("TestService unlockTimeSkippingWhileSleep");
            result.complete(null);
        }, "TestService unlockTimeSkippingWhileSleep");
        this.selfAdvancingTimer.unlockTimeSkipping("TestService unlockTimeSkippingWhileSleep");
        try {
            result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

