/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.api.nexus.v1.Endpoint;
import io.temporal.api.operatorservice.v1.AddSearchAttributesRequest;
import io.temporal.api.operatorservice.v1.AddSearchAttributesResponse;
import io.temporal.api.operatorservice.v1.CreateNexusEndpointRequest;
import io.temporal.api.operatorservice.v1.CreateNexusEndpointResponse;
import io.temporal.api.operatorservice.v1.DeleteNexusEndpointRequest;
import io.temporal.api.operatorservice.v1.DeleteNexusEndpointResponse;
import io.temporal.api.operatorservice.v1.GetNexusEndpointRequest;
import io.temporal.api.operatorservice.v1.GetNexusEndpointResponse;
import io.temporal.api.operatorservice.v1.ListNexusEndpointsRequest;
import io.temporal.api.operatorservice.v1.ListNexusEndpointsResponse;
import io.temporal.api.operatorservice.v1.OperatorServiceGrpc;
import io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest;
import io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse;
import io.temporal.api.operatorservice.v1.UpdateNexusEndpointRequest;
import io.temporal.api.operatorservice.v1.UpdateNexusEndpointResponse;
import io.temporal.internal.testservice.TestNexusEndpointStore;
import io.temporal.internal.testservice.TestVisibilityStore;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestOperatorService
extends OperatorServiceGrpc.OperatorServiceImplBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TestOperatorService.class);
    private final TestVisibilityStore visibilityStore;
    private final TestNexusEndpointStore nexusEndpointStore;

    public TestOperatorService(TestVisibilityStore visibilityStore, TestNexusEndpointStore nexusEndpointStore) {
        this.visibilityStore = visibilityStore;
        this.nexusEndpointStore = nexusEndpointStore;
    }

    public void addSearchAttributes(AddSearchAttributesRequest request, StreamObserver<AddSearchAttributesResponse> responseObserver) {
        try {
            Map<String, IndexedValueType> registeredSearchAttributes = this.visibilityStore.getRegisteredSearchAttributes();
            request.getSearchAttributesMap().keySet().stream().filter(registeredSearchAttributes::containsKey).findFirst().ifPresent(sa -> {
                throw Status.ALREADY_EXISTS.withDescription("Search attribute " + sa + " already exists.").asRuntimeException();
            });
            request.getSearchAttributesMap().forEach(this.visibilityStore::addSearchAttribute);
            responseObserver.onNext((Object)AddSearchAttributesResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void removeSearchAttributes(RemoveSearchAttributesRequest request, StreamObserver<RemoveSearchAttributesResponse> responseObserver) {
        try {
            Map<String, IndexedValueType> registeredSearchAttributes = this.visibilityStore.getRegisteredSearchAttributes();
            request.getSearchAttributesList().stream().filter(k -> !registeredSearchAttributes.containsKey(k)).findFirst().ifPresent(sa -> {
                throw Status.NOT_FOUND.withDescription("Search attribute " + sa + " doesn't exist.").asRuntimeException();
            });
            request.getSearchAttributesList().forEach(this.visibilityStore::removeSearchAttribute);
            responseObserver.onNext((Object)RemoveSearchAttributesResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void getNexusEndpoint(GetNexusEndpointRequest request, StreamObserver<GetNexusEndpointResponse> responseObserver) {
        try {
            Endpoint endpoint = this.nexusEndpointStore.getEndpoint(request.getId());
            responseObserver.onNext((Object)GetNexusEndpointResponse.newBuilder().setEndpoint(endpoint).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void createNexusEndpoint(CreateNexusEndpointRequest request, StreamObserver<CreateNexusEndpointResponse> responseObserver) {
        try {
            Endpoint created = this.nexusEndpointStore.createEndpoint(request.getSpec());
            responseObserver.onNext((Object)CreateNexusEndpointResponse.newBuilder().setEndpoint(created).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void updateNexusEndpoint(UpdateNexusEndpointRequest request, StreamObserver<UpdateNexusEndpointResponse> responseObserver) {
        try {
            Endpoint updated = this.nexusEndpointStore.updateEndpoint(request.getId(), request.getVersion(), request.getSpec());
            responseObserver.onNext((Object)UpdateNexusEndpointResponse.newBuilder().setEndpoint(updated).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void deleteNexusEndpoint(DeleteNexusEndpointRequest request, StreamObserver<DeleteNexusEndpointResponse> responseObserver) {
        try {
            this.nexusEndpointStore.deleteEndpoint(request.getId(), request.getVersion());
            responseObserver.onNext((Object)DeleteNexusEndpointResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void listNexusEndpoints(ListNexusEndpointsRequest request, StreamObserver<ListNexusEndpointsResponse> responseObserver) {
        try {
            List<Endpoint> endpoints = this.nexusEndpointStore.listEndpoints(request.getPageSize(), request.getNextPageToken().toByteArray(), request.getName());
            ByteString nextPageToken = !endpoints.isEmpty() && endpoints.size() == request.getPageSize() ? endpoints.get(endpoints.size() - 1).getIdBytes() : ByteString.empty();
            responseObserver.onNext((Object)ListNexusEndpointsResponse.newBuilder().addAllEndpoints(endpoints).setNextPageToken(nextPageToken).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private void handleStatusRuntimeException(StatusRuntimeException e, StreamObserver<?> responseObserver) {
        if (e.getStatus().getCode() == Status.Code.INTERNAL) {
            log.error("unexpected", (Throwable)e);
        }
        responseObserver.onError((Throwable)e);
    }

    @Override
    public void close() {
    }
}

