/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.Priority;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

class TaskQueue<E> {
    private final PriorityQueue<TaskQueueElement<E>> backlog = new PriorityQueue<TaskQueueElement>(Comparator.comparingInt(o -> o.getPriority().getPriorityKey()));
    private final LinkedList<PollFuture> waiters = new LinkedList();

    TaskQueue() {
    }

    synchronized void add(E element) {
        PollFuture future = this.waiters.poll();
        while (future != null) {
            if (future.set(element)) {
                return;
            }
            future = this.waiters.pop();
        }
        this.backlog.add(new TaskQueueElement<E>(element));
    }

    synchronized void add(E element, Priority priority) {
        PollFuture future = this.waiters.poll();
        while (future != null) {
            if (future.set(element)) {
                return;
            }
            future = this.waiters.pop();
        }
        this.backlog.add(new TaskQueueElement<E>(element, priority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Future<E> poll() {
        E element;
        PollFuture future = new PollFuture();
        TaskQueue taskQueue = this;
        synchronized (taskQueue) {
            if (this.backlog.isEmpty()) {
                this.waiters.push(future);
                return future;
            }
            element = this.backlog.poll().getValue();
        }
        future.set(element);
        return future;
    }

    private class PollFuture
    implements Future<E> {
        boolean cancelled = false;
        E value;

        private PollFuture() {
        }

        private synchronized boolean set(E element) {
            Preconditions.checkState((this.value == null ? 1 : 0) != 0);
            if (this.cancelled) {
                return false;
            }
            this.value = element;
            this.notifyAll();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean ignored) {
            Object object = TaskQueue.this;
            synchronized (object) {
                TaskQueue.this.waiters.remove(this);
            }
            object = this;
            synchronized (object) {
                if (this.value != null) {
                    return false;
                }
                this.cancelled = true;
                this.notifyAll();
                return true;
            }
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public synchronized boolean isDone() {
            return this.value != null;
        }

        @Override
        public synchronized E get() throws InterruptedException, ExecutionException {
            while (this.value == null && !this.cancelled) {
                this.wait();
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            return this.value;
        }

        @Override
        public synchronized E get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            while (this.value == null && !this.cancelled) {
                unit.timedWait(this, timeout);
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            return this.value;
        }
    }

    private static class TaskQueueElement<E> {
        private final E value;
        private final Priority priority;

        TaskQueueElement(E value, Priority priority) {
            this.value = value;
            this.priority = priority == Priority.getDefaultInstance() ? Priority.newBuilder().setPriorityKey(3).build() : priority;
        }

        TaskQueueElement(E value) {
            this.value = value;
            this.priority = Priority.newBuilder().setPriorityKey(3).build();
        }

        public E getValue() {
            return this.value;
        }

        public Priority getPriority() {
            return this.priority;
        }
    }
}

