/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.internal.testservice.ExecutionId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class NexusOperationRef {
    @Nonnull
    private final ExecutionId executionId;
    private final long scheduledEventId;

    NexusOperationRef(@Nonnull String namespace, @Nonnull WorkflowExecution execution, long scheduledEventId) {
        this(new ExecutionId(Objects.requireNonNull(namespace), Objects.requireNonNull(execution)), scheduledEventId);
    }

    NexusOperationRef(@Nonnull String namespace, @Nonnull String workflowId, @Nonnull String runId, long scheduledEventId) {
        this(namespace, WorkflowExecution.newBuilder().setWorkflowId(Objects.requireNonNull(workflowId)).setRunId(Objects.requireNonNull(runId)).build(), scheduledEventId);
    }

    public NexusOperationRef(@Nonnull ExecutionId executionId, long scheduledEventId) {
        this.executionId = Objects.requireNonNull(executionId);
        this.scheduledEventId = scheduledEventId;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public long getScheduledEventId() {
        return this.scheduledEventId;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteString toBytes() {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ByteString byteString;
            try (DataOutputStream out = new DataOutputStream(bout);){
                out.writeUTF(this.executionId.getNamespace());
                WorkflowExecution execution = this.executionId.getExecution();
                out.writeUTF(execution.getWorkflowId());
                out.writeUTF(execution.getRunId());
                out.writeLong(this.scheduledEventId);
                byteString = ByteString.copyFrom((byte[])bout.toByteArray());
            }
            return byteString;
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }

    public static NexusOperationRef fromBytes(ByteString serialized) {
        return NexusOperationRef.fromBytes(serialized.toByteArray());
    }

    public static NexusOperationRef fromBytes(byte[] serialized) {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        DataInputStream in = new DataInputStream(bin);
        try {
            String namespace = in.readUTF();
            String workflowId = in.readUTF();
            String runId = in.readUTF();
            long scheduledEventId = in.readLong();
            return new NexusOperationRef(namespace, workflowId, runId, scheduledEventId);
        }
        catch (IOException e) {
            throw Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }
}

