/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testserver;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.temporal.internal.testservice.GRPCServerHelper;
import io.temporal.internal.testservice.InProcessGRPCServer;
import io.temporal.internal.testservice.TestServicesStarter;
import io.temporal.internal.testservice.TestWorkflowService;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer {
    private static final Logger log = LoggerFactory.getLogger(TestServer.class);

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: <command> <port> <flags>");
            System.err.println("Flags:");
            System.err.println("--enable-time-skipping - to enable time skipping on start");
            return;
        }
        int port = Integer.parseInt(args[0]);
        boolean enableTimeSkipping = false;
        if (args.length > 1) {
            if ("--enable-time-skipping".equalsIgnoreCase(args[1])) {
                enableTimeSkipping = true;
            } else {
                System.err.println("Unknown flag " + args[1]);
                return;
            }
        }
        PortBoundTestServer server = TestServer.createPortBoundServer(port, !enableTimeSkipping);
        Runtime.getRuntime().addShutdownHook(new Thread(server::close));
    }

    public static PortBoundTestServer createPortBoundServer(int port) {
        return TestServer.createPortBoundServer(port, true);
    }

    public static PortBoundTestServer createPortBoundServer(int port, boolean lockTimeSkipping) {
        TestServicesStarter testServicesStarter = new TestServicesStarter(lockTimeSkipping, 0L);
        try {
            ServerBuilder serverBuilder = Grpc.newServerBuilderForPort((int)port, (ServerCredentials)InsecureServerCredentials.create());
            GRPCServerHelper.registerServicesAndHealthChecks(testServicesStarter.getServices(), (ServerBuilder)serverBuilder);
            Server outOfProcessServer = serverBuilder.build().start();
            return new PortBoundTestServer(testServicesStarter, outOfProcessServer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InProcessTestServer createServer() {
        return TestServer.createServer(true, 0L);
    }

    public static InProcessTestServer createServer(boolean lockTimeSkipping) {
        return TestServer.createServer(lockTimeSkipping, 0L);
    }

    public static InProcessTestServer createServer(boolean lockTimeSkipping, long initialTimeMillis) {
        TestServicesStarter testServicesStarter = new TestServicesStarter(lockTimeSkipping, initialTimeMillis);
        InProcessGRPCServer inProcessServer = new InProcessGRPCServer(testServicesStarter.getServices());
        return new InProcessTestServer(testServicesStarter, inProcessServer);
    }

    public static final class PortBoundTestServer
    implements Closeable {
        private final TestServicesStarter testServicesStarter;
        private final Server outOfProcessServer;

        private PortBoundTestServer(TestServicesStarter testServicesStarter, Server outOfProcessServer) {
            this.testServicesStarter = testServicesStarter;
            this.outOfProcessServer = outOfProcessServer;
        }

        @Override
        public void close() {
            try {
                if (this.outOfProcessServer != null) {
                    log.info("Shutting down port-bind gRPC server");
                    this.outOfProcessServer.shutdown();
                    if (!this.outOfProcessServer.awaitTermination(5L, TimeUnit.SECONDS)) {
                        log.warn("Fail to shutdown the server in time (5s)");
                    }
                }
                log.info("Shutting down gRPC Services");
                this.testServicesStarter.close();
                if (this.outOfProcessServer != null) {
                    this.outOfProcessServer.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("shutdown interrupted", (Throwable)e);
            }
        }
    }

    public static final class InProcessTestServer
    implements Closeable {
        private final TestServicesStarter testServicesStarter;
        private final InProcessGRPCServer inProcessServer;

        private InProcessTestServer(TestServicesStarter testServicesStarter, InProcessGRPCServer inProcessServer) {
            this.testServicesStarter = testServicesStarter;
            this.inProcessServer = inProcessServer;
        }

        @Deprecated
        public TestWorkflowService getWorkflowService() {
            return this.testServicesStarter.getWorkflowService();
        }

        @VisibleForTesting
        TestServicesStarter getStarter() {
            return this.testServicesStarter;
        }

        public ManagedChannel getChannel() {
            return this.inProcessServer.getChannel();
        }

        @Override
        public void close() {
            if (this.inProcessServer != null) {
                log.info("Shutting down in-process gRPC server");
                this.inProcessServer.shutdown();
                this.inProcessServer.awaitTermination(5L, TimeUnit.SECONDS);
            }
            log.info("Shutting down gRPC Services");
            this.testServicesStarter.close();
        }
    }
}

