/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.ManagedChannel;
import io.grpc.health.v1.HealthCheckResponse;
import io.temporal.api.testservice.v1.TestServiceGrpc;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.serviceclient.ChannelManager;
import io.temporal.serviceclient.GrpcDeadlineInterceptor;
import io.temporal.serviceclient.ServiceStubsOptions;
import io.temporal.serviceclient.TestServiceStubs;
import io.temporal.serviceclient.TestServiceStubsOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceStubsImpl
implements TestServiceStubs {
    private static final Logger log = LoggerFactory.getLogger(TestServiceStubsImpl.class);
    private final ChannelManager channelManager;
    private final TestServiceGrpc.TestServiceBlockingStub blockingStub;
    private final TestServiceGrpc.TestServiceFutureStub futureStub;

    TestServiceStubsImpl(TestServiceStubsOptions options) {
        GrpcDeadlineInterceptor deadlineInterceptor = new GrpcDeadlineInterceptor(options.getRpcTimeout(), null, null);
        this.channelManager = new ChannelManager((ServiceStubsOptions)options, Collections.singletonList(deadlineInterceptor));
        log.info("Created TestServiceStubs for channel: {}", (Object)this.channelManager.getRawChannel());
        this.blockingStub = TestServiceGrpc.newBlockingStub(this.channelManager.getInterceptedChannel());
        this.futureStub = TestServiceGrpc.newFutureStub(this.channelManager.getInterceptedChannel());
    }

    public ManagedChannel getRawChannel() {
        return this.channelManager.getRawChannel();
    }

    public TestServiceGrpc.TestServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    public TestServiceGrpc.TestServiceFutureStub futureStub() {
        return this.futureStub;
    }

    public void shutdown() {
        log.info("shutdown");
        this.channelManager.shutdown();
    }

    public void shutdownNow() {
        log.info("shutdownNow");
        this.channelManager.shutdownNow();
    }

    public boolean isShutdown() {
        return this.channelManager.isShutdown();
    }

    public boolean isTerminated() {
        return this.channelManager.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return this.channelManager.awaitTermination(timeout, unit);
    }

    public void connect(@Nullable Duration timeout) {
        this.channelManager.connect("temporal.api.testservice.v1.TestService", timeout);
    }

    public HealthCheckResponse healthCheck() {
        return this.channelManager.healthCheck("temporal.api.testservice.v1.TestService", null);
    }

    public Supplier<GetSystemInfoResponse.Capabilities> getServerCapabilities() {
        return this.channelManager.getServerCapabilities();
    }
}

