/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.internal.testservice.ExecutionId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

class ActivityTaskToken {
    @Nonnull
    private final ExecutionId executionId;
    private final long scheduledEventId;
    private final int attempt;

    ActivityTaskToken(@Nonnull String namespace, @Nonnull WorkflowExecution execution, long scheduledEventId, int attempt) {
        this(new ExecutionId(Objects.requireNonNull(namespace), Objects.requireNonNull(execution)), scheduledEventId, attempt);
    }

    ActivityTaskToken(@Nonnull String namespace, @Nonnull String workflowId, @Nonnull String runId, long scheduledEventId, int attempt) {
        this(namespace, WorkflowExecution.newBuilder().setWorkflowId(Objects.requireNonNull(workflowId)).setRunId(Objects.requireNonNull(runId)).build(), scheduledEventId, attempt);
    }

    ActivityTaskToken(@Nonnull ExecutionId executionId, long scheduledEventId, int attempt) {
        this.executionId = Objects.requireNonNull(executionId);
        this.scheduledEventId = scheduledEventId;
        this.attempt = attempt;
    }

    @Nonnull
    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public long getScheduledEventId() {
        return this.scheduledEventId;
    }

    public long getAttempt() {
        return this.attempt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteString toBytes() {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ByteString byteString;
            try (DataOutputStream out = new DataOutputStream(bout);){
                out.writeUTF(this.executionId.getNamespace());
                WorkflowExecution execution = this.executionId.getExecution();
                out.writeUTF(execution.getWorkflowId());
                out.writeUTF(execution.getRunId());
                out.writeLong(this.scheduledEventId);
                out.writeInt(this.attempt);
                byteString = ByteString.copyFrom((byte[])bout.toByteArray());
            }
            return byteString;
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }

    static ActivityTaskToken fromBytes(ByteString serialized) {
        return ActivityTaskToken.fromBytes(serialized.toByteArray());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static ActivityTaskToken fromBytes(byte[] serialized) {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(serialized);){
            ActivityTaskToken activityTaskToken;
            try (DataInputStream in = new DataInputStream(bin);){
                String namespace = in.readUTF();
                String workflowId = in.readUTF();
                String runId = in.readUTF();
                long scheduledEventId = in.readLong();
                int attempt = in.readInt();
                activityTaskToken = new ActivityTaskToken(namespace, workflowId, runId, scheduledEventId, attempt);
            }
            return activityTaskToken;
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityTaskToken that = (ActivityTaskToken)o;
        return this.scheduledEventId == that.scheduledEventId && this.attempt == that.attempt && this.executionId.equals(that.executionId);
    }

    public int hashCode() {
        return Objects.hash(this.executionId, this.scheduledEventId, this.attempt);
    }

    public String toString() {
        return "ActivityTaskToken{executionId=" + this.executionId + ", scheduledEventId=" + this.scheduledEventId + ", attempt=" + this.attempt + '}';
    }
}

