package io.temporal.api.testservice.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * TestService API defines an interface supported only by the Temporal Test Server.
 * It provides functionality needed or supported for testing purposes only.
 * This is an EXPERIMENTAL API.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.34.0)",
    comments = "Source: temporal/api/testservice/v1/service.proto")
public final class TestServiceGrpc {

  private TestServiceGrpc() {}

  public static final String SERVICE_NAME = "temporal.api.testservice.v1.TestService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.LockTimeSkippingRequest,
      io.temporal.api.testservice.v1.LockTimeSkippingResponse> getLockTimeSkippingMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "LockTimeSkipping",
      requestType = io.temporal.api.testservice.v1.LockTimeSkippingRequest.class,
      responseType = io.temporal.api.testservice.v1.LockTimeSkippingResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.LockTimeSkippingRequest,
      io.temporal.api.testservice.v1.LockTimeSkippingResponse> getLockTimeSkippingMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.LockTimeSkippingRequest, io.temporal.api.testservice.v1.LockTimeSkippingResponse> getLockTimeSkippingMethod;
    if ((getLockTimeSkippingMethod = TestServiceGrpc.getLockTimeSkippingMethod) == null) {
      synchronized (TestServiceGrpc.class) {
        if ((getLockTimeSkippingMethod = TestServiceGrpc.getLockTimeSkippingMethod) == null) {
          TestServiceGrpc.getLockTimeSkippingMethod = getLockTimeSkippingMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.testservice.v1.LockTimeSkippingRequest, io.temporal.api.testservice.v1.LockTimeSkippingResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "LockTimeSkipping"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.LockTimeSkippingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.LockTimeSkippingResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TestServiceMethodDescriptorSupplier("LockTimeSkipping"))
              .build();
        }
      }
    }
    return getLockTimeSkippingMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.UnlockTimeSkippingRequest,
      io.temporal.api.testservice.v1.UnlockTimeSkippingResponse> getUnlockTimeSkippingMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UnlockTimeSkipping",
      requestType = io.temporal.api.testservice.v1.UnlockTimeSkippingRequest.class,
      responseType = io.temporal.api.testservice.v1.UnlockTimeSkippingResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.UnlockTimeSkippingRequest,
      io.temporal.api.testservice.v1.UnlockTimeSkippingResponse> getUnlockTimeSkippingMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.UnlockTimeSkippingRequest, io.temporal.api.testservice.v1.UnlockTimeSkippingResponse> getUnlockTimeSkippingMethod;
    if ((getUnlockTimeSkippingMethod = TestServiceGrpc.getUnlockTimeSkippingMethod) == null) {
      synchronized (TestServiceGrpc.class) {
        if ((getUnlockTimeSkippingMethod = TestServiceGrpc.getUnlockTimeSkippingMethod) == null) {
          TestServiceGrpc.getUnlockTimeSkippingMethod = getUnlockTimeSkippingMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.testservice.v1.UnlockTimeSkippingRequest, io.temporal.api.testservice.v1.UnlockTimeSkippingResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UnlockTimeSkipping"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.UnlockTimeSkippingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.UnlockTimeSkippingResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TestServiceMethodDescriptorSupplier("UnlockTimeSkipping"))
              .build();
        }
      }
    }
    return getUnlockTimeSkippingMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepRequest,
      io.temporal.api.testservice.v1.SleepResponse> getSleepMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Sleep",
      requestType = io.temporal.api.testservice.v1.SleepRequest.class,
      responseType = io.temporal.api.testservice.v1.SleepResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepRequest,
      io.temporal.api.testservice.v1.SleepResponse> getSleepMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepRequest, io.temporal.api.testservice.v1.SleepResponse> getSleepMethod;
    if ((getSleepMethod = TestServiceGrpc.getSleepMethod) == null) {
      synchronized (TestServiceGrpc.class) {
        if ((getSleepMethod = TestServiceGrpc.getSleepMethod) == null) {
          TestServiceGrpc.getSleepMethod = getSleepMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.testservice.v1.SleepRequest, io.temporal.api.testservice.v1.SleepResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Sleep"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.SleepRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.SleepResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TestServiceMethodDescriptorSupplier("Sleep"))
              .build();
        }
      }
    }
    return getSleepMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepUntilRequest,
      io.temporal.api.testservice.v1.SleepResponse> getSleepUntilMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SleepUntil",
      requestType = io.temporal.api.testservice.v1.SleepUntilRequest.class,
      responseType = io.temporal.api.testservice.v1.SleepResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepUntilRequest,
      io.temporal.api.testservice.v1.SleepResponse> getSleepUntilMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepUntilRequest, io.temporal.api.testservice.v1.SleepResponse> getSleepUntilMethod;
    if ((getSleepUntilMethod = TestServiceGrpc.getSleepUntilMethod) == null) {
      synchronized (TestServiceGrpc.class) {
        if ((getSleepUntilMethod = TestServiceGrpc.getSleepUntilMethod) == null) {
          TestServiceGrpc.getSleepUntilMethod = getSleepUntilMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.testservice.v1.SleepUntilRequest, io.temporal.api.testservice.v1.SleepResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SleepUntil"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.SleepUntilRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.SleepResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TestServiceMethodDescriptorSupplier("SleepUntil"))
              .build();
        }
      }
    }
    return getSleepUntilMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepRequest,
      io.temporal.api.testservice.v1.SleepResponse> getUnlockTimeSkippingWithSleepMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UnlockTimeSkippingWithSleep",
      requestType = io.temporal.api.testservice.v1.SleepRequest.class,
      responseType = io.temporal.api.testservice.v1.SleepResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepRequest,
      io.temporal.api.testservice.v1.SleepResponse> getUnlockTimeSkippingWithSleepMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.testservice.v1.SleepRequest, io.temporal.api.testservice.v1.SleepResponse> getUnlockTimeSkippingWithSleepMethod;
    if ((getUnlockTimeSkippingWithSleepMethod = TestServiceGrpc.getUnlockTimeSkippingWithSleepMethod) == null) {
      synchronized (TestServiceGrpc.class) {
        if ((getUnlockTimeSkippingWithSleepMethod = TestServiceGrpc.getUnlockTimeSkippingWithSleepMethod) == null) {
          TestServiceGrpc.getUnlockTimeSkippingWithSleepMethod = getUnlockTimeSkippingWithSleepMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.testservice.v1.SleepRequest, io.temporal.api.testservice.v1.SleepResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UnlockTimeSkippingWithSleep"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.SleepRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.SleepResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TestServiceMethodDescriptorSupplier("UnlockTimeSkippingWithSleep"))
              .build();
        }
      }
    }
    return getUnlockTimeSkippingWithSleepMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.temporal.api.testservice.v1.GetCurrentTimeResponse> getGetCurrentTimeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetCurrentTime",
      requestType = com.google.protobuf.Empty.class,
      responseType = io.temporal.api.testservice.v1.GetCurrentTimeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.temporal.api.testservice.v1.GetCurrentTimeResponse> getGetCurrentTimeMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, io.temporal.api.testservice.v1.GetCurrentTimeResponse> getGetCurrentTimeMethod;
    if ((getGetCurrentTimeMethod = TestServiceGrpc.getGetCurrentTimeMethod) == null) {
      synchronized (TestServiceGrpc.class) {
        if ((getGetCurrentTimeMethod = TestServiceGrpc.getGetCurrentTimeMethod) == null) {
          TestServiceGrpc.getGetCurrentTimeMethod = getGetCurrentTimeMethod =
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, io.temporal.api.testservice.v1.GetCurrentTimeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetCurrentTime"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.testservice.v1.GetCurrentTimeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TestServiceMethodDescriptorSupplier("GetCurrentTime"))
              .build();
        }
      }
    }
    return getGetCurrentTimeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TestServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TestServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TestServiceStub>() {
        @java.lang.Override
        public TestServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TestServiceStub(channel, callOptions);
        }
      };
    return TestServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TestServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TestServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TestServiceBlockingStub>() {
        @java.lang.Override
        public TestServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TestServiceBlockingStub(channel, callOptions);
        }
      };
    return TestServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TestServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TestServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TestServiceFutureStub>() {
        @java.lang.Override
        public TestServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TestServiceFutureStub(channel, callOptions);
        }
      };
    return TestServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * TestService API defines an interface supported only by the Temporal Test Server.
   * It provides functionality needed or supported for testing purposes only.
   * This is an EXPERIMENTAL API.
   * </pre>
   */
  public static abstract class TestServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * LockTimeSkipping increments Time Locking Counter by one.
     * If Time Locking Counter is positive, time skipping is locked (disabled).
     * When time skipping is disabled, the time in test server is moving normally, with a real time pace.
     * Test Server is typically started with locked time skipping and Time Locking Counter = 1.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted.
     * </pre>
     */
    public void lockTimeSkipping(io.temporal.api.testservice.v1.LockTimeSkippingRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.LockTimeSkippingResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getLockTimeSkippingMethod(), responseObserver);
    }

    /**
     * <pre>
     * UnlockTimeSkipping decrements Time Locking Counter by one.
     * If the counter reaches 0, it unlocks time skipping and fast forwards time.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted. Calling UnlockTimeSkipping does not
     * guarantee that time is going to be fast forwarded as another lock can be holding it.
     * Time Locking Counter can't be negative, unbalanced calls to UnlockTimeSkipping will lead to rpc call failure
     * </pre>
     */
    public void unlockTimeSkipping(io.temporal.api.testservice.v1.UnlockTimeSkippingRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.UnlockTimeSkippingResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUnlockTimeSkippingMethod(), responseObserver);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances by the specified duration.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public void sleep(io.temporal.api.testservice.v1.SleepRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSleepMethod(), responseObserver);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances to the specified timestamp.
     * If the current Test Server Time is beyond the specified timestamp, returns immediately.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public void sleepUntil(io.temporal.api.testservice.v1.SleepUntilRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSleepUntilMethod(), responseObserver);
    }

    /**
     * <pre>
     * UnlockTimeSkippingWhileSleep decreases time locking counter by one and increases it back
     * once the Test Server Time advances by the duration specified in the request.
     * This call returns only when the Test Server Time advances by the specified duration.
     * If it is called when Time Locking Counter is
     *   - more than 1 and no other unlocks are coming in, rpc call will block for the specified duration, time will not be fast forwarded.
     *   - 1, it will lead to fast forwarding of the time by the duration specified in the request and quick return of this rpc call.
     *   - 0 will lead to rpc call failure same way as an unbalanced UnlockTimeSkipping.
     * </pre>
     */
    public void unlockTimeSkippingWithSleep(io.temporal.api.testservice.v1.SleepRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUnlockTimeSkippingWithSleepMethod(), responseObserver);
    }

    /**
     * <pre>
     * GetCurrentTime returns the current Temporal Test Server time
     * This time might not be equal to {&#64;link System#currentTimeMillis()} due to time skipping.
     * </pre>
     */
    public void getCurrentTime(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.GetCurrentTimeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetCurrentTimeMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getLockTimeSkippingMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.testservice.v1.LockTimeSkippingRequest,
                io.temporal.api.testservice.v1.LockTimeSkippingResponse>(
                  this, METHODID_LOCK_TIME_SKIPPING)))
          .addMethod(
            getUnlockTimeSkippingMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.testservice.v1.UnlockTimeSkippingRequest,
                io.temporal.api.testservice.v1.UnlockTimeSkippingResponse>(
                  this, METHODID_UNLOCK_TIME_SKIPPING)))
          .addMethod(
            getSleepMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.testservice.v1.SleepRequest,
                io.temporal.api.testservice.v1.SleepResponse>(
                  this, METHODID_SLEEP)))
          .addMethod(
            getSleepUntilMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.testservice.v1.SleepUntilRequest,
                io.temporal.api.testservice.v1.SleepResponse>(
                  this, METHODID_SLEEP_UNTIL)))
          .addMethod(
            getUnlockTimeSkippingWithSleepMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.testservice.v1.SleepRequest,
                io.temporal.api.testservice.v1.SleepResponse>(
                  this, METHODID_UNLOCK_TIME_SKIPPING_WITH_SLEEP)))
          .addMethod(
            getGetCurrentTimeMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                com.google.protobuf.Empty,
                io.temporal.api.testservice.v1.GetCurrentTimeResponse>(
                  this, METHODID_GET_CURRENT_TIME)))
          .build();
    }
  }

  /**
   * <pre>
   * TestService API defines an interface supported only by the Temporal Test Server.
   * It provides functionality needed or supported for testing purposes only.
   * This is an EXPERIMENTAL API.
   * </pre>
   */
  public static final class TestServiceStub extends io.grpc.stub.AbstractAsyncStub<TestServiceStub> {
    private TestServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TestServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TestServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * LockTimeSkipping increments Time Locking Counter by one.
     * If Time Locking Counter is positive, time skipping is locked (disabled).
     * When time skipping is disabled, the time in test server is moving normally, with a real time pace.
     * Test Server is typically started with locked time skipping and Time Locking Counter = 1.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted.
     * </pre>
     */
    public void lockTimeSkipping(io.temporal.api.testservice.v1.LockTimeSkippingRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.LockTimeSkippingResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getLockTimeSkippingMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UnlockTimeSkipping decrements Time Locking Counter by one.
     * If the counter reaches 0, it unlocks time skipping and fast forwards time.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted. Calling UnlockTimeSkipping does not
     * guarantee that time is going to be fast forwarded as another lock can be holding it.
     * Time Locking Counter can't be negative, unbalanced calls to UnlockTimeSkipping will lead to rpc call failure
     * </pre>
     */
    public void unlockTimeSkipping(io.temporal.api.testservice.v1.UnlockTimeSkippingRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.UnlockTimeSkippingResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUnlockTimeSkippingMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances by the specified duration.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public void sleep(io.temporal.api.testservice.v1.SleepRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSleepMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances to the specified timestamp.
     * If the current Test Server Time is beyond the specified timestamp, returns immediately.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public void sleepUntil(io.temporal.api.testservice.v1.SleepUntilRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSleepUntilMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UnlockTimeSkippingWhileSleep decreases time locking counter by one and increases it back
     * once the Test Server Time advances by the duration specified in the request.
     * This call returns only when the Test Server Time advances by the specified duration.
     * If it is called when Time Locking Counter is
     *   - more than 1 and no other unlocks are coming in, rpc call will block for the specified duration, time will not be fast forwarded.
     *   - 1, it will lead to fast forwarding of the time by the duration specified in the request and quick return of this rpc call.
     *   - 0 will lead to rpc call failure same way as an unbalanced UnlockTimeSkipping.
     * </pre>
     */
    public void unlockTimeSkippingWithSleep(io.temporal.api.testservice.v1.SleepRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUnlockTimeSkippingWithSleepMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * GetCurrentTime returns the current Temporal Test Server time
     * This time might not be equal to {&#64;link System#currentTimeMillis()} due to time skipping.
     * </pre>
     */
    public void getCurrentTime(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.GetCurrentTimeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetCurrentTimeMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * TestService API defines an interface supported only by the Temporal Test Server.
   * It provides functionality needed or supported for testing purposes only.
   * This is an EXPERIMENTAL API.
   * </pre>
   */
  public static final class TestServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<TestServiceBlockingStub> {
    private TestServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TestServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TestServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * LockTimeSkipping increments Time Locking Counter by one.
     * If Time Locking Counter is positive, time skipping is locked (disabled).
     * When time skipping is disabled, the time in test server is moving normally, with a real time pace.
     * Test Server is typically started with locked time skipping and Time Locking Counter = 1.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted.
     * </pre>
     */
    public io.temporal.api.testservice.v1.LockTimeSkippingResponse lockTimeSkipping(io.temporal.api.testservice.v1.LockTimeSkippingRequest request) {
      return blockingUnaryCall(
          getChannel(), getLockTimeSkippingMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UnlockTimeSkipping decrements Time Locking Counter by one.
     * If the counter reaches 0, it unlocks time skipping and fast forwards time.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted. Calling UnlockTimeSkipping does not
     * guarantee that time is going to be fast forwarded as another lock can be holding it.
     * Time Locking Counter can't be negative, unbalanced calls to UnlockTimeSkipping will lead to rpc call failure
     * </pre>
     */
    public io.temporal.api.testservice.v1.UnlockTimeSkippingResponse unlockTimeSkipping(io.temporal.api.testservice.v1.UnlockTimeSkippingRequest request) {
      return blockingUnaryCall(
          getChannel(), getUnlockTimeSkippingMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances by the specified duration.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public io.temporal.api.testservice.v1.SleepResponse sleep(io.temporal.api.testservice.v1.SleepRequest request) {
      return blockingUnaryCall(
          getChannel(), getSleepMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances to the specified timestamp.
     * If the current Test Server Time is beyond the specified timestamp, returns immediately.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public io.temporal.api.testservice.v1.SleepResponse sleepUntil(io.temporal.api.testservice.v1.SleepUntilRequest request) {
      return blockingUnaryCall(
          getChannel(), getSleepUntilMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UnlockTimeSkippingWhileSleep decreases time locking counter by one and increases it back
     * once the Test Server Time advances by the duration specified in the request.
     * This call returns only when the Test Server Time advances by the specified duration.
     * If it is called when Time Locking Counter is
     *   - more than 1 and no other unlocks are coming in, rpc call will block for the specified duration, time will not be fast forwarded.
     *   - 1, it will lead to fast forwarding of the time by the duration specified in the request and quick return of this rpc call.
     *   - 0 will lead to rpc call failure same way as an unbalanced UnlockTimeSkipping.
     * </pre>
     */
    public io.temporal.api.testservice.v1.SleepResponse unlockTimeSkippingWithSleep(io.temporal.api.testservice.v1.SleepRequest request) {
      return blockingUnaryCall(
          getChannel(), getUnlockTimeSkippingWithSleepMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * GetCurrentTime returns the current Temporal Test Server time
     * This time might not be equal to {&#64;link System#currentTimeMillis()} due to time skipping.
     * </pre>
     */
    public io.temporal.api.testservice.v1.GetCurrentTimeResponse getCurrentTime(com.google.protobuf.Empty request) {
      return blockingUnaryCall(
          getChannel(), getGetCurrentTimeMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * TestService API defines an interface supported only by the Temporal Test Server.
   * It provides functionality needed or supported for testing purposes only.
   * This is an EXPERIMENTAL API.
   * </pre>
   */
  public static final class TestServiceFutureStub extends io.grpc.stub.AbstractFutureStub<TestServiceFutureStub> {
    private TestServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TestServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TestServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * LockTimeSkipping increments Time Locking Counter by one.
     * If Time Locking Counter is positive, time skipping is locked (disabled).
     * When time skipping is disabled, the time in test server is moving normally, with a real time pace.
     * Test Server is typically started with locked time skipping and Time Locking Counter = 1.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.testservice.v1.LockTimeSkippingResponse> lockTimeSkipping(
        io.temporal.api.testservice.v1.LockTimeSkippingRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getLockTimeSkippingMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UnlockTimeSkipping decrements Time Locking Counter by one.
     * If the counter reaches 0, it unlocks time skipping and fast forwards time.
     * LockTimeSkipping and UnlockTimeSkipping calls are counted. Calling UnlockTimeSkipping does not
     * guarantee that time is going to be fast forwarded as another lock can be holding it.
     * Time Locking Counter can't be negative, unbalanced calls to UnlockTimeSkipping will lead to rpc call failure
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.testservice.v1.UnlockTimeSkippingResponse> unlockTimeSkipping(
        io.temporal.api.testservice.v1.UnlockTimeSkippingRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUnlockTimeSkippingMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances by the specified duration.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.testservice.v1.SleepResponse> sleep(
        io.temporal.api.testservice.v1.SleepRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSleepMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * This call returns only when the Test Server Time advances to the specified timestamp.
     * If the current Test Server Time is beyond the specified timestamp, returns immediately.
     * This is an EXPERIMENTAL API.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.testservice.v1.SleepResponse> sleepUntil(
        io.temporal.api.testservice.v1.SleepUntilRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSleepUntilMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UnlockTimeSkippingWhileSleep decreases time locking counter by one and increases it back
     * once the Test Server Time advances by the duration specified in the request.
     * This call returns only when the Test Server Time advances by the specified duration.
     * If it is called when Time Locking Counter is
     *   - more than 1 and no other unlocks are coming in, rpc call will block for the specified duration, time will not be fast forwarded.
     *   - 1, it will lead to fast forwarding of the time by the duration specified in the request and quick return of this rpc call.
     *   - 0 will lead to rpc call failure same way as an unbalanced UnlockTimeSkipping.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.testservice.v1.SleepResponse> unlockTimeSkippingWithSleep(
        io.temporal.api.testservice.v1.SleepRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUnlockTimeSkippingWithSleepMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * GetCurrentTime returns the current Temporal Test Server time
     * This time might not be equal to {&#64;link System#currentTimeMillis()} due to time skipping.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.testservice.v1.GetCurrentTimeResponse> getCurrentTime(
        com.google.protobuf.Empty request) {
      return futureUnaryCall(
          getChannel().newCall(getGetCurrentTimeMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LOCK_TIME_SKIPPING = 0;
  private static final int METHODID_UNLOCK_TIME_SKIPPING = 1;
  private static final int METHODID_SLEEP = 2;
  private static final int METHODID_SLEEP_UNTIL = 3;
  private static final int METHODID_UNLOCK_TIME_SKIPPING_WITH_SLEEP = 4;
  private static final int METHODID_GET_CURRENT_TIME = 5;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final TestServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(TestServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LOCK_TIME_SKIPPING:
          serviceImpl.lockTimeSkipping((io.temporal.api.testservice.v1.LockTimeSkippingRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.LockTimeSkippingResponse>) responseObserver);
          break;
        case METHODID_UNLOCK_TIME_SKIPPING:
          serviceImpl.unlockTimeSkipping((io.temporal.api.testservice.v1.UnlockTimeSkippingRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.UnlockTimeSkippingResponse>) responseObserver);
          break;
        case METHODID_SLEEP:
          serviceImpl.sleep((io.temporal.api.testservice.v1.SleepRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse>) responseObserver);
          break;
        case METHODID_SLEEP_UNTIL:
          serviceImpl.sleepUntil((io.temporal.api.testservice.v1.SleepUntilRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse>) responseObserver);
          break;
        case METHODID_UNLOCK_TIME_SKIPPING_WITH_SLEEP:
          serviceImpl.unlockTimeSkippingWithSleep((io.temporal.api.testservice.v1.SleepRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.SleepResponse>) responseObserver);
          break;
        case METHODID_GET_CURRENT_TIME:
          serviceImpl.getCurrentTime((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.testservice.v1.GetCurrentTimeResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class TestServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TestServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.temporal.api.testservice.v1.ServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("TestService");
    }
  }

  private static final class TestServiceFileDescriptorSupplier
      extends TestServiceBaseDescriptorSupplier {
    TestServiceFileDescriptorSupplier() {}
  }

  private static final class TestServiceMethodDescriptorSupplier
      extends TestServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    TestServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TestServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TestServiceFileDescriptorSupplier())
              .addMethod(getLockTimeSkippingMethod())
              .addMethod(getUnlockTimeSkippingMethod())
              .addMethod(getSleepMethod())
              .addMethod(getSleepUntilMethod())
              .addMethod(getUnlockTimeSkippingWithSleepMethod())
              .addMethod(getGetCurrentTimeMethod())
              .build();
        }
      }
    }
    return result;
  }
}
