/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.opentracing.Tracer;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.NamespaceProperties;
import io.temporal.spring.boot.autoconfigure.properties.TemporalProperties;
import io.temporal.spring.boot.autoconfigure.template.ClientTemplate;
import io.temporal.spring.boot.autoconfigure.template.TestWorkflowEnvironmentAdapter;
import io.temporal.spring.boot.autoconfigure.template.WorkersTemplate;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NamespaceTemplate {
    @Nonnull
    private final TemporalProperties properties;
    @Nonnull
    private final NamespaceProperties namespaceProperties;
    @Nonnull
    private final WorkflowServiceStubs workflowServiceStubs;
    @Nullable
    private final DataConverter dataConverter;
    @Nullable
    private final Tracer tracer;
    @Nullable
    private final TestWorkflowEnvironmentAdapter testWorkflowEnvironment;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer;
    @Nullable
    private final TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer;
    private ClientTemplate clientTemplate;
    private WorkersTemplate workersTemplate;

    public NamespaceTemplate(@Nonnull TemporalProperties properties, @Nonnull NamespaceProperties namespaceProperties, @Nonnull WorkflowServiceStubs workflowServiceStubs, @Nullable DataConverter dataConverter, @Nullable Tracer tracer, @Nullable TestWorkflowEnvironmentAdapter testWorkflowEnvironment, @Nullable TemporalOptionsCustomizer<WorkerFactoryOptions.Builder> workerFactoryCustomizer, @Nullable TemporalOptionsCustomizer<WorkerOptions.Builder> workerCustomizer, @Nullable TemporalOptionsCustomizer<WorkflowClientOptions.Builder> clientCustomizer) {
        this.properties = properties;
        this.namespaceProperties = namespaceProperties;
        this.workflowServiceStubs = workflowServiceStubs;
        this.dataConverter = dataConverter;
        this.tracer = tracer;
        this.testWorkflowEnvironment = testWorkflowEnvironment;
        this.workerFactoryCustomizer = workerFactoryCustomizer;
        this.workerCustomizer = workerCustomizer;
        this.clientCustomizer = clientCustomizer;
    }

    public ClientTemplate getClientTemplate() {
        if (this.clientTemplate == null) {
            this.clientTemplate = new ClientTemplate(this.namespaceProperties.getNamespace(), this.dataConverter, this.tracer, this.workflowServiceStubs, this.testWorkflowEnvironment, this.clientCustomizer);
        }
        return this.clientTemplate;
    }

    public WorkersTemplate getWorkersTemplate() {
        if (this.workersTemplate == null) {
            this.workersTemplate = new WorkersTemplate(this.properties, this.namespaceProperties, this.getClientTemplate(), this.tracer, this.testWorkflowEnvironment, this.workerFactoryCustomizer, this.workerCustomizer);
        }
        return this.workersTemplate;
    }
}

