/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.temporal.serviceclient.GrpcMetadataProvider;
import java.util.Collection;

public class GrpcMetadataProviderInterceptor
implements ClientInterceptor {
    private final Collection<GrpcMetadataProvider> grpcMetadataProviders;
    private final boolean override;

    public GrpcMetadataProviderInterceptor(Collection<GrpcMetadataProvider> grpcMetadataProviders) {
        this.grpcMetadataProviders = (Collection)Preconditions.checkNotNull(grpcMetadataProviders, (Object)"grpcMetadataProviders");
        this.override = false;
    }

    public GrpcMetadataProviderInterceptor(Collection<GrpcMetadataProvider> grpcMetadataProviders, boolean override) {
        this.grpcMetadataProviders = (Collection)Preconditions.checkNotNull(grpcMetadataProviders, (Object)"grpcMetadataProviders");
        this.override = override;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new HeaderAttachingClientCall(next.newCall(method, callOptions));
    }

    private final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
            super(call);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            GrpcMetadataProviderInterceptor.this.grpcMetadataProviders.stream().map(GrpcMetadataProvider::getMetadata).forEach(m -> {
                if (GrpcMetadataProviderInterceptor.this.override) {
                    for (String key : m.keys()) {
                        headers.discardAll(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                    }
                }
                headers.merge(m);
            });
            super.start(responseListener, headers);
        }
    }
}

