/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SimpleSslContextBuilder {
    @Nullable
    private final PKCS pkcs;
    @Nullable
    private final InputStream keyCertChain;
    @Nullable
    private final InputStream key;
    private TrustManager trustManager;
    private boolean useInsecureTrustManager;
    private String keyPassword;

    @Deprecated
    public static SimpleSslContextBuilder newBuilder(InputStream keyCertChain, InputStream key) {
        return SimpleSslContextBuilder.forPKCS8(keyCertChain, key);
    }

    public static SimpleSslContextBuilder noKeyOrCertChain() {
        return new SimpleSslContextBuilder(null, null, null);
    }

    public static SimpleSslContextBuilder forPKCS8(@Nullable InputStream keyCertChain, @Nullable InputStream key) {
        return new SimpleSslContextBuilder(PKCS.PKCS_8, keyCertChain, key);
    }

    public static SimpleSslContextBuilder forPKCS12(@Nullable InputStream pfxKeyArchive) {
        return new SimpleSslContextBuilder(PKCS.PKCS_12, null, pfxKeyArchive);
    }

    private SimpleSslContextBuilder(@Nullable PKCS pkcs, @Nullable InputStream keyCertChain, @Nullable InputStream key) {
        this.pkcs = pkcs;
        this.keyCertChain = keyCertChain;
        this.key = key;
    }

    public SslContextBuilder configure(SslContextBuilder sslContextBuilder) throws SSLException {
        if (this.trustManager != null && this.useInsecureTrustManager) {
            throw new IllegalArgumentException("Can not use insecure trust manager if custom trust manager is set.");
        }
        GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
        sslContextBuilder.trustManager(this.trustManager != null ? this.trustManager : (this.useInsecureTrustManager ? InsecureTrustManagerFactory.INSTANCE.getTrustManagers()[0] : this.getDefaultTrustManager()));
        if (this.pkcs != null && (this.key != null || this.keyCertChain != null)) {
            switch (this.pkcs) {
                case PKCS_8: {
                    sslContextBuilder.keyManager(this.keyCertChain, this.key, this.keyPassword);
                    break;
                }
                case PKCS_12: {
                    sslContextBuilder.keyManager(this.createPKCS12KeyManager());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PKCS " + (Object)((Object)this.pkcs) + " is not implemented");
                }
            }
        }
        return sslContextBuilder;
    }

    public SslContext build() throws SSLException {
        return this.configure(SslContextBuilder.forClient()).build();
    }

    public SimpleSslContextBuilder setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public SimpleSslContextBuilder setUseInsecureTrustManager(boolean useInsecureTrustManager) {
        this.useInsecureTrustManager = useInsecureTrustManager;
        return this;
    }

    public SimpleSslContextBuilder setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    private KeyManagerFactory createPKCS12KeyManager() {
        char[] passwordChars = this.keyPassword != null ? this.keyPassword.toCharArray() : null;
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(this.key, passwordChars);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, passwordChars);
            return kmf;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input stream does not contain a valid PKCS12 key", e);
        }
    }

    private X509TrustManager getDefaultTrustManager() {
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new UnknownDefaultTrustManagerException(e);
        }
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new UnknownDefaultTrustManagerException("Unable to find X509TrustManager in the list of default trust managers.");
    }

    public static final class UnknownDefaultTrustManagerException
    extends RuntimeException {
        public UnknownDefaultTrustManagerException(Throwable cause) {
            super(cause);
        }

        public UnknownDefaultTrustManagerException(String message) {
            super(message);
        }
    }

    private static enum PKCS {
        PKCS_8,
        PKCS_12;

    }
}

