/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.ManagedChannel;
import io.grpc.health.v1.HealthCheckResponse;
import io.temporal.api.cloud.cloudservice.v1.CloudServiceGrpc;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.serviceclient.ChannelManager;
import io.temporal.serviceclient.CloudServiceStubs;
import io.temporal.serviceclient.CloudServiceStubsOptions;
import io.temporal.serviceclient.GrpcDeadlineInterceptor;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CloudServiceStubsImpl
implements CloudServiceStubs {
    private static final Logger log = LoggerFactory.getLogger(CloudServiceStubsImpl.class);
    private final ChannelManager channelManager;
    private final CloudServiceGrpc.CloudServiceBlockingStub blockingStub;
    private final CloudServiceGrpc.CloudServiceFutureStub futureStub;

    CloudServiceStubsImpl(CloudServiceStubsOptions options) {
        GrpcDeadlineInterceptor deadlineInterceptor = new GrpcDeadlineInterceptor(options.getRpcTimeout(), null, null);
        options = CloudServiceStubsOptions.newBuilder(options).validateAndBuildWithDefaults();
        this.channelManager = new ChannelManager(options, Collections.singletonList(deadlineInterceptor), GetSystemInfoResponse.Capabilities.newBuilder().setInternalErrorDifferentiation(true).build());
        log.info("Created CloudServiceStubs for channel: {}", (Object)this.channelManager.getRawChannel());
        this.blockingStub = CloudServiceGrpc.newBlockingStub(this.channelManager.getInterceptedChannel());
        this.futureStub = CloudServiceGrpc.newFutureStub(this.channelManager.getInterceptedChannel());
    }

    @Override
    public ManagedChannel getRawChannel() {
        return this.channelManager.getRawChannel();
    }

    @Override
    public CloudServiceGrpc.CloudServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    @Override
    public CloudServiceGrpc.CloudServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    public void shutdown() {
        log.info("shutdown");
        this.channelManager.shutdown();
    }

    @Override
    public void shutdownNow() {
        log.info("shutdownNow");
        this.channelManager.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.channelManager.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.channelManager.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return this.channelManager.awaitTermination(timeout, unit);
    }

    @Override
    public void connect(@Nullable Duration timeout) {
        this.channelManager.connect("temporal.api.cloud.cloudservice.v1.CloudService", timeout);
    }

    @Override
    public HealthCheckResponse healthCheck() {
        return this.channelManager.healthCheck("temporal.api.cloud.cloudservice.v1.CloudService", null);
    }

    @Override
    public Supplier<GetSystemInfoResponse.Capabilities> getServerCapabilities() {
        return this.channelManager.getServerCapabilities();
    }
}

