/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;

public abstract class WorkflowThreadMarker {
    protected static final ThreadLocal<Boolean> isWorkflowThreadThreadLocal = ThreadLocal.withInitial(() -> false);
    private static final boolean enableEnforcements;

    public static boolean isWorkflowThread() {
        return isWorkflowThreadThreadLocal.get();
    }

    public static void enforceNonWorkflowThread() {
        if (enableEnforcements && WorkflowThreadMarker.isWorkflowThread()) {
            throw new IllegalStateException("Cannot be called from workflow thread.");
        }
    }

    public static <T> T protectFromWorkflowThread(T instance, Class<T> iface) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (proxy, method, args) -> {
            WorkflowThreadMarker.enforceNonWorkflowThread();
            try {
                return method.invoke(instance, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        });
    }

    static {
        String envValue = System.getenv("TEMPORAL_DISABLE_NON_WORKFLOW_CODE_ENFORCEMENTS");
        enableEnforcements = envValue == null || "false".equalsIgnoreCase(envValue);
    }
}

