/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.temporal.serviceclient.GrpcMetadataProvider;
import java.util.Collection;

public class GrpcMetadataProviderInterceptor
implements ClientInterceptor {
    private final Collection<GrpcMetadataProvider> grpcMetadataProviders;

    public GrpcMetadataProviderInterceptor(Collection<GrpcMetadataProvider> grpcMetadataProviders) {
        this.grpcMetadataProviders = (Collection)Preconditions.checkNotNull(grpcMetadataProviders, (Object)"grpcMetadataProviders");
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new HeaderAttachingClientCall(next.newCall(method, callOptions));
    }

    private final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
            super(call);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            GrpcMetadataProviderInterceptor.this.grpcMetadataProviders.stream().map(GrpcMetadataProvider::getMetadata).forEach(arg_0 -> ((Metadata)headers).merge(arg_0));
            super.start(responseListener, headers);
        }
    }
}

