/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BackoffThrottler {
    private final Duration initialSleep;
    private final Duration maxSleep;
    private final double backoffCoefficient;
    private int failureCount = 0;

    public BackoffThrottler(Duration initialSleep, @Nullable Duration maxSleep, double backoffCoefficient) {
        Objects.requireNonNull(initialSleep, "initialSleep");
        this.initialSleep = initialSleep;
        this.maxSleep = maxSleep;
        this.backoffCoefficient = backoffCoefficient;
    }

    public long getSleepTime() {
        if (this.failureCount == 0) {
            return 0L;
        }
        double sleepMillis = Math.pow(this.backoffCoefficient, this.failureCount - 1) * (double)this.initialSleep.toMillis();
        if (this.maxSleep != null) {
            return Math.min((long)sleepMillis, this.maxSleep.toMillis());
        }
        return (long)sleepMillis;
    }

    public int getAttemptCount() {
        return this.failureCount;
    }

    public void success() {
        this.failureCount = 0;
    }

    public void failure() {
        ++this.failureCount;
    }
}

