/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SimpleSslContextBuilder {
    private static final ApplicationProtocolConfig DEFAULT_APPLICATION_PROTOCOL_CONFIG = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"});
    private final InputStream keyCertChain;
    private final InputStream key;
    private TrustManager trustManager;
    private boolean useInsecureTrustManager;
    private String keyPassword;

    public static SimpleSslContextBuilder newBuilder(InputStream keyCertChain, InputStream key) {
        return new SimpleSslContextBuilder(keyCertChain, key);
    }

    private SimpleSslContextBuilder(InputStream keyCertChain, InputStream key) {
        this.keyCertChain = keyCertChain;
        this.key = key;
    }

    public SslContext build() throws SSLException {
        if (this.trustManager != null && this.useInsecureTrustManager) {
            throw new IllegalArgumentException("Can not use insecure trust manager if custom trust manager is set.");
        }
        return SslContextBuilder.forClient().trustManager(this.trustManager != null ? this.trustManager : (this.useInsecureTrustManager ? InsecureTrustManagerFactory.INSTANCE.getTrustManagers()[0] : this.getDefaultTrustManager())).keyManager(this.keyCertChain, this.key, this.keyPassword).applicationProtocolConfig(DEFAULT_APPLICATION_PROTOCOL_CONFIG).build();
    }

    public SimpleSslContextBuilder setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public SimpleSslContextBuilder setUseInsecureTrustManager(boolean useInsecureTrustManager) {
        this.useInsecureTrustManager = useInsecureTrustManager;
        return this;
    }

    public SimpleSslContextBuilder setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    private X509TrustManager getDefaultTrustManager() {
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new UnknownDefaultTrustManagerException(e);
        }
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new UnknownDefaultTrustManagerException("Unable to find X509TrustManager in the list of default trust managers.");
    }

    public static final class UnknownDefaultTrustManagerException
    extends RuntimeException {
        public UnknownDefaultTrustManagerException(Throwable cause) {
            super(cause);
        }

        public UnknownDefaultTrustManagerException(String message) {
            super(message);
        }
    }
}

