/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.LongPollUtil;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcDeadlineInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GrpcDeadlineInterceptor.class);
    private final WorkflowServiceStubsOptions options;

    GrpcDeadlineInterceptor(WorkflowServiceStubsOptions options) {
        this.options = options;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        long duration;
        Deadline deadline = callOptions.getDeadline();
        if (LongPollUtil.isLongPoll(method, callOptions)) {
            duration = this.options.getRpcLongPollTimeout().toMillis();
            if (deadline != null) {
                duration = Math.min(duration, deadline.timeRemaining(TimeUnit.MILLISECONDS));
            }
        } else {
            duration = deadline != null ? deadline.timeRemaining(TimeUnit.MILLISECONDS) : (method == WorkflowServiceGrpc.getQueryWorkflowMethod() ? this.options.getRpcQueryTimeout().toMillis() : this.options.getRpcTimeout().toMillis());
        }
        if (log.isTraceEnabled()) {
            String name = method.getFullMethodName();
            log.trace("method=" + name + ", timeoutMs=" + duration);
        }
        return next.newCall(method, callOptions.withDeadlineAfter(duration, TimeUnit.MILLISECONDS));
    }
}

