/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcTracingInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GrpcTracingInterceptor.class);
    private static final Logger workflow_task_log = LoggerFactory.getLogger((String)(GrpcTracingInterceptor.class.getName() + ":history"));

    GrpcTracingInterceptor() {
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void sendMessage(ReqT message) {
                log.trace("Invoking \"" + method.getFullMethodName() + "\" with input: " + message);
                super.sendMessage(message);
            }

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                ForwardingClientCallListener.SimpleForwardingClientCallListener listener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        if (method == WorkflowServiceGrpc.getPollWorkflowTaskQueueMethod()) {
                            if (workflow_task_log.isTraceEnabled()) {
                                workflow_task_log.trace("Returned \"" + method.getServiceName() + "\" of \"" + method.getFullMethodName() + "\" with output: " + message);
                            } else if (log.isTraceEnabled()) {
                                log.trace("Returned " + method.getFullMethodName());
                            }
                        } else if (log.isTraceEnabled()) {
                            log.trace("Returned \"" + method.getServiceName() + "\" of \"" + method.getFullMethodName() + "\" with output: " + message);
                        }
                        super.onMessage(message);
                    }
                };
                super.start((ClientCall.Listener)listener, headers);
            }
        };
    }

    public boolean isEnabled() {
        return log.isTraceEnabled() || workflow_task_log.isTraceEnabled();
    }
}

