/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import com.google.common.base.Preconditions;

public class ResourceBasedControllerOptions {
    private final double targetMemoryUsage;
    private final double targetCPUUsage;
    private final double memoryPGain;
    private final double memoryIGain;
    private final double memoryDGain;
    private final double memoryOutputThreshold;
    private final double cpuPGain;
    private final double cpuIGain;
    private final double cpuDGain;
    private final double cpuOutputThreshold;

    public static Builder newBuilder(double targetMemoryUsage, double targetCPUUsage) {
        return new Builder().setTargetMemoryUsage(targetMemoryUsage).setTargetCPUUsage(targetCPUUsage);
    }

    private ResourceBasedControllerOptions(Builder builder) {
        this.targetMemoryUsage = builder.targetMemoryUsage;
        this.targetCPUUsage = builder.targetCPUUsage;
        this.memoryPGain = builder.memoryPGain;
        this.memoryIGain = builder.memoryIGain;
        this.memoryDGain = builder.memoryDGain;
        this.memoryOutputThreshold = builder.memoryOutputThreshold;
        this.cpuPGain = builder.cpuPGain;
        this.cpuIGain = builder.cpuIGain;
        this.cpuDGain = builder.cpuDGain;
        this.cpuOutputThreshold = builder.cpuOutputThreshold;
    }

    public double getTargetMemoryUsage() {
        return this.targetMemoryUsage;
    }

    public double getTargetCPUUsage() {
        return this.targetCPUUsage;
    }

    public double getMemoryPGain() {
        return this.memoryPGain;
    }

    public double getMemoryIGain() {
        return this.memoryIGain;
    }

    public double getMemoryDGain() {
        return this.memoryDGain;
    }

    public double getMemoryOutputThreshold() {
        return this.memoryOutputThreshold;
    }

    public double getCpuPGain() {
        return this.cpuPGain;
    }

    public double getCpuIGain() {
        return this.cpuIGain;
    }

    public double getCpuDGain() {
        return this.cpuDGain;
    }

    public double getCpuOutputThreshold() {
        return this.cpuOutputThreshold;
    }

    public static final class Builder {
        private double targetMemoryUsage;
        private double targetCPUUsage;
        private double memoryPGain = 5.0;
        private double memoryIGain = 0.0;
        private double memoryDGain = 1.0;
        private double memoryOutputThreshold = 0.25;
        private double cpuPGain = 5.0;
        private double cpuIGain = 0.0;
        private double cpuDGain = 1.0;
        private double cpuOutputThreshold = 0.05;

        public Builder setTargetMemoryUsage(double targetMemoryUsage) {
            this.targetMemoryUsage = targetMemoryUsage;
            return this;
        }

        public Builder setTargetCPUUsage(double targetCPUUsage) {
            this.targetCPUUsage = targetCPUUsage;
            return this;
        }

        public Builder setMemoryPGain(double memoryPGain) {
            this.memoryPGain = memoryPGain;
            return this;
        }

        public Builder setMemoryIGain(double memoryIGain) {
            this.memoryIGain = memoryIGain;
            return this;
        }

        public Builder setMemoryDGain(double memoryDGain) {
            this.memoryDGain = memoryDGain;
            return this;
        }

        public Builder setMemoryOutputThreshold(double memoryOutputThreshold) {
            this.memoryOutputThreshold = memoryOutputThreshold;
            return this;
        }

        public Builder setCpuPGain(double cpuPGain) {
            this.cpuPGain = cpuPGain;
            return this;
        }

        public Builder setCpuIGain(double cpuIGain) {
            this.cpuIGain = cpuIGain;
            return this;
        }

        public Builder setCpuDGain(double cpuDGain) {
            this.cpuDGain = cpuDGain;
            return this;
        }

        public Builder setCpuOutputThreshold(double cpuOutputThreshold) {
            this.cpuOutputThreshold = cpuOutputThreshold;
            return this;
        }

        public ResourceBasedControllerOptions build() {
            Preconditions.checkState((this.targetMemoryUsage > 0.0 ? 1 : 0) != 0, (Object)"targetMemoryUsage must be set and greater than 0");
            Preconditions.checkState((this.targetCPUUsage > 0.0 ? 1 : 0) != 0, (Object)"targetCPUUsage must be set and greater than 0");
            return new ResourceBasedControllerOptions(this);
        }
    }
}

