/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.uber.m3.tally.Scope;
import io.nexusrpc.ServiceDefinition;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.RetryOptions;
import io.temporal.common.SearchAttributeUpdate;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.metadata.POJOWorkflowImplMetadata;
import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.internal.WorkflowThreadMarker;
import io.temporal.internal.common.ActivityOptionUtils;
import io.temporal.internal.common.NonIdempotentHandle;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.common.SearchAttributesUtil;
import io.temporal.internal.logging.ReplayAwareLogger;
import io.temporal.internal.statemachines.UnsupportedContinueAsNewRequest;
import io.temporal.internal.sync.ActivityInvocationHandler;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.ActivityStubImpl;
import io.temporal.internal.sync.AllOfPromise;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.ChildWorkflowInvocationHandler;
import io.temporal.internal.sync.ChildWorkflowStubImpl;
import io.temporal.internal.sync.CompletablePromiseImpl;
import io.temporal.internal.sync.ContinueAsNewWorkflowInvocationHandler;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.ExternalWorkflowInvocationHandler;
import io.temporal.internal.sync.ExternalWorkflowStubImpl;
import io.temporal.internal.sync.LocalActivityInvocationHandler;
import io.temporal.internal.sync.LocalActivityStubImpl;
import io.temporal.internal.sync.NexusServiceInvocationHandler;
import io.temporal.internal.sync.NexusServiceStubImpl;
import io.temporal.internal.sync.QueryDispatcher;
import io.temporal.internal.sync.ReadOnlyException;
import io.temporal.internal.sync.StartNexusCallInternal;
import io.temporal.internal.sync.StubMarker;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInfoImpl;
import io.temporal.internal.sync.WorkflowLockImpl;
import io.temporal.internal.sync.WorkflowQueueDeprecatedImpl;
import io.temporal.internal.sync.WorkflowQueueImpl;
import io.temporal.internal.sync.WorkflowRetryerInternal;
import io.temporal.internal.sync.WorkflowSemaphoreImpl;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.workflow.ActivityStub;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.ChildWorkflowStub;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.DynamicQueryHandler;
import io.temporal.workflow.DynamicSignalHandler;
import io.temporal.workflow.DynamicUpdateHandler;
import io.temporal.workflow.ExternalWorkflowStub;
import io.temporal.workflow.Functions;
import io.temporal.workflow.MutableSideEffectOptions;
import io.temporal.workflow.NexusOperationHandle;
import io.temporal.workflow.NexusServiceOptions;
import io.temporal.workflow.NexusServiceStub;
import io.temporal.workflow.Promise;
import io.temporal.workflow.SideEffectOptions;
import io.temporal.workflow.SignalMethod;
import io.temporal.workflow.TimerOptions;
import io.temporal.workflow.UpdateInfo;
import io.temporal.workflow.UpdateMethod;
import io.temporal.workflow.UpdateValidatorMethod;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import io.temporal.workflow.WorkflowLock;
import io.temporal.workflow.WorkflowQueue;
import io.temporal.workflow.WorkflowSemaphore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowInternal {
    public static final int DEFAULT_VERSION = -1;

    @Nonnull
    public static WorkflowThread newWorkflowMethodThread(Runnable runnable, String name) {
        Object workflowThread = DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext().getWorkflowInboundInterceptor().newWorkflowMethodThread(runnable, name);
        Preconditions.checkState((workflowThread != null ? 1 : 0) != 0, (Object)"[BUG] One of the custom interceptors illegally overrode newWorkflowMethodThread result to null. Check WorkflowInboundCallsInterceptor#newWorkflowMethodThread contract.");
        Preconditions.checkState((boolean)(workflowThread instanceof WorkflowThread), (String)"[BUG] One of the custom interceptors illegally overrode newWorkflowMethodThread result. Check WorkflowInboundCallsInterceptor#newWorkflowMethodThread contract. Illegal object returned from the interceptors chain: %s", (Object)workflowThread);
        return (WorkflowThread)workflowThread;
    }

    public static Promise<Void> newTimer(Duration duration) {
        WorkflowInternal.assertNotReadOnly("schedule timer");
        return WorkflowInternal.getWorkflowOutboundInterceptor().newTimer(duration);
    }

    public static Promise<Void> newTimer(Duration duration, TimerOptions options) {
        WorkflowInternal.assertNotReadOnly("schedule timer");
        return WorkflowInternal.getWorkflowOutboundInterceptor().newTimer(duration, options);
    }

    @Deprecated
    public static <E> WorkflowQueue<E> newQueue(int capacity) {
        return new WorkflowQueueDeprecatedImpl(capacity);
    }

    public static <E> WorkflowQueue<E> newWorkflowQueue(int capacity) {
        return new WorkflowQueueImpl(capacity);
    }

    public static WorkflowLock newWorkflowLock() {
        return new WorkflowLockImpl();
    }

    public static WorkflowSemaphore newWorkflowSemaphore(int permits) {
        return new WorkflowSemaphoreImpl(permits);
    }

    public static <E> CompletablePromise<E> newCompletablePromise() {
        return new CompletablePromiseImpl();
    }

    public static <E> Promise<E> newPromise(E value) {
        CompletablePromise result = Workflow.newPromise();
        result.complete(value);
        return result;
    }

    public static <E> Promise<E> newFailedPromise(Exception failure) {
        CompletablePromiseImpl result = new CompletablePromiseImpl();
        result.completeExceptionally(CheckedExceptionWrapper.wrap((Throwable)failure));
        return result;
    }

    public static void registerListener(Object implementation) {
        if (implementation instanceof DynamicSignalHandler) {
            WorkflowInternal.getWorkflowOutboundInterceptor().registerDynamicSignalHandler(new WorkflowOutboundCallsInterceptor.RegisterDynamicSignalHandlerInput((DynamicSignalHandler)implementation));
            return;
        }
        if (implementation instanceof DynamicQueryHandler) {
            WorkflowInternal.getWorkflowOutboundInterceptor().registerDynamicQueryHandler(new WorkflowOutboundCallsInterceptor.RegisterDynamicQueryHandlerInput((DynamicQueryHandler)implementation));
            return;
        }
        if (implementation instanceof DynamicUpdateHandler) {
            WorkflowInternal.getWorkflowOutboundInterceptor().registerDynamicUpdateHandler(new WorkflowOutboundCallsInterceptor.RegisterDynamicUpdateHandlerInput((DynamicUpdateHandler)implementation));
            return;
        }
        Class<?> cls = implementation.getClass();
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newListenerInstance(cls);
        for (POJOWorkflowMethodMetadata pOJOWorkflowMethodMetadata : workflowMetadata.getQueryMethods()) {
            Method method = pOJOWorkflowMethodMetadata.getWorkflowMethod();
            WorkflowInternal.getWorkflowOutboundInterceptor().registerQuery(new WorkflowOutboundCallsInterceptor.RegisterQueryInput(pOJOWorkflowMethodMetadata.getName(), pOJOWorkflowMethodMetadata.getDescription(), method.getParameterTypes(), method.getGenericParameterTypes(), args -> {
                try {
                    return method.invoke(implementation, args);
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
            }));
        }
        ArrayList<WorkflowOutboundCallsInterceptor.SignalRegistrationRequest> requests = new ArrayList<WorkflowOutboundCallsInterceptor.SignalRegistrationRequest>();
        for (POJOWorkflowMethodMetadata pOJOWorkflowMethodMetadata : workflowMetadata.getSignalMethods()) {
            Method method = pOJOWorkflowMethodMetadata.getWorkflowMethod();
            SignalMethod signalMethod = method.getAnnotation(SignalMethod.class);
            requests.add(new WorkflowOutboundCallsInterceptor.SignalRegistrationRequest(pOJOWorkflowMethodMetadata.getName(), pOJOWorkflowMethodMetadata.getDescription(), signalMethod.unfinishedPolicy(), method.getParameterTypes(), method.getGenericParameterTypes(), args -> {
                try {
                    method.invoke(implementation, args);
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
            }));
        }
        if (!requests.isEmpty()) {
            WorkflowInternal.getWorkflowOutboundInterceptor().registerSignalHandlers(new WorkflowOutboundCallsInterceptor.RegisterSignalHandlersInput(requests));
        }
        HashMap<String, POJOWorkflowMethodMetadata> hashMap = new HashMap<String, POJOWorkflowMethodMetadata>(workflowMetadata.getUpdateValidatorMethods().size());
        for (POJOWorkflowMethodMetadata methodMetadata : workflowMetadata.getUpdateValidatorMethods()) {
            Method method = methodMetadata.getWorkflowMethod();
            UpdateValidatorMethod updateValidatorMethod = method.getAnnotation(UpdateValidatorMethod.class);
            if (hashMap.containsKey(updateValidatorMethod.updateName())) {
                throw new IllegalArgumentException("Duplicate validator for update handle " + updateValidatorMethod.updateName());
            }
            hashMap.put(updateValidatorMethod.updateName(), methodMetadata);
        }
        ArrayList<WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest> arrayList = new ArrayList<WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest>();
        for (POJOWorkflowMethodMetadata methodMetadata : workflowMetadata.getUpdateMethods()) {
            Method validatorMethod;
            POJOWorkflowMethodMetadata validatorMethodMetadata;
            Method method = methodMetadata.getWorkflowMethod();
            UpdateMethod updateMethod = method.getAnnotation(UpdateMethod.class);
            String updateMethodName = updateMethod.name();
            if (updateMethodName.isEmpty()) {
                updateMethodName = method.getName();
            }
            if ((validatorMethodMetadata = (POJOWorkflowMethodMetadata)hashMap.remove(updateMethodName)) != null) {
                validatorMethod = validatorMethodMetadata.getWorkflowMethod();
                if (!Arrays.equals(validatorMethod.getParameterTypes(), method.getParameterTypes())) {
                    throw new IllegalArgumentException("Validator for: " + updateMethodName + " type parameters do not match the update handle");
                }
            } else {
                validatorMethod = null;
            }
            arrayList.add(new WorkflowOutboundCallsInterceptor.UpdateRegistrationRequest(methodMetadata.getName(), methodMetadata.getDescription(), updateMethod.unfinishedPolicy(), method.getParameterTypes(), method.getGenericParameterTypes(), args -> {
                try {
                    if (validatorMethod != null) {
                        validatorMethod.invoke(implementation, args);
                    }
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
            }, args -> {
                try {
                    return method.invoke(implementation, args);
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap((Throwable)e);
                }
            }));
        }
        if (!arrayList.isEmpty()) {
            WorkflowInternal.getWorkflowOutboundInterceptor().registerUpdateHandlers(new WorkflowOutboundCallsInterceptor.RegisterUpdateHandlersInput(arrayList));
        }
        if (!hashMap.isEmpty()) {
            throw new IllegalArgumentException("Missing update methods for update validator(s): " + Joiner.on((String)", ").join(hashMap.keySet()));
        }
    }

    public static long currentTimeMillis() {
        return WorkflowInternal.getWorkflowOutboundInterceptor().currentTimeMillis();
    }

    public static void setDefaultActivityOptions(ActivityOptions activityOptions) {
        WorkflowInternal.getRootWorkflowContext().setDefaultActivityOptions(activityOptions);
    }

    public static void applyActivityOptions(Map<String, ActivityOptions> activityTypeToOptions) {
        WorkflowInternal.getRootWorkflowContext().applyActivityOptions(activityTypeToOptions);
    }

    public static void setDefaultLocalActivityOptions(LocalActivityOptions localActivityOptions) {
        WorkflowInternal.getRootWorkflowContext().setDefaultLocalActivityOptions(localActivityOptions);
    }

    public static void applyLocalActivityOptions(Map<String, LocalActivityOptions> activityTypeToOptions) {
        WorkflowInternal.getRootWorkflowContext().applyLocalActivityOptions(activityTypeToOptions);
    }

    public static <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options, Map<String, ActivityOptions> activityMethodOptions) {
        HashMap<String, ActivityOptions> mergedActivityOptionsMap;
        SyncWorkflowContext context = WorkflowInternal.getRootWorkflowContext();
        options = options == null ? context.getDefaultActivityOptions() : options;
        Map<String, ActivityOptions> predefinedActivityOptions = context.getActivityOptions();
        if (activityMethodOptions != null && !activityMethodOptions.isEmpty() && predefinedActivityOptions.isEmpty()) {
            mergedActivityOptionsMap = new HashMap<String, ActivityOptions>(predefinedActivityOptions);
            ActivityOptionUtils.mergePredefinedActivityOptions(mergedActivityOptionsMap, activityMethodOptions);
        } else {
            mergedActivityOptionsMap = (HashMap<String, ActivityOptions>)MoreObjects.firstNonNull(activityMethodOptions, (Object)((Map)MoreObjects.firstNonNull(predefinedActivityOptions, Collections.emptyMap())));
        }
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(activityInterface, options, mergedActivityOptionsMap, context.getWorkflowOutboundInterceptor(), () -> WorkflowInternal.assertNotReadOnly("schedule activity"));
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options, @Nullable Map<String, LocalActivityOptions> activityMethodOptions) {
        HashMap<String, LocalActivityOptions> mergedLocalActivityOptionsMap;
        SyncWorkflowContext context = WorkflowInternal.getRootWorkflowContext();
        options = options == null ? context.getDefaultLocalActivityOptions() : options;
        Map<String, LocalActivityOptions> predefinedLocalActivityOptions = context.getLocalActivityOptions();
        if (activityMethodOptions != null && !activityMethodOptions.isEmpty() && predefinedLocalActivityOptions.isEmpty()) {
            mergedLocalActivityOptionsMap = new HashMap<String, LocalActivityOptions>(predefinedLocalActivityOptions);
            ActivityOptionUtils.mergePredefinedLocalActivityOptions(mergedLocalActivityOptionsMap, activityMethodOptions);
        } else {
            mergedLocalActivityOptionsMap = (HashMap<String, LocalActivityOptions>)MoreObjects.firstNonNull(activityMethodOptions, (Object)((Map)MoreObjects.firstNonNull(predefinedLocalActivityOptions, Collections.emptyMap())));
        }
        InvocationHandler invocationHandler = LocalActivityInvocationHandler.newInstance(activityInterface, options, mergedLocalActivityOptionsMap, WorkflowInternal.getWorkflowOutboundInterceptor(), () -> WorkflowInternal.assertNotReadOnly("schedule local activity"));
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static ActivityStub newUntypedActivityStub(ActivityOptions options) {
        return ActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowOutboundInterceptor(), () -> WorkflowInternal.assertNotReadOnly("schedule activity"));
    }

    public static ActivityStub newUntypedLocalActivityStub(LocalActivityOptions options) {
        return LocalActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowOutboundInterceptor(), () -> WorkflowInternal.assertNotReadOnly("schedule local activity"));
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface, ChildWorkflowOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ChildWorkflowInvocationHandler(workflowInterface, options, WorkflowInternal.getWorkflowOutboundInterceptor(), WorkflowInternal::assertNotReadOnly));
    }

    public static <T> T newExternalWorkflowStub(Class<T> workflowInterface, WorkflowExecution execution) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ExternalWorkflowInvocationHandler(workflowInterface, execution, WorkflowInternal.getWorkflowOutboundInterceptor(), WorkflowInternal::assertNotReadOnly));
    }

    public static Promise<WorkflowExecution> getWorkflowExecution(Object workflowStub) {
        if (workflowStub instanceof StubMarker) {
            Object untyped = ((StubMarker)workflowStub).__getUntypedStub();
            if (untyped instanceof ChildWorkflowStub) {
                return ((ChildWorkflowStub)untyped).getExecution();
            }
            if (untyped instanceof ExternalWorkflowStub) {
                return WorkflowInternal.newPromise(((ExternalWorkflowStub)untyped).getExecution());
            }
        }
        throw new IllegalArgumentException("Not a workflow stub created through Workflow.newChildWorkflowStub or Workflow.newExternalWorkflowStub: " + workflowStub);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType, ChildWorkflowOptions options) {
        return new ChildWorkflowStubImpl(workflowType, options, WorkflowInternal.getWorkflowOutboundInterceptor(), WorkflowInternal::assertNotReadOnly);
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(WorkflowExecution execution) {
        return new ExternalWorkflowStubImpl(execution, WorkflowInternal.getWorkflowOutboundInterceptor(), WorkflowInternal::assertNotReadOnly);
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface, ContinueAsNewOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface}, (InvocationHandler)new ContinueAsNewWorkflowInvocationHandler(workflowInterface, options, WorkflowInternal.getWorkflowOutboundInterceptor()));
    }

    public static <R> R executeActivity(String name, ActivityOptions options, Class<R> resultClass, Type resultType, Object ... args) {
        WorkflowInternal.assertNotReadOnly("schedule activity");
        Promise<R> result = WorkflowInternal.getWorkflowOutboundInterceptor().executeActivity(new WorkflowOutboundCallsInterceptor.ActivityInput<R>(name, resultClass, resultType, args, options, Header.empty())).getResult();
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return null;
        }
        return result.get();
    }

    public static void await(String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        WorkflowInternal.assertNotReadOnly(reason);
        WorkflowInternal.getWorkflowOutboundInterceptor().await(reason, () -> {
            WorkflowInternal.getRootWorkflowContext().setReadOnly(true);
            try {
                Boolean bl = (Boolean)unblockCondition.get();
                return bl;
            }
            finally {
                WorkflowInternal.getRootWorkflowContext().setReadOnly(false);
            }
        });
    }

    public static boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        WorkflowInternal.assertNotReadOnly(reason);
        return WorkflowInternal.getWorkflowOutboundInterceptor().await(timeout, reason, () -> {
            WorkflowInternal.getRootWorkflowContext().setReadOnly(true);
            try {
                Boolean bl = (Boolean)unblockCondition.get();
                return bl;
            }
            finally {
                WorkflowInternal.getRootWorkflowContext().setReadOnly(false);
            }
        });
    }

    public static <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        WorkflowInternal.assertNotReadOnly("side effect");
        return WorkflowInternal.getWorkflowOutboundInterceptor().sideEffect(resultClass, resultType, func);
    }

    public static <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func, SideEffectOptions options) {
        WorkflowInternal.assertNotReadOnly("side effect");
        return WorkflowInternal.getWorkflowOutboundInterceptor().sideEffect(resultClass, resultType, func, options);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        WorkflowInternal.assertNotReadOnly("mutable side effect");
        return WorkflowInternal.getWorkflowOutboundInterceptor().mutableSideEffect(id, resultClass, resultType, updated, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func, MutableSideEffectOptions options) {
        WorkflowInternal.assertNotReadOnly("mutable side effect");
        return WorkflowInternal.getWorkflowOutboundInterceptor().mutableSideEffect(id, resultClass, resultType, updated, func, options);
    }

    public static int getVersion(String changeId, int minSupported, int maxSupported) {
        WorkflowInternal.assertNotReadOnly("get version");
        return WorkflowInternal.getWorkflowOutboundInterceptor().getVersion(changeId, minSupported, maxSupported);
    }

    public static <V> Promise<Void> promiseAllOf(Iterable<Promise<V>> promises) {
        return new AllOfPromise(promises);
    }

    public static Promise<Void> promiseAllOf(Promise<?> ... promises) {
        return new AllOfPromise(promises);
    }

    public static <V> Promise<V> promiseAnyOf(Iterable<Promise<V>> promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static Promise<Object> promiseAnyOf(Promise<?> ... promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static CancellationScope newCancellationScope(boolean detached, Runnable runnable) {
        boolean deterministicCancellationScopeOrder = WorkflowInternal.getRootWorkflowContext().getReplayContext().checkSdkFlag(SdkFlag.DETERMINISTIC_CANCELLATION_SCOPE_ORDER);
        return new CancellationScopeImpl(detached, deterministicCancellationScopeOrder, runnable);
    }

    public static CancellationScope newCancellationScope(boolean detached, Functions.Proc1<CancellationScope> proc) {
        boolean deterministicCancellationScopeOrder = WorkflowInternal.getRootWorkflowContext().getReplayContext().checkSdkFlag(SdkFlag.DETERMINISTIC_CANCELLATION_SCOPE_ORDER);
        return new CancellationScopeImpl(detached, deterministicCancellationScopeOrder, proc);
    }

    public static CancellationScopeImpl currentCancellationScope() {
        return CancellationScopeImpl.current();
    }

    public static RuntimeException wrap(Throwable e) {
        return CheckedExceptionWrapper.wrap((Throwable)e);
    }

    public static Throwable unwrap(Throwable e) {
        return CheckedExceptionWrapper.unwrap((Throwable)e);
    }

    public static boolean isReplaying() {
        Optional<WorkflowThread> thread = DeterministicRunnerImpl.currentThreadInternalIfPresent();
        return thread.isPresent() && WorkflowInternal.getRootWorkflowContext().isReplaying();
    }

    public static <T> T getMemo(String key, Class<T> valueClass, Type genericType) {
        Payload memo = WorkflowInternal.getRootWorkflowContext().getReplayContext().getMemo(key);
        if (memo == null) {
            return null;
        }
        return WorkflowInternal.getDataConverterWithCurrentWorkflowContext().fromPayload(memo, valueClass, genericType);
    }

    public static <R> R retry(RetryOptions options, Optional<Duration> expiration, Functions.Func<R> fn) {
        WorkflowInternal.assertNotReadOnly("retry");
        return WorkflowRetryerInternal.retry(options.toBuilder().validateBuildWithDefaults(), expiration, fn);
    }

    public static void continueAsNew(@Nullable String workflowType, @Nullable ContinueAsNewOptions options, Object[] args) {
        WorkflowInternal.assertNotReadOnly("continue as new");
        WorkflowInternal.assertNotInUpdateHandler("ContinueAsNew is not supported in an update handler");
        WorkflowInternal.getWorkflowOutboundInterceptor().continueAsNew(new WorkflowOutboundCallsInterceptor.ContinueAsNewInput(workflowType, options, args, Header.empty()));
    }

    public static void continueAsNew(@Nullable String workflowType, @Nullable ContinueAsNewOptions options, Object[] args, WorkflowOutboundCallsInterceptor outboundCallsInterceptor) {
        WorkflowInternal.assertNotReadOnly("continue as new");
        WorkflowInternal.assertNotInUpdateHandler("ContinueAsNew is not supported in an update handler");
        outboundCallsInterceptor.continueAsNew(new WorkflowOutboundCallsInterceptor.ContinueAsNewInput(workflowType, options, args, Header.empty()));
    }

    public static Promise<Void> cancelWorkflow(WorkflowExecution execution) {
        return WorkflowInternal.cancelWorkflow(execution, null);
    }

    public static Promise<Void> cancelWorkflow(WorkflowExecution execution, @Nullable String reason) {
        WorkflowInternal.assertNotReadOnly("cancel workflow");
        return WorkflowInternal.getWorkflowOutboundInterceptor().cancelWorkflow(new WorkflowOutboundCallsInterceptor.CancelWorkflowInput(execution, reason)).getResult();
    }

    public static void sleep(Duration duration) {
        WorkflowInternal.assertNotReadOnly("sleep");
        WorkflowInternal.getWorkflowOutboundInterceptor().sleep(duration);
    }

    public static boolean isWorkflowThread() {
        return WorkflowThreadMarker.isWorkflowThread();
    }

    public static <T> T deadlockDetectorOff(Functions.Func<T> func) {
        if (WorkflowInternal.isWorkflowThread()) {
            try (NonIdempotentHandle ignored = WorkflowInternal.getWorkflowThread().lockDeadlockDetector();){
                T t = func.apply();
                return t;
            }
        }
        return func.apply();
    }

    public static WorkflowInfo getWorkflowInfo() {
        return new WorkflowInfoImpl(WorkflowInternal.getRootWorkflowContext().getReplayContext());
    }

    public static Optional<UpdateInfo> getCurrentUpdateInfo() {
        return WorkflowInternal.getRootWorkflowContext().getCurrentUpdateInfo();
    }

    public static Scope getMetricsScope() {
        return WorkflowInternal.getWorkflowOutboundInterceptor().getMetricsScope();
    }

    private static boolean isLoggingEnabledInReplay() {
        return WorkflowInternal.getRootWorkflowContext().isLoggingEnabledInReplay();
    }

    public static UUID randomUUID() {
        WorkflowInternal.assertNotReadOnly("random UUID");
        return WorkflowInternal.getRootWorkflowContext().randomUUID();
    }

    public static Random newRandom() {
        WorkflowInternal.assertNotReadOnly("random");
        return WorkflowInternal.getRootWorkflowContext().newRandom();
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static Logger getLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        return WorkflowInternal.getRootWorkflowContext().getLastCompletionResult(resultClass, resultType);
    }

    @Nullable
    public static <T> T getSearchAttribute(String name) {
        List<T> list = WorkflowInternal.getSearchAttributeValues(name);
        if (list == null) {
            return null;
        }
        Preconditions.checkState((list.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((list.size() == 1 ? 1 : 0) != 0, (String)"search attribute with name '%s' contains a list '%s' of values instead of a single value", (Object)name, list);
        return list.get(0);
    }

    @Nullable
    public static <T> List<T> getSearchAttributeValues(String name) {
        SearchAttributes searchAttributes = WorkflowInternal.getRootWorkflowContext().getReplayContext().getSearchAttributes();
        if (searchAttributes == null) {
            return null;
        }
        List decoded = SearchAttributesUtil.decode(searchAttributes, name);
        return decoded != null ? Collections.unmodifiableList(decoded) : null;
    }

    @Nonnull
    public static Map<String, List<?>> getSearchAttributes() {
        SearchAttributes searchAttributes = WorkflowInternal.getRootWorkflowContext().getReplayContext().getSearchAttributes();
        if (searchAttributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(SearchAttributesUtil.decode(searchAttributes));
    }

    @Nonnull
    public static io.temporal.common.SearchAttributes getTypedSearchAttributes() {
        SearchAttributes searchAttributes = WorkflowInternal.getRootWorkflowContext().getReplayContext().getSearchAttributes();
        return SearchAttributesUtil.decodeTyped(searchAttributes);
    }

    public static void upsertSearchAttributes(Map<String, ?> searchAttributes) {
        WorkflowInternal.assertNotReadOnly("upsert search attribute");
        WorkflowInternal.getWorkflowOutboundInterceptor().upsertSearchAttributes(searchAttributes);
    }

    public static void upsertTypedSearchAttributes(SearchAttributeUpdate<?> ... searchAttributeUpdates) {
        WorkflowInternal.assertNotReadOnly("upsert search attribute");
        WorkflowInternal.getWorkflowOutboundInterceptor().upsertTypedSearchAttributes(searchAttributeUpdates);
    }

    public static void upsertMemo(Map<String, Object> memo) {
        WorkflowInternal.assertNotReadOnly("upsert memo");
        WorkflowInternal.getWorkflowOutboundInterceptor().upsertMemo(memo);
    }

    public static DataConverter getDataConverter() {
        return WorkflowInternal.getRootWorkflowContext().getDataConverter();
    }

    static DataConverter getDataConverterWithCurrentWorkflowContext() {
        return WorkflowInternal.getRootWorkflowContext().getDataConverterWithCurrentWorkflowContext();
    }

    public static String getWorkflowType(Class<?> workflowInterfaceClass) {
        POJOWorkflowInterfaceMetadata metadata = POJOWorkflowInterfaceMetadata.newInstance(workflowInterfaceClass);
        return metadata.getWorkflowType().get();
    }

    public static Optional<Exception> getPreviousRunFailure() {
        return Optional.ofNullable(WorkflowInternal.getRootWorkflowContext().getReplayContext().getPreviousRunFailure()).map(f -> WorkflowInternal.getDataConverterWithCurrentWorkflowContext().failureToException((Failure)f));
    }

    public static boolean isEveryHandlerFinished() {
        return WorkflowInternal.getRootWorkflowContext().isEveryHandlerFinished();
    }

    public static <T> T newNexusServiceStub(Class<T> serviceInterface, NexusServiceOptions options) {
        SyncWorkflowContext context = WorkflowInternal.getRootWorkflowContext();
        NexusServiceOptions baseOptions = options == null ? context.getDefaultNexusServiceOptions() : options;
        Map<String, NexusServiceOptions> predefinedNexusServiceOptions = context.getNexusServiceOptions();
        ServiceDefinition serviceDef = ServiceDefinition.fromClass(serviceInterface);
        NexusServiceOptions mergedOptions = NexusServiceOptions.newBuilder(predefinedNexusServiceOptions.get(serviceDef.getName())).mergeNexusServiceOptions(baseOptions).build();
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface, StubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new NexusServiceInvocationHandler(serviceDef, mergedOptions, WorkflowInternal.getWorkflowOutboundInterceptor(), WorkflowInternal::assertNotReadOnly));
    }

    public static NexusServiceStub newUntypedNexusServiceStub(String service, NexusServiceOptions options) {
        return new NexusServiceStubImpl(service, options, WorkflowInternal.getWorkflowOutboundInterceptor(), WorkflowInternal::assertNotReadOnly);
    }

    public static <T, R> NexusOperationHandle<R> startNexusOperation(Functions.Func1<T, R> operation, T arg) {
        return StartNexusCallInternal.startNexusOperation(() -> operation.apply(arg));
    }

    public static <R> NexusOperationHandle<R> startNexusOperation(Functions.Func<R> operation) {
        return StartNexusCallInternal.startNexusOperation(() -> operation.apply());
    }

    public static void setCurrentDetails(String details) {
        WorkflowInternal.getRootWorkflowContext().setCurrentDetails(details);
    }

    @Nullable
    public static String getCurrentDetails() {
        return WorkflowInternal.getRootWorkflowContext().getCurrentDetails();
    }

    @Nullable
    public static Object getInstance() {
        return WorkflowInternal.getRootWorkflowContext().getInstance();
    }

    static WorkflowOutboundCallsInterceptor getWorkflowOutboundInterceptor() {
        return WorkflowInternal.getRootWorkflowContext().getWorkflowOutboundInterceptor();
    }

    static SyncWorkflowContext getRootWorkflowContext() {
        if (QueryDispatcher.isQueryHandler()) {
            return QueryDispatcher.getWorkflowContext();
        }
        return DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext();
    }

    static boolean isReadOnly() {
        return WorkflowInternal.getRootWorkflowContext().isReadOnly();
    }

    static void assertNotReadOnly(String action) {
        if (WorkflowInternal.isReadOnly()) {
            throw new ReadOnlyException(action);
        }
    }

    static void assertNotInUpdateHandler(String message) {
        if (WorkflowInternal.getCurrentUpdateInfo().isPresent()) {
            throw new UnsupportedContinueAsNewRequest(message);
        }
    }

    private static WorkflowThread getWorkflowThread() {
        return DeterministicRunnerImpl.currentThreadInternal();
    }

    private WorkflowInternal() {
    }
}

