/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.nexus;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.base.Strings;
import io.temporal.internal.nexus.OperationTokenType;
import io.temporal.internal.nexus.WorkflowRunOperationToken;
import java.util.Base64;

public class OperationTokenUtil {
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
    private static final ObjectWriter ow = mapper.writer();
    private static final Base64.Decoder decoder = Base64.getUrlDecoder();
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();

    public static WorkflowRunOperationToken loadWorkflowRunOperationToken(String operationToken) {
        WorkflowRunOperationToken token;
        try {
            JavaType reference = mapper.getTypeFactory().constructType(WorkflowRunOperationToken.class);
            token = (WorkflowRunOperationToken)mapper.readValue(decoder.decode(operationToken), reference);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse operation token: " + e.getMessage());
        }
        if (!token.getType().equals((Object)OperationTokenType.WORKFLOW_RUN)) {
            throw new IllegalArgumentException("Invalid workflow run token: incorrect operation token type: " + (Object)((Object)token.getType()));
        }
        if (token.getVersion() != null && token.getVersion() != 0) {
            throw new IllegalArgumentException("Invalid workflow run token: unexpected version field");
        }
        if (Strings.isNullOrEmpty((String)token.getWorkflowId())) {
            throw new IllegalArgumentException("Invalid workflow run token: missing workflow ID (wid)");
        }
        return token;
    }

    public static String loadWorkflowIdFromOperationToken(String operationToken) {
        return OperationTokenUtil.loadWorkflowRunOperationToken(operationToken).getWorkflowId();
    }

    public static String generateWorkflowRunOperationToken(String workflowId, String namespace) throws JsonProcessingException {
        String json = ow.writeValueAsString((Object)new WorkflowRunOperationToken(namespace, workflowId));
        return encoder.encodeToString(json.getBytes());
    }

    private OperationTokenUtil() {
    }
}

