/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.uber.m3.tally.Scope;
import io.temporal.internal.sync.WorkflowThreadExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

class ActiveThreadReportingExecutor
implements WorkflowThreadExecutor {
    private final ExecutorService workflowThreadPool;
    private final Scope metricsScope;
    private final AtomicInteger tasksInFlight = new AtomicInteger();

    ActiveThreadReportingExecutor(ExecutorService workflowThreadPool, Scope metricsScope) {
        this.workflowThreadPool = workflowThreadPool;
        this.metricsScope = metricsScope;
    }

    @Override
    public Future<?> submit(@Nonnull Runnable task) {
        return this.workflowThreadPool.submit(() -> {
            int tasksCount = this.tasksInFlight.incrementAndGet();
            this.metricsScope.gauge("temporal_workflow_active_thread_count").update((double)tasksCount);
            try {
                task.run();
            }
            finally {
                tasksCount = this.tasksInFlight.decrementAndGet();
                this.metricsScope.gauge("temporal_workflow_active_thread_count").update((double)tasksCount);
            }
        });
    }
}

