/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.nexus;

import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.Link;
import io.temporal.client.WorkflowClient;
import io.temporal.common.interceptors.NexusOperationOutboundCallsInterceptor;
import io.temporal.nexus.NexusOperationContext;
import io.temporal.nexus.NexusOperationInfo;

public class InternalNexusOperationContext {
    private final String namespace;
    private final String taskQueue;
    private final Scope metricScope;
    private final WorkflowClient client;
    NexusOperationOutboundCallsInterceptor outboundCalls;
    Link startWorkflowResponseLink;

    public InternalNexusOperationContext(String namespace, String taskQueue, Scope metricScope, WorkflowClient client) {
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.metricScope = metricScope;
        this.client = client;
    }

    public Scope getMetricsScope() {
        return this.metricScope;
    }

    public WorkflowClient getWorkflowClient() {
        return this.client;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setOutboundInterceptor(NexusOperationOutboundCallsInterceptor outboundCalls) {
        this.outboundCalls = outboundCalls;
    }

    public NexusOperationContext getUserFacingContext() {
        if (this.outboundCalls == null) {
            throw new IllegalStateException("Outbound interceptor is not set");
        }
        return new NexusOperationContextImpl();
    }

    public void setStartWorkflowResponseLink(Link link) {
        this.startWorkflowResponseLink = link;
    }

    public Link getStartWorkflowResponseLink() {
        return this.startWorkflowResponseLink;
    }

    private class NexusOperationContextImpl
    implements NexusOperationContext {
        private NexusOperationContextImpl() {
        }

        @Override
        public NexusOperationInfo getInfo() {
            return InternalNexusOperationContext.this.outboundCalls.getInfo();
        }

        @Override
        public Scope getMetricsScope() {
            return InternalNexusOperationContext.this.outboundCalls.getMetricsScope();
        }

        @Override
        public WorkflowClient getWorkflowClient() {
            return InternalNexusOperationContext.this.outboundCalls.getWorkflowClient();
        }
    }
}

