/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public abstract class EagerPaginator<Resp, T>
implements Iterator<T> {
    private List<T> activeResponse;
    private int nextActiveResponseIndex;
    private CompletableFuture<Resp> nextResponse;

    @Override
    public boolean hasNext() {
        if (this.nextActiveResponseIndex < this.activeResponse.size()) {
            return true;
        }
        this.fetch();
        return this.nextActiveResponseIndex < this.activeResponse.size();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.activeResponse.get(this.nextActiveResponseIndex++);
        }
        throw new NoSuchElementException();
    }

    void fetch() {
        if (this.nextResponse == null) {
            return;
        }
        Resp response = this.waitAndGetNextResponse();
        ByteString nextPageToken = this.getNextPageToken(response);
        this.nextResponse = nextPageToken != null && !nextPageToken.isEmpty() ? this.performRequest(nextPageToken) : null;
        List<T> responseElements = this.toElements(response);
        if (responseElements.size() == 0 && this.nextResponse != null) {
            LoggerFactory.getLogger(this.getClass()).warn("[BUG] iterator received an empty collection with a non-empty nextPageToken");
            this.fetch();
            return;
        }
        this.activeResponse = responseElements;
        this.nextActiveResponseIndex = 0;
    }

    public void init() {
        this.nextResponse = this.performRequest(ByteString.EMPTY);
        this.waitAndGetNextResponse();
        this.fetch();
    }

    private Resp waitAndGetNextResponse() {
        Resp response;
        try {
            response = this.nextResponse.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
        return response;
    }

    protected abstract CompletableFuture<Resp> performRequest(@Nonnull ByteString var1);

    protected abstract ByteString getNextPageToken(Resp var1);

    protected abstract List<T> toElements(Resp var1);
}

