/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.activity;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityInfo;
import io.temporal.activity.DynamicActivity;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.client.ActivityCanceledException;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.ActivityInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.internal.activity.ActivityExecutionContextFactory;
import io.temporal.internal.activity.ActivityInfoInternal;
import io.temporal.internal.activity.ActivityTaskHandlerImpl;
import io.temporal.internal.activity.InternalActivityExecutionContext;
import io.temporal.internal.activity.RootActivityInboundCallsInterceptor;
import io.temporal.internal.common.FailureUtils;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.payload.context.ActivitySerializationContext;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActivityTaskExecutors {
    static final Logger log = LoggerFactory.getLogger(ActivityTaskExecutor.class);

    ActivityTaskExecutors() {
    }

    static class DynamicActivityImplementation
    extends BaseActivityTaskExecutor {
        private final DynamicActivity activity;

        DynamicActivityImplementation(DynamicActivity activity, DataConverter dataConverter, List<ContextPropagator> contextPropagators, WorkerInterceptor[] interceptors, ActivityExecutionContextFactory executionContextFactory) {
            super(dataConverter, contextPropagators, interceptors, executionContextFactory);
            this.activity = activity;
        }

        @Override
        ActivityInboundCallsInterceptor createRootInboundInterceptor() {
            return new RootActivityInboundCallsInterceptor.DynamicActivityInboundCallsInterceptor(this.activity);
        }

        @Override
        Object getActivity() {
            return this.activity;
        }

        @Override
        Object[] provideArgs(Optional<Payloads> input, DataConverter dataConverterWithActivityContext) {
            EncodedValues encodedValues = new EncodedValues(input, dataConverterWithActivityContext);
            return new Object[]{encodedValues};
        }

        @Override
        protected ActivityTaskHandler.Result constructSuccessfulResultValue(ActivityInfoInternal info, ActivityInboundCallsInterceptor.ActivityOutput result, DataConverter dataConverterWithActivityContext) {
            return this.constructResultValue(info, result, dataConverterWithActivityContext);
        }
    }

    static class POJOActivityImplementation
    extends BaseActivityTaskExecutor {
        private final Method method;
        private final Object activity;

        POJOActivityImplementation(Method interfaceMethod, Object activity, DataConverter dataConverter, List<ContextPropagator> contextPropagators, WorkerInterceptor[] interceptors, ActivityExecutionContextFactory executionContextFactory) {
            super(dataConverter, contextPropagators, interceptors, executionContextFactory);
            this.method = interfaceMethod;
            this.activity = activity;
        }

        @Override
        ActivityInboundCallsInterceptor createRootInboundInterceptor() {
            return new RootActivityInboundCallsInterceptor.POJOActivityInboundCallsInterceptor(this.activity, this.method);
        }

        @Override
        Object getActivity() {
            return this.activity;
        }

        @Override
        Object[] provideArgs(Optional<Payloads> input, DataConverter dataConverterWithActivityContext) {
            return dataConverterWithActivityContext.fromPayloads(input, this.method.getParameterTypes(), this.method.getGenericParameterTypes());
        }

        @Override
        protected ActivityTaskHandler.Result constructSuccessfulResultValue(ActivityInfoInternal info, ActivityInboundCallsInterceptor.ActivityOutput result, DataConverter dataConverterWithActivityContext) {
            return this.constructResultValue(info, this.method.getReturnType() != Void.TYPE ? result : null, dataConverterWithActivityContext);
        }
    }

    static abstract class BaseActivityTaskExecutor
    implements ActivityTaskExecutor {
        private final DataConverter dataConverter;
        private final List<ContextPropagator> contextPropagators;
        private final WorkerInterceptor[] interceptors;
        private final ActivityExecutionContextFactory executionContextFactory;

        public BaseActivityTaskExecutor(DataConverter dataConverter, List<ContextPropagator> contextPropagators, WorkerInterceptor[] interceptors, ActivityExecutionContextFactory executionContextFactory) {
            this.dataConverter = dataConverter;
            this.contextPropagators = contextPropagators;
            this.interceptors = interceptors;
            this.executionContextFactory = executionContextFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityTaskHandler.Result execute(ActivityInfoInternal info, Scope metricsScope) {
            InternalActivityExecutionContext context = this.executionContextFactory.createContext(info, this.getActivity(), metricsScope);
            ActivityInfo activityInfo = context.getInfo();
            ActivitySerializationContext serializationContext = new ActivitySerializationContext(activityInfo.getNamespace(), activityInfo.getWorkflowId(), activityInfo.getWorkflowType(), activityInfo.getActivityType(), activityInfo.getActivityTaskQueue(), activityInfo.isLocal());
            DataConverter dataConverterWithActivityContext = this.dataConverter.withContext(serializationContext);
            try {
                ActivityTaskHandler.Result result;
                info.getHeader().ifPresent(value -> BaseActivityTaskExecutor.deserializeAndPopulateContext(value, this.contextPropagators));
                ActivityInboundCallsInterceptor inboundCallsInterceptor = this.createRootInboundInterceptor();
                for (WorkerInterceptor interceptor : this.interceptors) {
                    inboundCallsInterceptor = interceptor.interceptActivity(inboundCallsInterceptor);
                }
                inboundCallsInterceptor.init(context);
                Object[] args = this.provideArgs(info.getInput(), dataConverterWithActivityContext);
                io.temporal.common.interceptors.Header header = new io.temporal.common.interceptors.Header(info.getHeader().orElse(Header.getDefaultInstance()));
                ActivityInboundCallsInterceptor.ActivityOutput result2 = inboundCallsInterceptor.execute(new ActivityInboundCallsInterceptor.ActivityInput(header, args));
                if (context.isDoNotCompleteOnReturn()) {
                    result = new ActivityTaskHandler.Result(info.getActivityId(), null, null, null, context.isUseLocalManualCompletion());
                    return result;
                }
                result = this.constructSuccessfulResultValue(info, result2, dataConverterWithActivityContext);
                return result;
            }
            catch (Throwable e) {
                Throwable ex = CheckedExceptionWrapper.unwrap((Throwable)e);
                boolean local = info.isLocal();
                if (ex instanceof ActivityCanceledException) {
                    log.info("{} canceled. ActivityId={}, activityType={}, attempt={}", new Object[]{local ? "Local activity" : "Activity", info.getActivityId(), info.getActivityType(), info.getAttempt()});
                } else if (FailureUtils.isBenignApplicationFailure(ex)) {
                    log.debug("{} failure. ActivityId={}, activityType={}, attempt={}", new Object[]{local ? "Local activity" : "Activity", info.getActivityId(), info.getActivityType(), info.getAttempt(), ex});
                } else {
                    log.warn("{} failure. ActivityId={}, activityType={}, attempt={}", new Object[]{local ? "Local activity" : "Activity", info.getActivityId(), info.getActivityType(), info.getAttempt(), ex});
                }
                ActivityTaskHandler.Result result = ActivityTaskHandlerImpl.mapToActivityFailure(ex, info.getActivityId(), context.getLastHeartbeatValue(), metricsScope, local, dataConverterWithActivityContext);
                return result;
            }
            finally {
                if (!context.isDoNotCompleteOnReturn()) {
                    context.cancelOutstandingHeartbeat();
                }
            }
        }

        abstract ActivityInboundCallsInterceptor createRootInboundInterceptor();

        abstract Object getActivity();

        abstract Object[] provideArgs(Optional<Payloads> var1, DataConverter var2);

        protected abstract ActivityTaskHandler.Result constructSuccessfulResultValue(ActivityInfoInternal var1, ActivityInboundCallsInterceptor.ActivityOutput var2, DataConverter var3);

        ActivityTaskHandler.Result constructResultValue(ActivityInfoInternal info, @Nullable ActivityInboundCallsInterceptor.ActivityOutput result, DataConverter dataConverterWithActivityContext) {
            RespondActivityTaskCompletedRequest.Builder request = RespondActivityTaskCompletedRequest.newBuilder();
            if (result != null) {
                Optional<Payloads> serialized = dataConverterWithActivityContext.toPayloads(result.getResult());
                serialized.ifPresent(arg_0 -> ((RespondActivityTaskCompletedRequest.Builder)request).setResult(arg_0));
            }
            return new ActivityTaskHandler.Result(info.getActivityId(), request.build(), null, null, false);
        }

        static void deserializeAndPopulateContext(@Nonnull Header header, @Nullable List<ContextPropagator> contextPropagatorList) {
            if (contextPropagatorList == null || contextPropagatorList.isEmpty()) {
                return;
            }
            HashMap<String, Payload> headerData = new HashMap<String, Payload>(header.getFieldsMap());
            for (ContextPropagator propagator : contextPropagatorList) {
                propagator.setCurrentContext(propagator.deserializeContext(headerData));
            }
        }
    }

    static interface ActivityTaskExecutor {
        public ActivityTaskHandler.Result execute(ActivityInfoInternal var1, Scope var2);
    }
}

