/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.client.schedules.ScheduleCalendarSpec;
import io.temporal.client.schedules.ScheduleIntervalSpec;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public final class ScheduleSpec {
    private final List<ScheduleCalendarSpec> calendars;
    private final List<ScheduleIntervalSpec> intervals;
    private final List<String> cronExpressions;
    private final List<ScheduleCalendarSpec> skip;
    private final Instant startAt;
    private final Instant endAt;
    private final Duration jitter;
    private final String timeZoneName;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ScheduleSpec options) {
        return new Builder(options);
    }

    private ScheduleSpec(List<ScheduleCalendarSpec> calendars, List<ScheduleIntervalSpec> intervals, List<String> cronExpressions, List<ScheduleCalendarSpec> skip, Instant startAt, Instant endAt, Duration jitter, String timeZoneName) {
        this.calendars = calendars;
        this.intervals = intervals;
        this.cronExpressions = cronExpressions;
        this.skip = skip;
        this.startAt = startAt;
        this.endAt = endAt;
        this.jitter = jitter;
        this.timeZoneName = timeZoneName;
    }

    public List<ScheduleCalendarSpec> getCalendars() {
        return this.calendars;
    }

    public List<ScheduleIntervalSpec> getIntervals() {
        return this.intervals;
    }

    public List<String> getCronExpressions() {
        return this.cronExpressions;
    }

    public List<ScheduleCalendarSpec> getSkip() {
        return this.skip;
    }

    public Instant getStartAt() {
        return this.startAt;
    }

    public Instant getEndAt() {
        return this.endAt;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleSpec that = (ScheduleSpec)o;
        return Objects.equals(this.calendars, that.calendars) && Objects.equals(this.intervals, that.intervals) && Objects.equals(this.cronExpressions, that.cronExpressions) && Objects.equals(this.skip, that.skip) && Objects.equals(this.startAt, that.startAt) && Objects.equals(this.endAt, that.endAt) && Objects.equals(this.jitter, that.jitter) && Objects.equals(this.timeZoneName, that.timeZoneName);
    }

    public int hashCode() {
        return Objects.hash(this.calendars, this.intervals, this.cronExpressions, this.skip, this.startAt, this.endAt, this.jitter, this.timeZoneName);
    }

    public String toString() {
        return "ScheduleSpec{calendars=" + this.calendars + ", intervals=" + this.intervals + ", cronExpressions=" + this.cronExpressions + ", skip=" + this.skip + ", startAt=" + this.startAt + ", endAt=" + this.endAt + ", jitter=" + this.jitter + ", timeZoneName='" + this.timeZoneName + '\'' + '}';
    }

    public static final class Builder {
        private List<ScheduleCalendarSpec> calendars;
        private List<ScheduleIntervalSpec> intervals;
        private List<String> cronExpressions;
        private List<ScheduleCalendarSpec> skip;
        private Instant startAt;
        private Instant endAt;
        private Duration jitter;
        private String timeZoneName;

        private Builder() {
        }

        private Builder(ScheduleSpec options) {
            if (options == null) {
                return;
            }
            this.calendars = options.calendars;
            this.intervals = options.intervals;
            this.cronExpressions = options.cronExpressions;
            this.skip = options.skip;
            this.startAt = options.startAt;
            this.endAt = options.endAt;
            this.jitter = options.jitter;
            this.timeZoneName = options.timeZoneName;
        }

        public Builder setCalendars(List<ScheduleCalendarSpec> calendars) {
            this.calendars = calendars;
            return this;
        }

        public Builder setIntervals(List<ScheduleIntervalSpec> intervals) {
            this.intervals = intervals;
            return this;
        }

        public Builder setCronExpressions(List<String> cronExpressions) {
            this.cronExpressions = cronExpressions;
            return this;
        }

        public Builder setSkip(List<ScheduleCalendarSpec> skip) {
            this.skip = skip;
            return this;
        }

        public Builder setStartAt(Instant startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder setEndAt(Instant endAt) {
            this.endAt = endAt;
            return this;
        }

        public Builder setJitter(Duration jitter) {
            this.jitter = jitter;
            return this;
        }

        public Builder setTimeZoneName(String timeZoneName) {
            this.timeZoneName = timeZoneName;
            return this;
        }

        public ScheduleSpec build() {
            return new ScheduleSpec(this.calendars, this.intervals, this.cronExpressions, this.skip, this.startAt, this.endAt, this.jitter, this.timeZoneName);
        }
    }
}

