/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.QueryResultType;
import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.ShutdownWorkerRequest;
import io.temporal.api.workflowservice.v1.ShutdownWorkerResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.failure.ApplicationFailure;
import io.temporal.internal.retryer.GrpcMessageTooLargeException;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.internal.worker.AsyncPoller;
import io.temporal.internal.worker.AsyncWorkflowPollTask;
import io.temporal.internal.worker.DisableNormalPolling;
import io.temporal.internal.worker.EagerActivityDispatcher;
import io.temporal.internal.worker.EagerActivitySlotsReservation;
import io.temporal.internal.worker.MultiThreadedPoller;
import io.temporal.internal.worker.NoopWorker;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.StickyQueueBalancer;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.UnableToAcquireLockException;
import io.temporal.internal.worker.WorkerLifecycleState;
import io.temporal.internal.worker.WorkerThreadsNameHelper;
import io.temporal.internal.worker.WorkerVersioningProtoUtils;
import io.temporal.internal.worker.WorkflowExecutorCache;
import io.temporal.internal.worker.WorkflowPollTask;
import io.temporal.internal.worker.WorkflowRunLockManager;
import io.temporal.internal.worker.WorkflowTask;
import io.temporal.internal.worker.WorkflowTaskHandler;
import io.temporal.payload.context.WorkflowSerializationContext;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.RpcRetryOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.NonDeterministicException;
import io.temporal.worker.WorkerMetricsTag;
import io.temporal.worker.WorkflowTaskDispatchHandle;
import io.temporal.worker.tuning.PollerBehaviorAutoscaling;
import io.temporal.worker.tuning.PollerBehaviorSimpleMaximum;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class WorkflowWorker
implements SuspendableWorker {
    private static final String GRACEFUL_SHUTDOWN_MESSAGE = "graceful shutdown";
    private static final Logger log = LoggerFactory.getLogger(WorkflowWorker.class);
    private final WorkflowRunLockManager runLocks;
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final WorkflowExecutorCache cache;
    private final WorkflowTaskHandler handler;
    private final String stickyTaskQueueName;
    private final PollerOptions pollerOptions;
    private final Scope workerMetricsScope;
    private final GrpcRetryer grpcRetryer;
    private final EagerActivityDispatcher eagerActivityDispatcher;
    private final TrackingSlotSupplier<WorkflowSlotInfo> slotSupplier;
    private PollTaskExecutor<WorkflowTask> pollTaskExecutor;
    @Nonnull
    private SuspendableWorker poller = new NoopWorker();
    private DisableNormalPolling stickyQueueBalancer;

    public WorkflowWorker(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nullable String stickyTaskQueueName, @Nonnull SingleWorkerOptions options, @Nonnull WorkflowRunLockManager runLocks, @Nonnull WorkflowExecutorCache cache, @Nonnull WorkflowTaskHandler handler, @Nonnull EagerActivityDispatcher eagerActivityDispatcher, @Nonnull SlotSupplier<WorkflowSlotInfo> slotSupplier) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.options = Objects.requireNonNull(options);
        this.stickyTaskQueueName = stickyTaskQueueName;
        this.pollerOptions = this.getPollerOptions(options);
        this.workerMetricsScope = MetricsTag.tagged((Scope)options.getMetricsScope(), (MetricsTag.TagValue)WorkerMetricsTag.WorkerType.WORKFLOW_WORKER);
        this.runLocks = Objects.requireNonNull(runLocks);
        this.cache = Objects.requireNonNull(cache);
        this.handler = Objects.requireNonNull(handler);
        this.grpcRetryer = new GrpcRetryer(service.getServerCapabilities());
        this.eagerActivityDispatcher = eagerActivityDispatcher;
        this.slotSupplier = new TrackingSlotSupplier<WorkflowSlotInfo>(slotSupplier, this.workerMetricsScope);
    }

    @Override
    public boolean start() {
        if (this.handler.isAnyTypeSupported()) {
            this.pollTaskExecutor = new PollTaskExecutor<WorkflowTask>(this.namespace, this.taskQueue, this.options.getIdentity(), new TaskHandlerImpl(this.handler), this.pollerOptions, this.slotSupplier.maximumSlots().orElse(Integer.MAX_VALUE), this.options.isUsingVirtualThreads());
            boolean useAsyncPoller = this.pollerOptions.getPollerBehavior() instanceof PollerBehaviorAutoscaling;
            if (useAsyncPoller) {
                List pollers;
                if (this.stickyTaskQueueName != null) {
                    AsyncWorkflowPollTask normalPoller = new AsyncWorkflowPollTask(this.service, this.namespace, this.taskQueue, null, this.options.getIdentity(), this.options.getWorkerVersioningOptions(), this.slotSupplier, this.workerMetricsScope, this.service.getServerCapabilities());
                    pollers = Arrays.asList(new AsyncWorkflowPollTask(this.service, this.namespace, this.taskQueue, this.stickyTaskQueueName, this.options.getIdentity(), this.options.getWorkerVersioningOptions(), this.slotSupplier, this.workerMetricsScope, this.service.getServerCapabilities()), normalPoller);
                    this.stickyQueueBalancer = normalPoller;
                } else {
                    pollers = Collections.singletonList(new AsyncWorkflowPollTask(this.service, this.namespace, this.taskQueue, null, this.options.getIdentity(), this.options.getWorkerVersioningOptions(), this.slotSupplier, this.workerMetricsScope, this.service.getServerCapabilities()));
                }
                this.poller = new AsyncPoller<WorkflowTask>(this.slotSupplier, new SlotReservationData(this.taskQueue, this.options.getIdentity(), this.options.getBuildId()), pollers, this.pollTaskExecutor, this.pollerOptions, this.workerMetricsScope);
            } else {
                PollerBehaviorSimpleMaximum pollerBehavior = (PollerBehaviorSimpleMaximum)this.pollerOptions.getPollerBehavior();
                StickyQueueBalancer stickyQueueBalancer = new StickyQueueBalancer(pollerBehavior.getMaxConcurrentTaskPollers(), this.stickyTaskQueueName != null);
                this.stickyQueueBalancer = stickyQueueBalancer;
                this.poller = new MultiThreadedPoller<WorkflowTask>(this.options.getIdentity(), new WorkflowPollTask(this.service, this.namespace, this.taskQueue, this.stickyTaskQueueName, this.options.getIdentity(), this.options.getWorkerVersioningOptions(), this.slotSupplier, stickyQueueBalancer, this.workerMetricsScope, this.service.getServerCapabilities()), this.pollTaskExecutor, this.pollerOptions, this.workerMetricsScope);
            }
            this.poller.start();
            this.workerMetricsScope.counter("temporal_worker_start").inc(1L);
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        String supplierName = this + "#executorSlots";
        boolean stickyQueueBalancerDrainEnabled = !interruptTasks && !this.options.getDrainStickyTaskQueueTimeout().isZero() && this.stickyTaskQueueName != null && this.stickyQueueBalancer != null;
        CompletionStage pollerShutdown = ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(ignore -> stickyQueueBalancerDrainEnabled ? shutdownManager.waitForStickyQueueBalancer(this.stickyQueueBalancer, this.options.getDrainStickyTaskQueueTimeout()) : CompletableFuture.completedFuture(null))).thenCompose(ignore -> this.poller.shutdown(shutdownManager, interruptTasks));
        return CompletableFuture.allOf(new CompletableFuture[]{((CompletableFuture)pollerShutdown).thenCompose(ignore -> {
            if (!interruptTasks && this.stickyTaskQueueName != null) {
                return shutdownManager.waitOnWorkerShutdownRequest((ListenableFuture<ShutdownWorkerResponse>)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.service.futureStub()).shutdownWorker(ShutdownWorkerRequest.newBuilder().setIdentity(this.options.getIdentity()).setNamespace(this.namespace).setStickyTaskQueue(this.stickyTaskQueueName).setReason(GRACEFUL_SHUTDOWN_MESSAGE).build()));
            }
            return CompletableFuture.completedFuture(null);
        }), ((CompletableFuture)((CompletableFuture)((CompletableFuture)pollerShutdown).thenCompose(ignore -> !interruptTasks ? shutdownManager.waitForSupplierPermitsReleasedUnlimited(this.slotSupplier, supplierName) : CompletableFuture.completedFuture(null))).thenCompose(ignore -> this.pollTaskExecutor != null ? this.pollTaskExecutor.shutdown(shutdownManager, interruptTasks) : CompletableFuture.completedFuture(null))).exceptionally(e -> {
            log.error("Unexpected exception during shutdown", e);
            return null;
        })});
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = ShutdownManager.awaitTermination(this.poller, unit.toMillis(timeout));
        ShutdownManager.awaitTermination(this.pollTaskExecutor, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated() && (this.pollTaskExecutor == null || this.pollTaskExecutor.isTerminated());
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        return this.poller.getLifecycleState();
    }

    private PollerOptions getPollerOptions(SingleWorkerOptions options) {
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix(WorkerThreadsNameHelper.getWorkflowPollerThreadPrefix(this.namespace, this.taskQueue)).build();
        }
        return pollerOptions;
    }

    @Nullable
    public WorkflowTaskDispatchHandle reserveWorkflowExecutor() {
        PollTaskExecutor<WorkflowTask> executor = this.pollTaskExecutor;
        if (executor == null || this.isSuspended()) {
            return null;
        }
        return this.slotSupplier.tryReserveSlot(new SlotReservationData(this.taskQueue, this.options.getIdentity(), this.options.getBuildId())).map(slotPermit -> new WorkflowTaskDispatchHandle(workflowTask -> {
            String queueName = workflowTask.getResponse().getWorkflowExecutionTaskQueue().getName();
            TaskQueueKind queueKind = workflowTask.getResponse().getWorkflowExecutionTaskQueue().getKind();
            Preconditions.checkArgument((this.taskQueue.equals(queueName) || TaskQueueKind.TASK_QUEUE_KIND_STICKY.equals((Object)queueKind) && this.stickyTaskQueueName.equals(queueName) ? 1 : 0) != 0, (String)"Got a WFT for a wrong queue %s, expected %s or %s", (Object)queueName, (Object)this.taskQueue, (Object)this.stickyTaskQueueName);
            try {
                this.pollTaskExecutor.process(workflowTask);
                return true;
            }
            catch (RejectedExecutionException e) {
                return false;
            }
        }, this.slotSupplier, (SlotPermit)slotPermit)).orElse(null);
    }

    public String toString() {
        return String.format("WorkflowWorker{identity=%s, namespace=%s, taskQueue=%s}", this.options.getIdentity(), this.namespace, this.taskQueue);
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<WorkflowTask> {
        final WorkflowTaskHandler handler;

        private TaskHandlerImpl(WorkflowTaskHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(WorkflowTask task) throws Exception {
            PollWorkflowTaskQueueResponse workflowTaskResponse = task.getResponse();
            WorkflowExecution workflowExecution = workflowTaskResponse.getWorkflowExecution();
            String runId = workflowExecution.getRunId();
            String workflowType = workflowTaskResponse.getWorkflowType().getName();
            Scope workflowTypeScope = WorkflowWorker.this.workerMetricsScope.tagged((Map)ImmutableMap.of((Object)"workflow_type", (Object)workflowType));
            MDC.put((String)"WorkflowId", (String)workflowExecution.getWorkflowId());
            MDC.put((String)"WorkflowType", (String)workflowType);
            MDC.put((String)"RunId", (String)runId);
            boolean locked = false;
            Stopwatch swTotal = workflowTypeScope.timer("temporal_workflow_task_execution_total_latency").start();
            SlotReleaseReason releaseReason = SlotReleaseReason.taskComplete();
            try {
                if (!Strings.isNullOrEmpty((String)WorkflowWorker.this.stickyTaskQueueName) && !(locked = WorkflowWorker.this.runLocks.tryLock(runId, 5L, TimeUnit.SECONDS))) {
                    throw new UnableToAcquireLockException("Workflow lock for the run id hasn't been released by one of previous execution attempts, consider increasing workflow task timeout.");
                }
                Optional<Object> nextWFTResponse = Optional.of(workflowTaskResponse);
                do {
                    WorkflowTaskFailedCause taskFailedCause;
                    block28: {
                        PollWorkflowTaskQueueResponse currentTask = nextWFTResponse.get();
                        nextWFTResponse = Optional.empty();
                        WorkflowTaskHandler.Result result = this.handleTask(currentTask, workflowTypeScope);
                        taskFailedCause = null;
                        try {
                            RespondWorkflowTaskCompletedRequest taskCompleted = result.getTaskCompleted();
                            RespondWorkflowTaskFailedRequest taskFailed = result.getTaskFailed();
                            RespondQueryTaskCompletedRequest queryCompleted = result.getQueryCompleted();
                            if (queryCompleted != null) {
                                try {
                                    this.sendDirectQueryCompletedResponse(currentTask.getTaskToken(), queryCompleted.toBuilder(), workflowTypeScope);
                                }
                                catch (StatusRuntimeException e) {
                                    GrpcMessageTooLargeException tooLargeException = GrpcMessageTooLargeException.tryWrap((StatusRuntimeException)e);
                                    if (tooLargeException == null) {
                                        throw e;
                                    }
                                    Failure failure = this.grpcMessageTooLargeFailure(workflowExecution.getWorkflowId(), tooLargeException, "Failed to send query response");
                                    RespondQueryTaskCompletedRequest.Builder queryFailedBuilder = RespondQueryTaskCompletedRequest.newBuilder().setTaskToken(currentTask.getTaskToken()).setNamespace(WorkflowWorker.this.namespace).setCompletedType(QueryResultType.QUERY_RESULT_TYPE_FAILED).setErrorMessage(failure.getMessage()).setFailure(failure);
                                    this.sendDirectQueryCompletedResponse(currentTask.getTaskToken(), queryFailedBuilder, workflowTypeScope);
                                }
                                break block28;
                            }
                            try {
                                if (taskCompleted != null) {
                                    RespondWorkflowTaskCompletedRequest.Builder requestBuilder = taskCompleted.toBuilder();
                                    try (EagerActivitySlotsReservation activitySlotsReservation = new EagerActivitySlotsReservation(WorkflowWorker.this.eagerActivityDispatcher);){
                                        activitySlotsReservation.applyToRequest(requestBuilder);
                                        RespondWorkflowTaskCompletedResponse response = this.sendTaskCompleted(currentTask.getTaskToken(), requestBuilder, result.getRequestRetryOptions(), workflowTypeScope);
                                        long resetEventId = response.getResetHistoryEventId();
                                        if (resetEventId != 0L) {
                                            result.getResetEventIdHandle().apply(resetEventId);
                                        }
                                        nextWFTResponse = response.hasWorkflowTask() ? Optional.of(response.getWorkflowTask()) : Optional.empty();
                                        activitySlotsReservation.handleResponse(response);
                                        break block28;
                                    }
                                }
                                if (taskFailed != null) {
                                    taskFailedCause = taskFailed.getCause();
                                    this.sendTaskFailed(currentTask.getTaskToken(), taskFailed.toBuilder(), result.getRequestRetryOptions(), workflowTypeScope);
                                }
                            }
                            catch (GrpcMessageTooLargeException e) {
                                if (currentTask.getAttempt() > 1) {
                                    throw e;
                                }
                                releaseReason = SlotReleaseReason.error((Exception)((Object)e));
                                this.handleReportingFailure((Exception)((Object)e), currentTask, result, workflowExecution, workflowTypeScope);
                                taskFailedCause = WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_GRPC_MESSAGE_TOO_LARGE;
                                String messagePrefix = String.format("Failed to send workflow task %s", taskFailed == null ? "completion" : "failure");
                                RespondWorkflowTaskFailedRequest.Builder taskFailedBuilder = RespondWorkflowTaskFailedRequest.newBuilder().setFailure(this.grpcMessageTooLargeFailure(workflowExecution.getWorkflowId(), e, messagePrefix)).setCause(WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_GRPC_MESSAGE_TOO_LARGE);
                                this.sendTaskFailed(currentTask.getTaskToken(), taskFailedBuilder, result.getRequestRetryOptions(), workflowTypeScope);
                            }
                        }
                        catch (Exception e) {
                            releaseReason = SlotReleaseReason.error(e);
                            this.handleReportingFailure(e, currentTask, result, workflowExecution, workflowTypeScope);
                            throw e;
                        }
                    }
                    if (taskFailedCause != null) {
                        String taskFailureType;
                        switch (taskFailedCause) {
                            case WORKFLOW_TASK_FAILED_CAUSE_NON_DETERMINISTIC_ERROR: {
                                taskFailureType = "NonDeterminismError";
                                break;
                            }
                            case WORKFLOW_TASK_FAILED_CAUSE_GRPC_MESSAGE_TOO_LARGE: {
                                taskFailureType = "GrpcMessageTooLarge";
                                break;
                            }
                            default: {
                                taskFailureType = "WorkflowError";
                            }
                        }
                        Scope workflowTaskFailureScope = workflowTypeScope.tagged((Map)ImmutableMap.of((Object)"failure_reason", (Object)taskFailureType));
                        workflowTaskFailureScope.counter("temporal_workflow_task_execution_failed").inc(1L);
                    }
                    if (!nextWFTResponse.isPresent()) continue;
                    workflowTypeScope.counter("temporal_workflow_task_heartbeat").inc(1L);
                } while (nextWFTResponse.isPresent());
            }
            finally {
                swTotal.stop();
                task.getCompletionCallback().apply(releaseReason);
                MDC.remove((String)"WorkflowId");
                MDC.remove((String)"WorkflowType");
                MDC.remove((String)"RunId");
                if (locked) {
                    WorkflowWorker.this.runLocks.unlock(runId);
                }
            }
        }

        @Override
        public Throwable wrapFailure(WorkflowTask task, Throwable failure) {
            WorkflowExecution execution = task.getResponse().getWorkflowExecution();
            return new RuntimeException("Failure processing workflow task. WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId() + ", Attempt=" + task.getResponse().getAttempt(), failure);
        }

        private WorkflowTaskHandler.Result handleTask(PollWorkflowTaskQueueResponse task, Scope workflowTypeMetricsScope) throws Exception {
            Stopwatch sw = workflowTypeMetricsScope.timer("temporal_workflow_task_execution_latency").start();
            try {
                WorkflowTaskHandler.Result result = this.handler.handleWorkflowTask(task);
                return result;
            }
            catch (Throwable e) {
                workflowTypeMetricsScope.counter("temporal_workflow_task_no_completion").inc(1L);
                Scope workflowTaskFailureScope = workflowTypeMetricsScope;
                workflowTaskFailureScope = e instanceof NonDeterministicException ? workflowTaskFailureScope.tagged((Map)ImmutableMap.of((Object)"failure_reason", (Object)"NonDeterminismError")) : workflowTaskFailureScope.tagged((Map)ImmutableMap.of((Object)"failure_reason", (Object)"WorkflowError"));
                workflowTaskFailureScope.counter("temporal_workflow_task_execution_failed").inc(1L);
                throw e;
            }
            finally {
                sw.stop();
            }
        }

        private RespondWorkflowTaskCompletedResponse sendTaskCompleted(ByteString taskToken, RespondWorkflowTaskCompletedRequest.Builder taskCompleted, RpcRetryOptions retryOptions, Scope workflowTypeMetricsScope) {
            GrpcRetryer.GrpcRetryerOptions grpcRetryOptions = new GrpcRetryer.GrpcRetryerOptions(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(retryOptions), null);
            taskCompleted.setIdentity(WorkflowWorker.this.options.getIdentity()).setNamespace(WorkflowWorker.this.namespace).setTaskToken(taskToken);
            if (WorkflowWorker.this.options.getDeploymentOptions() != null) {
                taskCompleted.setDeploymentOptions(WorkerVersioningProtoUtils.deploymentOptionsToProto(WorkflowWorker.this.options.getDeploymentOptions()));
            } else if (((GetSystemInfoResponse.Capabilities)WorkflowWorker.this.service.getServerCapabilities().get()).getBuildIdBasedVersioning()) {
                taskCompleted.setWorkerVersionStamp(WorkflowWorker.this.options.workerVersionStamp());
            } else {
                taskCompleted.setBinaryChecksum(WorkflowWorker.this.options.getBuildId());
            }
            return (RespondWorkflowTaskCompletedResponse)WorkflowWorker.this.grpcRetryer.retryWithResult(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)WorkflowWorker.this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)workflowTypeMetricsScope)).respondWorkflowTaskCompleted(taskCompleted.build()), grpcRetryOptions);
        }

        private void sendTaskFailed(ByteString taskToken, RespondWorkflowTaskFailedRequest.Builder taskFailed, RpcRetryOptions retryOptions, Scope workflowTypeMetricsScope) {
            GrpcRetryer.GrpcRetryerOptions grpcRetryOptions = new GrpcRetryer.GrpcRetryerOptions(RpcRetryOptions.newBuilder().buildWithDefaultsFrom(retryOptions), null);
            taskFailed.setIdentity(WorkflowWorker.this.options.getIdentity()).setNamespace(WorkflowWorker.this.namespace).setTaskToken(taskToken);
            if (WorkflowWorker.this.options.getDeploymentOptions() != null) {
                taskFailed.setDeploymentOptions(WorkerVersioningProtoUtils.deploymentOptionsToProto(WorkflowWorker.this.options.getDeploymentOptions()));
            } else if (((GetSystemInfoResponse.Capabilities)WorkflowWorker.this.service.getServerCapabilities().get()).getBuildIdBasedVersioning()) {
                taskFailed.setWorkerVersion(WorkflowWorker.this.options.workerVersionStamp());
            }
            WorkflowWorker.this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)WorkflowWorker.this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)workflowTypeMetricsScope)).respondWorkflowTaskFailed(taskFailed.build()), grpcRetryOptions);
        }

        private void sendDirectQueryCompletedResponse(ByteString taskToken, RespondQueryTaskCompletedRequest.Builder queryCompleted, Scope workflowTypeMetricsScope) {
            queryCompleted.setTaskToken(taskToken).setNamespace(WorkflowWorker.this.namespace);
            ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)WorkflowWorker.this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)workflowTypeMetricsScope)).respondQueryTaskCompleted(queryCompleted.build());
        }

        private void logExceptionDuringResultReporting(Exception e, PollWorkflowTaskQueueResponse currentTask, WorkflowTaskHandler.Result result) {
            if (log.isDebugEnabled()) {
                log.debug("Failure during reporting of workflow progress to the server. If seen continuously the workflow might be stuck. WorkflowId={}, RunId={}, startedEventId={}, WFTResult={}", new Object[]{currentTask.getWorkflowExecution().getWorkflowId(), currentTask.getWorkflowExecution().getRunId(), currentTask.getStartedEventId(), result, e});
            } else {
                log.warn("Failure while reporting workflow progress to the server. If seen continuously the workflow might be stuck. WorkflowId={}, RunId={}, startedEventId={}", new Object[]{currentTask.getWorkflowExecution().getWorkflowId(), currentTask.getWorkflowExecution().getRunId(), currentTask.getStartedEventId(), e});
            }
        }

        private void handleReportingFailure(Exception e, PollWorkflowTaskQueueResponse currentTask, WorkflowTaskHandler.Result result, WorkflowExecution workflowExecution, Scope workflowTypeScope) {
            this.logExceptionDuringResultReporting(e, currentTask, result);
            WorkflowWorker.this.cache.invalidate(workflowExecution, workflowTypeScope, "Failed result reporting to the server", e);
        }

        private Failure grpcMessageTooLargeFailure(String workflowId, GrpcMessageTooLargeException e, String messagePrefix) {
            ApplicationFailure applicationFailure = ApplicationFailure.newBuilder().setMessage(messagePrefix + ": " + e.getMessage()).setType(GrpcMessageTooLargeException.class.getSimpleName()).build();
            applicationFailure.setStackTrace(new StackTraceElement[0]);
            return WorkflowWorker.this.options.getDataConverter().withContext(new WorkflowSerializationContext(WorkflowWorker.this.namespace, workflowId)).exceptionToFailure(applicationFailure);
        }
    }
}

