/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.base.Objects;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.internal.common.ProtocolType;

class TransitionEvent<ExplicitEvent> {
    public static final int EVENT_TYPE_PREFIX_LENGTH = "EVENT_TYPE_".length();
    public static final int COMMAND_TYPE_PREFIX_LENGTH = "COMMAND_TYPE_".length();
    final ExplicitEvent explicitEvent;
    final EventType historyEvent;
    final CommandType commandEvent;
    final ProtocolType messageEvent;

    public TransitionEvent(ExplicitEvent explicitEvent) {
        this.explicitEvent = explicitEvent;
        this.historyEvent = null;
        this.commandEvent = null;
        this.messageEvent = null;
    }

    public TransitionEvent(EventType historyEvent) {
        this.historyEvent = historyEvent;
        this.explicitEvent = null;
        this.commandEvent = null;
        this.messageEvent = null;
    }

    public TransitionEvent(ProtocolType messageEvent) {
        this.historyEvent = null;
        this.explicitEvent = null;
        this.commandEvent = null;
        this.messageEvent = messageEvent;
    }

    public TransitionEvent(CommandType commandEvent) {
        this.commandEvent = commandEvent;
        this.historyEvent = null;
        this.explicitEvent = null;
        this.messageEvent = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitionEvent that = (TransitionEvent)o;
        return Objects.equal(this.explicitEvent, that.explicitEvent) && this.historyEvent == that.historyEvent && this.commandEvent == that.commandEvent && this.messageEvent == that.messageEvent;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.explicitEvent, this.historyEvent, this.commandEvent, this.messageEvent});
    }

    public String toString() {
        if (this.explicitEvent != null) {
            return this.explicitEvent.toString();
        }
        if (this.historyEvent != null) {
            return this.historyEvent.toString().substring(EVENT_TYPE_PREFIX_LENGTH);
        }
        if (this.messageEvent != null) {
            return this.messageEvent.toString();
        }
        return this.commandEvent.toString().substring(COMMAND_TYPE_PREFIX_LENGTH);
    }
}

