/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.base.Preconditions;
import io.temporal.common.Experimental;
import io.temporal.worker.WorkerDeploymentOptions;
import io.temporal.worker.tuning.WorkerTuner;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WorkerOptions {
    static final Duration DEFAULT_STICKY_SCHEDULE_TO_START_TIMEOUT = Duration.ofSeconds(5L);
    static final Duration DEFAULT_STICKY_TASK_QUEUE_DRAIN_TIMEOUT = Duration.ofSeconds(0L);
    private static final WorkerOptions DEFAULT_INSTANCE = WorkerOptions.newBuilder().validateAndBuildWithDefaults();
    private final double maxWorkerActivitiesPerSecond;
    private final int maxConcurrentActivityExecutionSize;
    private final int maxConcurrentWorkflowTaskExecutionSize;
    private final int maxConcurrentLocalActivityExecutionSize;
    private final int maxConcurrentNexusExecutionSize;
    private final WorkerTuner workerTuner;
    private final double maxTaskQueueActivitiesPerSecond;
    private final int maxConcurrentWorkflowTaskPollers;
    private final int maxConcurrentActivityTaskPollers;
    private final int maxConcurrentNexusTaskPollers;
    private final boolean localActivityWorkerOnly;
    private final long defaultDeadlockDetectionTimeout;
    private final Duration maxHeartbeatThrottleInterval;
    private final Duration defaultHeartbeatThrottleInterval;
    @Nonnull
    private final Duration stickyQueueScheduleToStartTimeout;
    private final boolean disableEagerExecution;
    private final boolean useBuildIdForVersioning;
    private final String buildId;
    private final Duration stickyTaskQueueDrainTimeout;
    private final String identity;
    private final boolean usingVirtualThreadsOnWorkflowWorker;
    private final boolean usingVirtualThreadsOnActivityWorker;
    private final boolean usingVirtualThreadsOnLocalActivityWorker;
    private final boolean usingVirtualThreadsOnNexusWorker;
    private final WorkerDeploymentOptions deploymentOptions;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkerOptions options) {
        return new Builder(options);
    }

    public static WorkerOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkerOptions(double maxWorkerActivitiesPerSecond, int maxConcurrentActivityExecutionSize, int maxConcurrentWorkflowTaskExecutionSize, int maxConcurrentLocalActivityExecutionSize, int maxConcurrentNexusExecutionSize, WorkerTuner workerTuner, double maxTaskQueueActivitiesPerSecond, int workflowPollThreadCount, int activityPollThreadCount, int nexusPollThreadCount, boolean localActivityWorkerOnly, long defaultDeadlockDetectionTimeout, Duration maxHeartbeatThrottleInterval, Duration defaultHeartbeatThrottleInterval, @Nonnull Duration stickyQueueScheduleToStartTimeout, boolean disableEagerExecution, boolean useBuildIdForVersioning, String buildId, Duration stickyTaskQueueDrainTimeout, String identity, boolean useThreadsEnabledOnWorkflowWorker, boolean useThreadsEnabledOnActivityWorker, boolean virtualThreadsEnabledOnLocalActivityWorker, boolean virtualThreadsEnabledOnNexusWorker, WorkerDeploymentOptions deploymentOptions) {
        this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
        this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
        this.maxConcurrentWorkflowTaskExecutionSize = maxConcurrentWorkflowTaskExecutionSize;
        this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
        this.maxConcurrentNexusExecutionSize = maxConcurrentNexusExecutionSize;
        this.workerTuner = workerTuner;
        this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
        this.maxConcurrentWorkflowTaskPollers = workflowPollThreadCount;
        this.maxConcurrentActivityTaskPollers = activityPollThreadCount;
        this.maxConcurrentNexusTaskPollers = nexusPollThreadCount;
        this.localActivityWorkerOnly = localActivityWorkerOnly;
        this.defaultDeadlockDetectionTimeout = defaultDeadlockDetectionTimeout;
        this.maxHeartbeatThrottleInterval = maxHeartbeatThrottleInterval;
        this.defaultHeartbeatThrottleInterval = defaultHeartbeatThrottleInterval;
        this.stickyQueueScheduleToStartTimeout = stickyQueueScheduleToStartTimeout;
        this.disableEagerExecution = maxTaskQueueActivitiesPerSecond > 0.0 ? true : disableEagerExecution;
        this.useBuildIdForVersioning = useBuildIdForVersioning;
        this.buildId = buildId;
        this.stickyTaskQueueDrainTimeout = stickyTaskQueueDrainTimeout;
        this.identity = identity;
        this.usingVirtualThreadsOnWorkflowWorker = useThreadsEnabledOnWorkflowWorker;
        this.usingVirtualThreadsOnActivityWorker = useThreadsEnabledOnActivityWorker;
        this.usingVirtualThreadsOnLocalActivityWorker = virtualThreadsEnabledOnLocalActivityWorker;
        this.usingVirtualThreadsOnNexusWorker = virtualThreadsEnabledOnNexusWorker;
        this.deploymentOptions = deploymentOptions;
    }

    public double getMaxWorkerActivitiesPerSecond() {
        return this.maxWorkerActivitiesPerSecond;
    }

    public int getMaxConcurrentActivityExecutionSize() {
        return this.maxConcurrentActivityExecutionSize;
    }

    public int getMaxConcurrentWorkflowTaskExecutionSize() {
        return this.maxConcurrentWorkflowTaskExecutionSize;
    }

    public int getMaxConcurrentLocalActivityExecutionSize() {
        return this.maxConcurrentLocalActivityExecutionSize;
    }

    public int getMaxConcurrentNexusExecutionSize() {
        return this.maxConcurrentNexusExecutionSize;
    }

    public double getMaxTaskQueueActivitiesPerSecond() {
        return this.maxTaskQueueActivitiesPerSecond;
    }

    @Deprecated
    public int getWorkflowPollThreadCount() {
        return this.getMaxConcurrentWorkflowTaskPollers();
    }

    public int getMaxConcurrentWorkflowTaskPollers() {
        return this.maxConcurrentWorkflowTaskPollers;
    }

    @Deprecated
    public int getActivityPollThreadCount() {
        return this.getMaxConcurrentActivityTaskPollers();
    }

    public int getMaxConcurrentActivityTaskPollers() {
        return this.maxConcurrentActivityTaskPollers;
    }

    public int getMaxConcurrentNexusTaskPollers() {
        return this.maxConcurrentNexusTaskPollers;
    }

    public long getDefaultDeadlockDetectionTimeout() {
        return this.defaultDeadlockDetectionTimeout;
    }

    public boolean isLocalActivityWorkerOnly() {
        return this.localActivityWorkerOnly;
    }

    public Duration getMaxHeartbeatThrottleInterval() {
        return this.maxHeartbeatThrottleInterval;
    }

    public Duration getDefaultHeartbeatThrottleInterval() {
        return this.defaultHeartbeatThrottleInterval;
    }

    @Nonnull
    public Duration getStickyQueueScheduleToStartTimeout() {
        return this.stickyQueueScheduleToStartTimeout;
    }

    public boolean isEagerExecutionDisabled() {
        return this.disableEagerExecution;
    }

    public boolean isUsingBuildIdForVersioning() {
        return this.useBuildIdForVersioning;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public Duration getStickyTaskQueueDrainTimeout() {
        return this.stickyTaskQueueDrainTimeout;
    }

    public WorkerTuner getWorkerTuner() {
        return this.workerTuner;
    }

    @Nullable
    public String getIdentity() {
        return this.identity;
    }

    public boolean isUsingVirtualThreadsOnWorkflowWorker() {
        return this.usingVirtualThreadsOnActivityWorker;
    }

    public boolean isUsingVirtualThreadsOnActivityWorker() {
        return this.usingVirtualThreadsOnActivityWorker;
    }

    public boolean isUsingVirtualThreadsOnLocalActivityWorker() {
        return this.usingVirtualThreadsOnLocalActivityWorker;
    }

    public boolean isUsingVirtualThreadsOnNexusWorker() {
        return this.usingVirtualThreadsOnNexusWorker;
    }

    public WorkerDeploymentOptions getDeploymentOptions() {
        return this.deploymentOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerOptions that = (WorkerOptions)o;
        return Double.compare(this.maxWorkerActivitiesPerSecond, that.maxWorkerActivitiesPerSecond) == 0 && this.maxConcurrentActivityExecutionSize == that.maxConcurrentActivityExecutionSize && this.maxConcurrentWorkflowTaskExecutionSize == that.maxConcurrentWorkflowTaskExecutionSize && this.maxConcurrentLocalActivityExecutionSize == that.maxConcurrentLocalActivityExecutionSize && this.maxConcurrentNexusExecutionSize == that.maxConcurrentNexusExecutionSize && Double.compare(this.maxTaskQueueActivitiesPerSecond, that.maxTaskQueueActivitiesPerSecond) == 0 && this.maxConcurrentWorkflowTaskPollers == that.maxConcurrentWorkflowTaskPollers && this.maxConcurrentActivityTaskPollers == that.maxConcurrentActivityTaskPollers && this.maxConcurrentNexusTaskPollers == that.maxConcurrentNexusTaskPollers && this.localActivityWorkerOnly == that.localActivityWorkerOnly && this.defaultDeadlockDetectionTimeout == that.defaultDeadlockDetectionTimeout && this.disableEagerExecution == that.disableEagerExecution && this.useBuildIdForVersioning == that.useBuildIdForVersioning && Objects.equals(this.workerTuner, that.workerTuner) && Objects.equals(this.maxHeartbeatThrottleInterval, that.maxHeartbeatThrottleInterval) && Objects.equals(this.defaultHeartbeatThrottleInterval, that.defaultHeartbeatThrottleInterval) && Objects.equals(this.stickyQueueScheduleToStartTimeout, that.stickyQueueScheduleToStartTimeout) && Objects.equals(this.buildId, that.buildId) && Objects.equals(this.stickyTaskQueueDrainTimeout, that.stickyTaskQueueDrainTimeout) && Objects.equals(this.identity, that.identity) && this.usingVirtualThreadsOnWorkflowWorker == that.usingVirtualThreadsOnWorkflowWorker && this.usingVirtualThreadsOnActivityWorker == that.usingVirtualThreadsOnActivityWorker && this.usingVirtualThreadsOnLocalActivityWorker == that.usingVirtualThreadsOnLocalActivityWorker && this.usingVirtualThreadsOnNexusWorker == that.usingVirtualThreadsOnNexusWorker;
    }

    public int hashCode() {
        return Objects.hash(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize, this.maxConcurrentNexusExecutionSize, this.workerTuner, this.maxTaskQueueActivitiesPerSecond, this.maxConcurrentWorkflowTaskPollers, this.maxConcurrentActivityTaskPollers, this.maxConcurrentNexusTaskPollers, this.localActivityWorkerOnly, this.defaultDeadlockDetectionTimeout, this.maxHeartbeatThrottleInterval, this.defaultHeartbeatThrottleInterval, this.stickyQueueScheduleToStartTimeout, this.disableEagerExecution, this.useBuildIdForVersioning, this.buildId, this.stickyTaskQueueDrainTimeout, this.identity, this.usingVirtualThreadsOnWorkflowWorker, this.usingVirtualThreadsOnActivityWorker, this.usingVirtualThreadsOnLocalActivityWorker, this.usingVirtualThreadsOnNexusWorker);
    }

    public String toString() {
        return "WorkerOptions{maxWorkerActivitiesPerSecond=" + this.maxWorkerActivitiesPerSecond + ", maxConcurrentActivityExecutionSize=" + this.maxConcurrentActivityExecutionSize + ", maxConcurrentWorkflowTaskExecutionSize=" + this.maxConcurrentWorkflowTaskExecutionSize + ", maxConcurrentLocalActivityExecutionSize=" + this.maxConcurrentLocalActivityExecutionSize + ", maxConcurrentNexusExecutionSize=" + this.maxConcurrentNexusExecutionSize + ", workerTuner=" + this.workerTuner + ", maxTaskQueueActivitiesPerSecond=" + this.maxTaskQueueActivitiesPerSecond + ", maxConcurrentWorkflowTaskPollers=" + this.maxConcurrentWorkflowTaskPollers + ", maxConcurrentActivityTaskPollers=" + this.maxConcurrentActivityTaskPollers + ", maxConcurrentNexusTaskPollers=" + this.maxConcurrentNexusTaskPollers + ", localActivityWorkerOnly=" + this.localActivityWorkerOnly + ", defaultDeadlockDetectionTimeout=" + this.defaultDeadlockDetectionTimeout + ", maxHeartbeatThrottleInterval=" + this.maxHeartbeatThrottleInterval + ", defaultHeartbeatThrottleInterval=" + this.defaultHeartbeatThrottleInterval + ", stickyQueueScheduleToStartTimeout=" + this.stickyQueueScheduleToStartTimeout + ", disableEagerExecution=" + this.disableEagerExecution + ", useBuildIdForVersioning=" + this.useBuildIdForVersioning + ", buildId='" + this.buildId + '\'' + ", stickyTaskQueueDrainTimeout=" + this.stickyTaskQueueDrainTimeout + ", identity=" + this.identity + ", usingVirtualThreadsOnWorkflowWorker=" + this.usingVirtualThreadsOnWorkflowWorker + ", usingVirtualThreadsOnActivityWorker=" + this.usingVirtualThreadsOnActivityWorker + ", usingVirtualThreadsOnLocalActivityWorker=" + this.usingVirtualThreadsOnLocalActivityWorker + ", usingVirtualThreadsOnNexusWorker=" + this.usingVirtualThreadsOnNexusWorker + '}';
    }

    public static final class Builder {
        private static final int DEFAULT_MAX_CONCURRENT_WORKFLOW_TASK_POLLERS = 5;
        private static final int DEFAULT_MAX_CONCURRENT_ACTIVITY_TASK_POLLERS = 5;
        private static final int DEFAULT_MAX_CONCURRENT_NEXUS_TASK_POLLERS = 5;
        private static final int DEFAULT_MAX_CONCURRENT_WORKFLOW_TASK_EXECUTION_SIZE = 200;
        private static final int DEFAULT_MAX_CONCURRENT_ACTIVITY_EXECUTION_SIZE = 200;
        private static final int DEFAULT_MAX_CONCURRENT_LOCAL_ACTIVITY_EXECUTION_SIZE = 200;
        private static final int DEFAULT_MAX_CONCURRENT_NEXUS_EXECUTION_SIZE = 200;
        private static final long DEFAULT_DEADLOCK_DETECTION_TIMEOUT = 1000L;
        private static final Duration DEFAULT_MAX_HEARTBEAT_THROTTLE_INTERVAL = Duration.ofSeconds(60L);
        private static final Duration DEFAULT_DEFAULT_HEARTBEAT_THROTTLE_INTERVAL = Duration.ofSeconds(30L);
        private double maxWorkerActivitiesPerSecond;
        private int maxConcurrentActivityExecutionSize;
        private int maxConcurrentWorkflowTaskExecutionSize;
        private int maxConcurrentLocalActivityExecutionSize;
        private int maxConcurrentNexusExecutionSize;
        private double maxTaskQueueActivitiesPerSecond;
        private int maxConcurrentWorkflowTaskPollers;
        private int maxConcurrentActivityTaskPollers;
        private int maxConcurrentNexusTaskPollers;
        private boolean localActivityWorkerOnly;
        private long defaultDeadlockDetectionTimeout;
        private Duration maxHeartbeatThrottleInterval;
        private Duration defaultHeartbeatThrottleInterval;
        private Duration stickyQueueScheduleToStartTimeout;
        private boolean disableEagerExecution;
        private String buildId;
        private boolean useBuildIdForVersioning;
        private Duration stickyTaskQueueDrainTimeout;
        private WorkerTuner workerTuner;
        private boolean usingVirtualThreadsOnWorkflowWorker;
        private boolean usingVirtualThreadsOnActivityWorker;
        private boolean usingVirtualThreadsOnLocalActivityWorker;
        private boolean usingVirtualThreadsOnNexusWorker;
        private String identity;
        private WorkerDeploymentOptions deploymentOptions;

        private Builder() {
        }

        private Builder(WorkerOptions o) {
            if (o == null) {
                return;
            }
            this.maxWorkerActivitiesPerSecond = o.maxWorkerActivitiesPerSecond;
            this.maxConcurrentActivityExecutionSize = o.maxConcurrentActivityExecutionSize;
            this.maxConcurrentWorkflowTaskExecutionSize = o.maxConcurrentWorkflowTaskExecutionSize;
            this.maxConcurrentLocalActivityExecutionSize = o.maxConcurrentLocalActivityExecutionSize;
            this.maxConcurrentNexusExecutionSize = o.maxConcurrentNexusExecutionSize;
            this.workerTuner = o.workerTuner;
            this.maxTaskQueueActivitiesPerSecond = o.maxTaskQueueActivitiesPerSecond;
            this.maxConcurrentWorkflowTaskPollers = o.maxConcurrentWorkflowTaskPollers;
            this.maxConcurrentNexusTaskPollers = o.maxConcurrentNexusTaskPollers;
            this.maxConcurrentActivityTaskPollers = o.maxConcurrentActivityTaskPollers;
            this.localActivityWorkerOnly = o.localActivityWorkerOnly;
            this.defaultDeadlockDetectionTimeout = o.defaultDeadlockDetectionTimeout;
            this.maxHeartbeatThrottleInterval = o.maxHeartbeatThrottleInterval;
            this.defaultHeartbeatThrottleInterval = o.defaultHeartbeatThrottleInterval;
            this.stickyQueueScheduleToStartTimeout = o.stickyQueueScheduleToStartTimeout;
            this.disableEagerExecution = o.disableEagerExecution;
            this.useBuildIdForVersioning = o.useBuildIdForVersioning;
            this.buildId = o.buildId;
            this.stickyTaskQueueDrainTimeout = o.stickyTaskQueueDrainTimeout;
            this.identity = o.identity;
            this.usingVirtualThreadsOnActivityWorker = o.usingVirtualThreadsOnActivityWorker;
            this.usingVirtualThreadsOnWorkflowWorker = o.usingVirtualThreadsOnWorkflowWorker;
            this.usingVirtualThreadsOnLocalActivityWorker = o.usingVirtualThreadsOnLocalActivityWorker;
            this.usingVirtualThreadsOnNexusWorker = o.usingVirtualThreadsOnNexusWorker;
            this.deploymentOptions = o.deploymentOptions;
        }

        public Builder setMaxWorkerActivitiesPerSecond(double maxWorkerActivitiesPerSecond) {
            if (maxWorkerActivitiesPerSecond < 0.0) {
                throw new IllegalArgumentException("Negative maxWorkerActivitiesPerSecond value: " + maxWorkerActivitiesPerSecond);
            }
            this.maxWorkerActivitiesPerSecond = maxWorkerActivitiesPerSecond;
            return this;
        }

        public Builder setMaxConcurrentActivityExecutionSize(int maxConcurrentActivityExecutionSize) {
            if (maxConcurrentActivityExecutionSize < 0) {
                throw new IllegalArgumentException("Negative maxConcurrentActivityExecutionSize value: " + maxConcurrentActivityExecutionSize);
            }
            this.maxConcurrentActivityExecutionSize = maxConcurrentActivityExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentWorkflowTaskExecutionSize(int maxConcurrentWorkflowTaskExecutionSize) {
            if (maxConcurrentWorkflowTaskExecutionSize < 0) {
                throw new IllegalArgumentException("Negative maxConcurrentWorkflowTaskExecutionSize value: " + maxConcurrentWorkflowTaskExecutionSize);
            }
            this.maxConcurrentWorkflowTaskExecutionSize = maxConcurrentWorkflowTaskExecutionSize;
            return this;
        }

        public Builder setMaxConcurrentLocalActivityExecutionSize(int maxConcurrentLocalActivityExecutionSize) {
            if (maxConcurrentLocalActivityExecutionSize < 0) {
                throw new IllegalArgumentException("Negative maxConcurrentLocalActivityExecutionSize value: " + maxConcurrentLocalActivityExecutionSize);
            }
            this.maxConcurrentLocalActivityExecutionSize = maxConcurrentLocalActivityExecutionSize;
            return this;
        }

        @Experimental
        public Builder setMaxConcurrentNexusExecutionSize(int maxConcurrentNexusExecutionSize) {
            if (maxConcurrentNexusExecutionSize < 0) {
                throw new IllegalArgumentException("Negative maxConcurrentNexusExecutionSize value: " + maxConcurrentNexusExecutionSize);
            }
            this.maxConcurrentNexusExecutionSize = maxConcurrentNexusExecutionSize;
            return this;
        }

        public Builder setMaxTaskQueueActivitiesPerSecond(double maxTaskQueueActivitiesPerSecond) {
            this.maxTaskQueueActivitiesPerSecond = maxTaskQueueActivitiesPerSecond;
            return this;
        }

        public Builder setMaxConcurrentWorkflowTaskPollers(int maxConcurrentWorkflowTaskPollers) {
            this.maxConcurrentWorkflowTaskPollers = maxConcurrentWorkflowTaskPollers;
            return this;
        }

        @Experimental
        public Builder setMaxConcurrentNexusTaskPollers(int maxConcurrentNexusTaskPollers) {
            this.maxConcurrentNexusTaskPollers = maxConcurrentNexusTaskPollers;
            return this;
        }

        @Deprecated
        public Builder setWorkflowPollThreadCount(int workflowPollThreadCount) {
            return this.setMaxConcurrentWorkflowTaskPollers(workflowPollThreadCount);
        }

        public Builder setMaxConcurrentActivityTaskPollers(int maxConcurrentActivityTaskPollers) {
            this.maxConcurrentActivityTaskPollers = maxConcurrentActivityTaskPollers;
            return this;
        }

        @Deprecated
        public Builder setActivityPollThreadCount(int activityPollThreadCount) {
            return this.setMaxConcurrentActivityTaskPollers(activityPollThreadCount);
        }

        public Builder setLocalActivityWorkerOnly(boolean localActivityWorkerOnly) {
            this.localActivityWorkerOnly = localActivityWorkerOnly;
            return this;
        }

        public Builder setDefaultDeadlockDetectionTimeout(long defaultDeadlockDetectionTimeoutMs) {
            if (defaultDeadlockDetectionTimeoutMs < 0L) {
                throw new IllegalArgumentException("Negative defaultDeadlockDetectionTimeout value: " + defaultDeadlockDetectionTimeoutMs);
            }
            this.defaultDeadlockDetectionTimeout = defaultDeadlockDetectionTimeoutMs;
            return this;
        }

        public Builder setMaxHeartbeatThrottleInterval(@Nullable Duration interval) {
            Preconditions.checkArgument((interval == null || !interval.isNegative() ? 1 : 0) != 0, (String)"Negative maxHeartbeatThrottleInterval value: %s", (Object)interval);
            this.maxHeartbeatThrottleInterval = interval;
            return this;
        }

        public Builder setDefaultHeartbeatThrottleInterval(@Nullable Duration interval) {
            Preconditions.checkArgument((interval == null || !interval.isNegative() ? 1 : 0) != 0, (String)"Negative defaultHeartbeatThrottleInterval value: %s", (Object)interval);
            this.defaultHeartbeatThrottleInterval = interval;
            return this;
        }

        public Builder setStickyQueueScheduleToStartTimeout(Duration timeout) {
            this.stickyQueueScheduleToStartTimeout = timeout;
            return this;
        }

        public Builder setDisableEagerExecution(boolean disableEagerExecution) {
            this.disableEagerExecution = disableEagerExecution;
            return this;
        }

        @Experimental
        @Deprecated
        public Builder setUseBuildIdForVersioning(boolean useBuildIdForVersioning) {
            this.useBuildIdForVersioning = useBuildIdForVersioning;
            return this;
        }

        @Experimental
        @Deprecated
        public Builder setBuildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        @Experimental
        public Builder setStickyTaskQueueDrainTimeout(Duration stickyTaskQueueDrainTimeout) {
            this.stickyTaskQueueDrainTimeout = stickyTaskQueueDrainTimeout;
            return this;
        }

        @Experimental
        public Builder setWorkerTuner(WorkerTuner workerTuner) {
            this.workerTuner = workerTuner;
            return this;
        }

        @Experimental
        public Builder setUsingVirtualThreads(boolean enable) {
            this.usingVirtualThreadsOnWorkflowWorker = enable;
            this.usingVirtualThreadsOnLocalActivityWorker = enable;
            this.usingVirtualThreadsOnActivityWorker = enable;
            this.usingVirtualThreadsOnNexusWorker = enable;
            return this;
        }

        @Experimental
        public Builder setUsingVirtualThreadsOnWorkflowWorker(boolean enable) {
            this.usingVirtualThreadsOnWorkflowWorker = enable;
            return this;
        }

        @Experimental
        public Builder setUsingVirtualThreadsOnLocalActivityWorker(boolean enable) {
            this.usingVirtualThreadsOnLocalActivityWorker = enable;
            return this;
        }

        @Experimental
        public Builder setUsingVirtualThreadsOnActivityWorker(boolean enable) {
            this.usingVirtualThreadsOnActivityWorker = enable;
            return this;
        }

        @Experimental
        public Builder setUsingVirtualThreadsOnNexusWorker(boolean enable) {
            this.usingVirtualThreadsOnNexusWorker = enable;
            return this;
        }

        public Builder setIdentity(String identity) {
            this.identity = identity;
            return this;
        }

        @Experimental
        public Builder setDeploymentOptions(WorkerDeploymentOptions deploymentOptions) {
            this.deploymentOptions = deploymentOptions;
            return this;
        }

        public WorkerOptions build() {
            return new WorkerOptions(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize, this.maxConcurrentNexusExecutionSize, this.workerTuner, this.maxTaskQueueActivitiesPerSecond, this.maxConcurrentWorkflowTaskPollers, this.maxConcurrentActivityTaskPollers, this.maxConcurrentNexusTaskPollers, this.localActivityWorkerOnly, this.defaultDeadlockDetectionTimeout, this.maxHeartbeatThrottleInterval, this.defaultHeartbeatThrottleInterval, this.stickyQueueScheduleToStartTimeout, this.disableEagerExecution, this.useBuildIdForVersioning, this.buildId, this.stickyTaskQueueDrainTimeout, this.identity, this.usingVirtualThreadsOnWorkflowWorker, this.usingVirtualThreadsOnActivityWorker, this.usingVirtualThreadsOnLocalActivityWorker, this.usingVirtualThreadsOnNexusWorker, this.deploymentOptions);
        }

        public WorkerOptions validateAndBuildWithDefaults() {
            Preconditions.checkState((this.maxWorkerActivitiesPerSecond >= 0.0 ? 1 : 0) != 0, (Object)"negative maxActivitiesPerSecond");
            Preconditions.checkState((this.maxConcurrentActivityExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentActivityExecutionSize");
            Preconditions.checkState((this.maxConcurrentWorkflowTaskExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentWorkflowTaskExecutionSize");
            Preconditions.checkState((this.maxConcurrentLocalActivityExecutionSize >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentLocalActivityExecutionSize");
            if (this.workerTuner != null) {
                Preconditions.checkState((this.maxConcurrentActivityExecutionSize == 0 ? 1 : 0) != 0, (Object)"maxConcurrentActivityExecutionSize must not be set if workerTuner is set");
            }
            if (this.workerTuner != null) {
                Preconditions.checkState((this.maxConcurrentWorkflowTaskExecutionSize == 0 ? 1 : 0) != 0, (Object)"maxConcurrentWorkflowTaskExecutionSize must not be set if workerTuner is set");
            }
            if (this.workerTuner != null) {
                Preconditions.checkState((this.maxConcurrentLocalActivityExecutionSize == 0 ? 1 : 0) != 0, (Object)"maxConcurrentLocalActivityExecutionSize must not be set if workerTuner is set");
            }
            Preconditions.checkState((this.maxTaskQueueActivitiesPerSecond >= 0.0 ? 1 : 0) != 0, (Object)"negative taskQueueActivitiesPerSecond");
            Preconditions.checkState((this.maxConcurrentWorkflowTaskPollers >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentWorkflowTaskPollers");
            Preconditions.checkState((this.maxConcurrentActivityTaskPollers >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentActivityTaskPollers");
            Preconditions.checkState((this.defaultDeadlockDetectionTimeout >= 0L ? 1 : 0) != 0, (Object)"negative defaultDeadlockDetectionTimeout");
            Preconditions.checkState((this.stickyQueueScheduleToStartTimeout == null || !this.stickyQueueScheduleToStartTimeout.isNegative() ? 1 : 0) != 0, (Object)"negative stickyQueueScheduleToStartTimeout");
            if (this.useBuildIdForVersioning) {
                Preconditions.checkState((this.buildId != null && !this.buildId.isEmpty() ? 1 : 0) != 0, (Object)"buildId must be set non-empty if useBuildIdForVersioning is set true");
                Preconditions.checkState((this.deploymentOptions == null ? 1 : 0) != 0, (Object)"deploymentOptions must not be set if useBuildIdForVersioning is set true");
            }
            if (this.buildId != null) {
                Preconditions.checkState((this.deploymentOptions == null ? 1 : 0) != 0, (Object)"deploymentOptions must not be set if buildId is set, prefer using deploymentOptions");
            }
            Preconditions.checkState((this.stickyTaskQueueDrainTimeout == null || !this.stickyTaskQueueDrainTimeout.isNegative() ? 1 : 0) != 0, (Object)"negative stickyTaskQueueDrainTimeout");
            Preconditions.checkState((this.maxConcurrentNexusTaskPollers >= 0 ? 1 : 0) != 0, (Object)"negative maxConcurrentNexusTaskPollers");
            return new WorkerOptions(this.maxWorkerActivitiesPerSecond, this.maxConcurrentActivityExecutionSize == 0 ? 200 : this.maxConcurrentActivityExecutionSize, this.maxConcurrentWorkflowTaskExecutionSize == 0 ? 200 : this.maxConcurrentWorkflowTaskExecutionSize, this.maxConcurrentLocalActivityExecutionSize == 0 ? 200 : this.maxConcurrentLocalActivityExecutionSize, this.maxConcurrentNexusExecutionSize == 0 ? 200 : this.maxConcurrentNexusExecutionSize, this.workerTuner, this.maxTaskQueueActivitiesPerSecond, this.maxConcurrentWorkflowTaskPollers == 0 ? 5 : this.maxConcurrentWorkflowTaskPollers, this.maxConcurrentActivityTaskPollers == 0 ? 5 : this.maxConcurrentActivityTaskPollers, this.maxConcurrentNexusTaskPollers == 0 ? 5 : this.maxConcurrentNexusTaskPollers, this.localActivityWorkerOnly, this.defaultDeadlockDetectionTimeout == 0L ? 1000L : this.defaultDeadlockDetectionTimeout, this.maxHeartbeatThrottleInterval == null || this.maxHeartbeatThrottleInterval.isZero() ? DEFAULT_MAX_HEARTBEAT_THROTTLE_INTERVAL : this.maxHeartbeatThrottleInterval, this.defaultHeartbeatThrottleInterval == null || this.defaultHeartbeatThrottleInterval.isZero() ? DEFAULT_DEFAULT_HEARTBEAT_THROTTLE_INTERVAL : this.defaultHeartbeatThrottleInterval, this.stickyQueueScheduleToStartTimeout == null ? DEFAULT_STICKY_SCHEDULE_TO_START_TIMEOUT : this.stickyQueueScheduleToStartTimeout, this.disableEagerExecution, this.useBuildIdForVersioning, this.buildId, this.stickyTaskQueueDrainTimeout == null ? DEFAULT_STICKY_TASK_QUEUE_DRAIN_TIMEOUT : this.stickyTaskQueueDrainTimeout, this.identity, this.usingVirtualThreadsOnWorkflowWorker, this.usingVirtualThreadsOnActivityWorker, this.usingVirtualThreadsOnLocalActivityWorker, this.usingVirtualThreadsOnNexusWorker, this.deploymentOptions);
        }
    }
}

