/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.ScheduleNexusOperationCommandAttributes;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.failure.v1.NexusOperationFailureInfo;
import io.temporal.api.history.v1.NexusOperationCanceledEventAttributes;
import io.temporal.api.history.v1.NexusOperationCompletedEventAttributes;
import io.temporal.api.history.v1.NexusOperationFailedEventAttributes;
import io.temporal.api.history.v1.NexusOperationTimedOutEventAttributes;
import io.temporal.api.sdk.v1.UserMetadata;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;
import java.util.Optional;
import javax.annotation.Nullable;

final class NexusOperationStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, NexusOperationStateMachine> {
    private static final String JAVA_SDK = "JavaSDK";
    private static final String NEXUS_OPERATION_CANCELED_MESSAGE = "Nexus operation canceled";
    private ScheduleNexusOperationCommandAttributes scheduleAttributes;
    private UserMetadata metadata;
    private final Functions.Proc2<Optional<String>, Failure> startedCallback;
    private boolean async = false;
    private final Functions.Proc2<Optional<Payload>, Failure> completionCallback;
    private final String endpoint;
    private final String service;
    private final String operation;
    public static final StateMachineDefinition<State, ExplicitEvent, NexusOperationStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("NexusOperation", State.CREATED, State.COMPLETED, State.FAILED, State.TIMED_OUT, State.CANCELED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.SCHEDULE_COMMAND_CREATED, NexusOperationStateMachine::createScheduleNexusTaskCommand).add(State.SCHEDULE_COMMAND_CREATED, CommandType.COMMAND_TYPE_SCHEDULE_NEXUS_OPERATION, State.SCHEDULE_COMMAND_CREATED).add(State.SCHEDULE_COMMAND_CREATED, EventType.EVENT_TYPE_NEXUS_OPERATION_SCHEDULED, State.SCHEDULED_EVENT_RECORDED, EntityStateMachineInitialCommand::setInitialCommandEventId).add(State.SCHEDULE_COMMAND_CREATED, ExplicitEvent.CANCEL, State.CANCELED, NexusOperationStateMachine::cancelNexusOperationCommand).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_NEXUS_OPERATION_COMPLETED, State.COMPLETED, NexusOperationStateMachine::notifyCompleted).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_NEXUS_OPERATION_FAILED, State.FAILED, NexusOperationStateMachine::notifyFailed).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_NEXUS_OPERATION_CANCELED, State.CANCELED, NexusOperationStateMachine::notifyCanceled).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_NEXUS_OPERATION_TIMED_OUT, State.TIMED_OUT, NexusOperationStateMachine::notifyTimedOut).add(State.SCHEDULED_EVENT_RECORDED, EventType.EVENT_TYPE_NEXUS_OPERATION_STARTED, State.STARTED, NexusOperationStateMachine::notifyStarted).add(State.STARTED, EventType.EVENT_TYPE_NEXUS_OPERATION_COMPLETED, State.COMPLETED, NexusOperationStateMachine::notifyCompleted).add(State.STARTED, EventType.EVENT_TYPE_NEXUS_OPERATION_FAILED, State.FAILED, NexusOperationStateMachine::notifyFailed).add(State.STARTED, EventType.EVENT_TYPE_NEXUS_OPERATION_CANCELED, State.CANCELED, NexusOperationStateMachine::notifyCanceled).add(State.STARTED, EventType.EVENT_TYPE_NEXUS_OPERATION_TIMED_OUT, State.TIMED_OUT, NexusOperationStateMachine::notifyTimedOut);

    public boolean isCancellable() {
        return State.SCHEDULE_COMMAND_CREATED == this.getState();
    }

    public void cancel() {
        if (!this.isFinalState()) {
            this.explicitEvent(ExplicitEvent.CANCEL);
        }
    }

    private void cancelNexusOperationCommand() {
        this.cancelCommand();
        Failure canceledFailure = Failure.newBuilder().setSource(JAVA_SDK).setMessage("operation canceled before it was started").setCanceledFailureInfo(CanceledFailureInfo.getDefaultInstance()).build();
        NexusOperationFailureInfo nexusFailureInfo = NexusOperationFailureInfo.newBuilder().setEndpoint(this.endpoint).setService(this.service).setOperation(this.operation).setScheduledEventId(this.getInitialCommandEventId()).build();
        Failure failure = Failure.newBuilder().setNexusOperationExecutionFailureInfo(nexusFailureInfo).setCause(canceledFailure).setMessage(NEXUS_OPERATION_CANCELED_MESSAGE).build();
        this.startedCallback.apply(Optional.empty(), failure);
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyStarted() {
        this.async = true;
        String operationToken = this.currentEvent.getNexusOperationStartedEventAttributes().getOperationToken();
        String operationId = this.currentEvent.getNexusOperationStartedEventAttributes().getOperationId();
        this.startedCallback.apply(Optional.of(operationToken.isEmpty() ? operationId : operationToken), null);
    }

    private void notifyCompleted() {
        NexusOperationCompletedEventAttributes attributes = this.currentEvent.getNexusOperationCompletedEventAttributes();
        if (!this.async) {
            this.startedCallback.apply(Optional.empty(), null);
        }
        this.completionCallback.apply(Optional.of(attributes.getResult()), null);
    }

    private void notifyFailed() {
        NexusOperationFailedEventAttributes attributes = this.currentEvent.getNexusOperationFailedEventAttributes();
        if (!this.async) {
            this.startedCallback.apply(Optional.empty(), attributes.getFailure());
        }
        this.completionCallback.apply(Optional.empty(), attributes.getFailure());
    }

    private void notifyCanceled() {
        NexusOperationCanceledEventAttributes attributes = this.currentEvent.getNexusOperationCanceledEventAttributes();
        if (!this.async) {
            this.startedCallback.apply(Optional.empty(), attributes.getFailure());
        }
        this.completionCallback.apply(Optional.empty(), attributes.getFailure());
    }

    private void notifyTimedOut() {
        NexusOperationTimedOutEventAttributes attributes = this.currentEvent.getNexusOperationTimedOutEventAttributes();
        if (!this.async) {
            this.startedCallback.apply(Optional.empty(), attributes.getFailure());
        }
        this.completionCallback.apply(Optional.empty(), attributes.getFailure());
    }

    public static NexusOperationStateMachine newInstance(ScheduleNexusOperationCommandAttributes attributes, @Nullable UserMetadata metadata, Functions.Proc2<Optional<String>, Failure> startedCallback, Functions.Proc2<Optional<Payload>, Failure> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new NexusOperationStateMachine(attributes, metadata, startedCallback, completionCallback, commandSink, stateMachineSink);
    }

    private NexusOperationStateMachine(ScheduleNexusOperationCommandAttributes attributes, @Nullable UserMetadata metadata, Functions.Proc2<Optional<String>, Failure> startedCallback, Functions.Proc2<Optional<Payload>, Failure> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.scheduleAttributes = attributes;
        this.metadata = metadata;
        this.operation = attributes.getOperation();
        this.service = attributes.getService();
        this.endpoint = attributes.getEndpoint();
        this.startedCallback = startedCallback;
        this.completionCallback = completionCallback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    public void createScheduleNexusTaskCommand() {
        Command.Builder command = Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_SCHEDULE_NEXUS_OPERATION).setScheduleNexusOperationCommandAttributes(this.scheduleAttributes);
        if (this.metadata != null) {
            command.setUserMetadata(this.metadata);
        }
        this.addCommand(command.build());
        this.scheduleAttributes = null;
        this.metadata = null;
    }

    static enum State {
        CREATED,
        SCHEDULE_COMMAND_CREATED,
        SCHEDULED_EVENT_RECORDED,
        STARTED,
        COMPLETED,
        FAILED,
        TIMED_OUT,
        CANCELED;

    }

    static enum ExplicitEvent {
        SCHEDULE,
        CANCEL;

    }
}

