/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.temporal.api.common.v1.Link;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.nexus.v1.Link;
import io.temporal.internal.common.ProtoEnumNameUtils;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkConverter {
    private static final Logger log = LoggerFactory.getLogger(LinkConverter.class);
    private static final String linkPathFormat = "temporal:///namespaces/%s/workflows/%s/%s/history";

    public static Link workflowEventToNexusLink(Link.WorkflowEvent we) {
        try {
            String url = String.format(linkPathFormat, URLEncoder.encode(we.getNamespace(), StandardCharsets.UTF_8.toString()), URLEncoder.encode(we.getWorkflowId(), StandardCharsets.UTF_8.toString()), URLEncoder.encode(we.getRunId(), StandardCharsets.UTF_8.toString()));
            if (we.hasEventRef()) {
                url = url + "?";
                if (we.getEventRef().getEventId() > 0L) {
                    url = url + "eventID=" + we.getEventRef().getEventId() + "&";
                }
                url = url + "eventType=" + URLEncoder.encode(we.getEventRef().getEventType().name(), StandardCharsets.UTF_8.toString()) + "&";
                url = url + "referenceType=EventReference";
            }
            return Link.newBuilder().setUrl(url).setType(we.getDescriptorForType().getFullName()).build();
        }
        catch (Exception e) {
            log.error("Failed to encode Nexus link URL", (Throwable)e);
            return null;
        }
    }

    public static io.temporal.api.common.v1.Link nexusLinkToWorkflowEvent(Link nexusLink) {
        Link.Builder link = io.temporal.api.common.v1.Link.newBuilder();
        try {
            URI uri = new URI(nexusLink.getUrl());
            if (!uri.getScheme().equals("temporal")) {
                log.error("Failed to parse Nexus link URL: invalid scheme: {}", (Object)uri.getScheme());
                return null;
            }
            StringTokenizer st = new StringTokenizer(uri.getRawPath(), "/");
            if (!st.nextToken().equals("namespaces")) {
                log.error("Failed to parse Nexus link URL: invalid path: {}", (Object)uri.getRawPath());
                return null;
            }
            String namespace = URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.toString());
            if (!st.nextToken().equals("workflows")) {
                log.error("Failed to parse Nexus link URL: invalid path: {}", (Object)uri.getRawPath());
                return null;
            }
            String workflowID = URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.toString());
            String runID = URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.toString());
            if (!st.hasMoreTokens() || !st.nextToken().equals("history")) {
                log.error("Failed to parse Nexus link URL: invalid path: {}", (Object)uri.getRawPath());
                return null;
            }
            Link.WorkflowEvent.Builder we = Link.WorkflowEvent.newBuilder().setNamespace(namespace).setWorkflowId(workflowID).setRunId(runID);
            if (uri.getQuery() != null) {
                Link.WorkflowEvent.EventReference.Builder eventRef = Link.WorkflowEvent.EventReference.newBuilder();
                String query = URLDecoder.decode(uri.getQuery(), StandardCharsets.UTF_8.toString());
                st = new StringTokenizer(query, "&");
                while (st.hasMoreTokens()) {
                    String[] param = st.nextToken().split("=");
                    switch (param[0]) {
                        case "eventID": {
                            eventRef.setEventId(Long.parseLong(param[1]));
                            break;
                        }
                        case "eventType": {
                            if (param[1].startsWith("EVENT_TYPE_")) {
                                eventRef.setEventType(EventType.valueOf((String)param[1]));
                                break;
                            }
                            eventRef.setEventType(EventType.valueOf((String)ProtoEnumNameUtils.simplifiedToUniqueName(param[1], "EVENT_TYPE_")));
                        }
                    }
                }
                we.setEventRef(eventRef);
                link.setWorkflowEvent(we);
            }
        }
        catch (Exception e) {
            log.error("Failed to parse Nexus link URL", (Throwable)e);
            return null;
        }
        return link.build();
    }
}

