/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.activity;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.common.Priority;
import io.temporal.internal.activity.ActivityInfoInternal;
import io.temporal.internal.common.PriorityUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

final class ActivityInfoImpl
implements ActivityInfoInternal {
    private final String namespace;
    private final String activityTaskQueue;
    private final PollActivityTaskQueueResponseOrBuilder response;
    private final boolean local;
    private final Functions.Proc completionHandle;

    ActivityInfoImpl(PollActivityTaskQueueResponseOrBuilder response, @Nonnull String namespace, @Nonnull String activityTaskQueue, boolean local, Functions.Proc completionHandle) {
        this.response = Objects.requireNonNull(response);
        this.namespace = Objects.requireNonNull(namespace);
        this.activityTaskQueue = Objects.requireNonNull(activityTaskQueue);
        this.local = local;
        this.completionHandle = completionHandle;
    }

    @Override
    public byte[] getTaskToken() {
        return this.response.getTaskToken().toByteArray();
    }

    @Override
    public String getWorkflowId() {
        return this.response.getWorkflowExecution().getWorkflowId();
    }

    @Override
    public String getRunId() {
        return this.response.getWorkflowExecution().getRunId();
    }

    @Override
    public String getActivityId() {
        return this.response.getActivityId();
    }

    @Override
    public String getActivityType() {
        return this.response.getActivityType().getName();
    }

    @Override
    public long getScheduledTimestamp() {
        return Timestamps.toMillis((Timestamp)this.response.getScheduledTime());
    }

    @Override
    public long getStartedTimestamp() {
        return Timestamps.toMillis((Timestamp)this.response.getStartedTime());
    }

    @Override
    public long getCurrentAttemptScheduledTimestamp() {
        return Timestamps.toMillis((Timestamp)this.response.getCurrentAttemptScheduledTime());
    }

    @Override
    public Duration getScheduleToCloseTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.response.getScheduleToCloseTimeout());
    }

    @Override
    public Duration getStartToCloseTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.response.getStartToCloseTimeout());
    }

    @Override
    @Nonnull
    public Duration getHeartbeatTimeout() {
        return ProtobufTimeUtils.toJavaDuration(this.response.getHeartbeatTimeout());
    }

    @Override
    public Optional<Payloads> getHeartbeatDetails() {
        if (this.response.hasHeartbeatDetails()) {
            return Optional.of(this.response.getHeartbeatDetails());
        }
        return Optional.empty();
    }

    @Override
    public String getWorkflowType() {
        return this.response.getWorkflowType().getName();
    }

    @Override
    @Deprecated
    public String getWorkflowNamespace() {
        return this.getNamespace();
    }

    @Override
    @Deprecated
    public String getActivityNamespace() {
        return this.getNamespace();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getActivityTaskQueue() {
        return this.activityTaskQueue;
    }

    @Override
    public int getAttempt() {
        return this.response.getAttempt();
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Priority getPriority() {
        return PriorityUtils.fromProto(this.response.getPriority());
    }

    @Override
    public Functions.Proc getCompletionHandle() {
        return this.completionHandle;
    }

    @Override
    public Optional<Payloads> getInput() {
        if (this.response.hasInput()) {
            return Optional.of(this.response.getInput());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Header> getHeader() {
        if (this.response.hasHeader()) {
            return Optional.of(this.response.getHeader());
        }
        return Optional.empty();
    }

    public String toString() {
        return "WorkflowInfo{, workflowId=" + this.getWorkflowId() + ", runId=" + this.getRunId() + ", activityId=" + this.getActivityId() + ", activityType=" + this.getActivityType() + ", scheduledTimestamp=" + this.getScheduledTimestamp() + ", startedTimestamp=" + this.getStartedTimestamp() + ", currentAttemptScheduledTimestamp=" + this.getCurrentAttemptScheduledTimestamp() + ", scheduleToCloseTimeout=" + this.getScheduleToCloseTimeout() + ", startToCloseTimeout=" + this.getStartToCloseTimeout() + ", heartbeatTimeout=" + this.getHeartbeatTimeout() + ", heartbeatDetails=" + this.getHeartbeatDetails() + ", workflowType=" + this.getWorkflowType() + ", namespace=" + this.getNamespace() + ", attempt=" + this.getAttempt() + ", isLocal=" + this.isLocal() + "taskToken=" + Base64.getEncoder().encodeToString(this.getTaskToken()) + '}';
    }
}

