/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.failure;

import io.temporal.common.Experimental;
import io.temporal.failure.TemporalFailure;

@Experimental
public final class NexusOperationFailure
extends TemporalFailure {
    private final long scheduledEventId;
    private final String endpoint;
    private final String service;
    private final String operation;
    private final String operationToken;

    public NexusOperationFailure(String message, long scheduledEventId, String endpoint, String service, String operation, String operationToken, Throwable cause) {
        super(NexusOperationFailure.getMessage(message, scheduledEventId, endpoint, service, operation, operationToken), message, cause);
        this.scheduledEventId = scheduledEventId;
        this.endpoint = endpoint;
        this.service = service;
        this.operation = operation;
        this.operationToken = operationToken;
    }

    public static String getMessage(String originalMessage, long scheduledEventId, String endpoint, String service, String operation, String operationToken) {
        return "Nexus Operation with operation='" + operation + "service='" + service + "' endpoint='" + endpoint + "' failed: '" + originalMessage + "'. scheduledEventId=" + scheduledEventId + (operationToken == null ? "" : ", operationToken=" + operationToken);
    }

    public long getScheduledEventId() {
        return this.scheduledEventId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getService() {
        return this.service;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getOperationToken() {
        return this.operationToken;
    }
}

