/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import com.google.common.base.Objects;
import io.temporal.api.enums.v1.ParentClosePolicy;
import io.temporal.api.enums.v1.WorkflowIdReusePolicy;
import io.temporal.common.CronSchedule;
import io.temporal.common.Experimental;
import io.temporal.common.MethodRetry;
import io.temporal.common.RetryOptions;
import io.temporal.common.SearchAttributes;
import io.temporal.common.VersioningIntent;
import io.temporal.common.context.ContextPropagator;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.workflow.ChildWorkflowCancellationType;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public final class ChildWorkflowOptions {
    private static final ChildWorkflowOptions DEFAULT_INSTANCE = ChildWorkflowOptions.newBuilder().build();
    private final String namespace;
    private final String workflowId;
    private final WorkflowIdReusePolicy workflowIdReusePolicy;
    private final Duration workflowRunTimeout;
    private final Duration workflowExecutionTimeout;
    private final Duration workflowTaskTimeout;
    private final String taskQueue;
    private final RetryOptions retryOptions;
    private final String cronSchedule;
    private final ParentClosePolicy parentClosePolicy;
    private final Map<String, Object> memo;
    private final Map<String, Object> searchAttributes;
    private final SearchAttributes typedSearchAttributes;
    private final List<ContextPropagator> contextPropagators;
    private final ChildWorkflowCancellationType cancellationType;
    private final VersioningIntent versioningIntent;
    private final String staticSummary;
    private final String staticDetails;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ChildWorkflowOptions options) {
        return new Builder(options);
    }

    public static ChildWorkflowOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private ChildWorkflowOptions(String namespace, String workflowId, WorkflowIdReusePolicy workflowIdReusePolicy, Duration workflowRunTimeout, Duration workflowExecutionTimeout, Duration workflowTaskTimeout, String taskQueue, RetryOptions retryOptions, String cronSchedule, ParentClosePolicy parentClosePolicy, Map<String, Object> memo, Map<String, Object> searchAttributes, SearchAttributes typedSearchAttributes, List<ContextPropagator> contextPropagators, ChildWorkflowCancellationType cancellationType, VersioningIntent versioningIntent, String staticSummary, String staticDetails) {
        this.namespace = namespace;
        this.workflowId = workflowId;
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        this.workflowRunTimeout = workflowRunTimeout;
        this.workflowExecutionTimeout = workflowExecutionTimeout;
        this.workflowTaskTimeout = workflowTaskTimeout;
        this.taskQueue = taskQueue;
        this.retryOptions = retryOptions;
        this.cronSchedule = cronSchedule;
        this.parentClosePolicy = parentClosePolicy;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
        this.typedSearchAttributes = typedSearchAttributes;
        this.contextPropagators = contextPropagators;
        this.cancellationType = cancellationType;
        this.versioningIntent = versioningIntent;
        this.staticSummary = staticSummary;
        this.staticDetails = staticDetails;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public WorkflowIdReusePolicy getWorkflowIdReusePolicy() {
        return this.workflowIdReusePolicy;
    }

    public Duration getWorkflowRunTimeout() {
        return this.workflowRunTimeout;
    }

    public Duration getWorkflowExecutionTimeout() {
        return this.workflowExecutionTimeout;
    }

    public Duration getWorkflowTaskTimeout() {
        return this.workflowTaskTimeout;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public ParentClosePolicy getParentClosePolicy() {
        return this.parentClosePolicy;
    }

    public Map<String, Object> getMemo() {
        return this.memo;
    }

    @Deprecated
    public Map<String, Object> getSearchAttributes() {
        return this.searchAttributes;
    }

    public SearchAttributes getTypedSearchAttributes() {
        return this.typedSearchAttributes;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public ChildWorkflowCancellationType getCancellationType() {
        return this.cancellationType;
    }

    public VersioningIntent getVersioningIntent() {
        return this.versioningIntent;
    }

    public String getStaticSummary() {
        return this.staticSummary;
    }

    public String getStaticDetails() {
        return this.staticDetails;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildWorkflowOptions that = (ChildWorkflowOptions)o;
        return Objects.equal((Object)this.namespace, (Object)that.namespace) && Objects.equal((Object)this.workflowId, (Object)that.workflowId) && this.workflowIdReusePolicy == that.workflowIdReusePolicy && Objects.equal((Object)this.workflowRunTimeout, (Object)that.workflowRunTimeout) && Objects.equal((Object)this.workflowExecutionTimeout, (Object)that.workflowExecutionTimeout) && Objects.equal((Object)this.workflowTaskTimeout, (Object)that.workflowTaskTimeout) && Objects.equal((Object)this.taskQueue, (Object)that.taskQueue) && Objects.equal((Object)this.retryOptions, (Object)that.retryOptions) && Objects.equal((Object)this.cronSchedule, (Object)that.cronSchedule) && this.parentClosePolicy == that.parentClosePolicy && Objects.equal(this.memo, that.memo) && Objects.equal(this.searchAttributes, that.searchAttributes) && Objects.equal((Object)this.typedSearchAttributes, (Object)that.typedSearchAttributes) && Objects.equal(this.contextPropagators, that.contextPropagators) && this.cancellationType == that.cancellationType && this.versioningIntent == that.versioningIntent && Objects.equal((Object)this.staticSummary, (Object)that.staticSummary) && Objects.equal((Object)this.staticDetails, (Object)that.staticDetails);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.namespace, this.workflowId, this.workflowIdReusePolicy, this.workflowRunTimeout, this.workflowExecutionTimeout, this.workflowTaskTimeout, this.taskQueue, this.retryOptions, this.cronSchedule, this.parentClosePolicy, this.memo, this.searchAttributes, this.typedSearchAttributes, this.contextPropagators, this.cancellationType, this.versioningIntent, this.staticSummary, this.staticDetails});
    }

    public String toString() {
        return "ChildWorkflowOptions{namespace='" + this.namespace + '\'' + ", workflowId='" + this.workflowId + '\'' + ", workflowIdReusePolicy=" + this.workflowIdReusePolicy + ", workflowRunTimeout=" + this.workflowRunTimeout + ", workflowExecutionTimeout=" + this.workflowExecutionTimeout + ", workflowTaskTimeout=" + this.workflowTaskTimeout + ", taskQueue='" + this.taskQueue + '\'' + ", retryOptions=" + this.retryOptions + ", cronSchedule='" + this.cronSchedule + '\'' + ", parentClosePolicy=" + this.parentClosePolicy + ", memo=" + this.memo + ", searchAttributes=" + this.searchAttributes + ", typedSearchAttributes=" + this.typedSearchAttributes + ", contextPropagators=" + this.contextPropagators + ", cancellationType=" + (Object)((Object)this.cancellationType) + ", versioningIntent=" + (Object)((Object)this.versioningIntent) + ", staticSummary=" + this.staticSummary + ", staticDetails=" + this.staticDetails + '}';
    }

    public static final class Builder {
        private String namespace;
        private String workflowId;
        private WorkflowIdReusePolicy workflowIdReusePolicy;
        private Duration workflowRunTimeout;
        private Duration workflowExecutionTimeout;
        private Duration workflowTaskTimeout;
        private String taskQueue;
        private RetryOptions retryOptions;
        private String cronSchedule;
        private ParentClosePolicy parentClosePolicy;
        private Map<String, Object> memo;
        private Map<String, Object> searchAttributes;
        private SearchAttributes typedSearchAttributes;
        private List<ContextPropagator> contextPropagators;
        private ChildWorkflowCancellationType cancellationType;
        private VersioningIntent versioningIntent;
        private String staticSummary;
        private String staticDetails;

        private Builder() {
        }

        private Builder(ChildWorkflowOptions options) {
            if (options == null) {
                return;
            }
            this.namespace = options.getNamespace();
            this.workflowId = options.getWorkflowId();
            this.workflowIdReusePolicy = options.getWorkflowIdReusePolicy();
            this.workflowRunTimeout = options.getWorkflowRunTimeout();
            this.workflowExecutionTimeout = options.getWorkflowExecutionTimeout();
            this.workflowTaskTimeout = options.getWorkflowTaskTimeout();
            this.taskQueue = options.getTaskQueue();
            this.retryOptions = options.getRetryOptions();
            this.cronSchedule = options.getCronSchedule();
            this.parentClosePolicy = options.getParentClosePolicy();
            this.memo = options.getMemo();
            this.searchAttributes = options.getSearchAttributes();
            this.typedSearchAttributes = options.getTypedSearchAttributes();
            this.contextPropagators = options.getContextPropagators();
            this.cancellationType = options.getCancellationType();
            this.versioningIntent = options.getVersioningIntent();
            this.staticSummary = options.getStaticSummary();
            this.staticDetails = options.getStaticDetails();
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Builder setWorkflowIdReusePolicy(WorkflowIdReusePolicy workflowIdReusePolicy) {
            this.workflowIdReusePolicy = workflowIdReusePolicy;
            return this;
        }

        public Builder setWorkflowRunTimeout(Duration workflowRunTimeout) {
            this.workflowRunTimeout = workflowRunTimeout;
            return this;
        }

        public Builder setWorkflowExecutionTimeout(Duration workflowExecutionTimeout) {
            this.workflowExecutionTimeout = workflowExecutionTimeout;
            return this;
        }

        public Builder setWorkflowTaskTimeout(Duration workflowTaskTimeout) {
            if (OptionsUtils.roundUpToSeconds((Duration)workflowTaskTimeout) > 120) {
                throw new IllegalArgumentException("WorkflowTaskTimeout over two minutes: " + workflowTaskTimeout);
            }
            this.workflowTaskTimeout = workflowTaskTimeout;
            return this;
        }

        public Builder setTaskQueue(String taskQueue) {
            this.taskQueue = taskQueue;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setCronSchedule(String cronSchedule) {
            this.cronSchedule = cronSchedule;
            return this;
        }

        public Builder setParentClosePolicy(ParentClosePolicy parentClosePolicy) {
            this.parentClosePolicy = parentClosePolicy;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        @Deprecated
        public Builder setSearchAttributes(Map<String, Object> searchAttributes) {
            if (searchAttributes != null && !searchAttributes.isEmpty() && this.typedSearchAttributes != null) {
                throw new IllegalArgumentException("Cannot have search attributes and typed search attributes");
            }
            this.searchAttributes = searchAttributes;
            return this;
        }

        public Builder setTypedSearchAttributes(SearchAttributes typedSearchAttributes) {
            if (typedSearchAttributes != null && this.searchAttributes != null && !this.searchAttributes.isEmpty()) {
                throw new IllegalArgumentException("Cannot have typed search attributes and search attributes");
            }
            this.typedSearchAttributes = typedSearchAttributes;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setCancellationType(ChildWorkflowCancellationType cancellationType) {
            this.cancellationType = cancellationType;
            return this;
        }

        public Builder setMethodRetry(MethodRetry r) {
            this.retryOptions = RetryOptions.merge(r, this.retryOptions);
            return this;
        }

        public Builder setCronSchedule(CronSchedule c) {
            String cronAnnotation = c == null ? "" : c.value();
            this.cronSchedule = (String)OptionsUtils.merge((Object)cronAnnotation, (Object)this.cronSchedule, String.class);
            return this;
        }

        public Builder setVersioningIntent(VersioningIntent versioningIntent) {
            this.versioningIntent = versioningIntent;
            return this;
        }

        @Experimental
        public Builder setStaticSummary(String staticSummary) {
            this.staticSummary = staticSummary;
            return this;
        }

        @Experimental
        public Builder setStaticDetails(String staticDetails) {
            this.staticDetails = staticDetails;
            return this;
        }

        public ChildWorkflowOptions build() {
            return new ChildWorkflowOptions(this.namespace, this.workflowId, this.workflowIdReusePolicy, this.workflowRunTimeout, this.workflowExecutionTimeout, this.workflowTaskTimeout, this.taskQueue, this.retryOptions, this.cronSchedule, this.parentClosePolicy, this.memo, this.searchAttributes, this.typedSearchAttributes, this.contextPropagators, this.cancellationType, this.versioningIntent, this.staticSummary, this.staticDetails);
        }

        public ChildWorkflowOptions validateAndBuildWithDefaults() {
            return new ChildWorkflowOptions(this.namespace, this.workflowId, this.workflowIdReusePolicy, this.workflowRunTimeout, this.workflowExecutionTimeout, this.workflowTaskTimeout, this.taskQueue, this.retryOptions, this.cronSchedule, this.parentClosePolicy, this.memo, this.searchAttributes, this.typedSearchAttributes, this.contextPropagators, this.cancellationType == null ? ChildWorkflowCancellationType.WAIT_CANCELLATION_COMPLETED : this.cancellationType, this.versioningIntent == null ? VersioningIntent.VERSIONING_INTENT_UNSPECIFIED : this.versioningIntent, this.staticSummary, this.staticDetails);
        }
    }
}

