/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.internal.worker.ActivityTaskHandler;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LocalActivityResult {
    @Nonnull
    private final String activityId;
    private final int lastAttempt;
    @Nullable
    private final RespondActivityTaskCompletedRequest executionCompleted;
    @Nullable
    private final ExecutionFailedResult executionFailed;
    @Nullable
    private final RespondActivityTaskCanceledRequest executionCanceled;
    @Nullable
    private final ProcessingErrorResult processingError;

    static LocalActivityResult completed(ActivityTaskHandler.Result ahResult, int attempt) {
        return new LocalActivityResult(ahResult.getActivityId(), attempt, ahResult.getTaskCompleted(), null, null, null);
    }

    static LocalActivityResult failed(String activityId, int attempt, RetryState retryState, Failure timeoutFailure, @Nullable Duration backoff) {
        ExecutionFailedResult failedResult = new ExecutionFailedResult(retryState, timeoutFailure, backoff);
        return new LocalActivityResult(activityId, attempt, null, failedResult, null, null);
    }

    static LocalActivityResult cancelled(ActivityTaskHandler.Result ahResult, int attempt) {
        return new LocalActivityResult(ahResult.getActivityId(), attempt, null, null, ahResult.getTaskCanceled(), null);
    }

    static LocalActivityResult processingFailed(String activityId, int attempt, Throwable ex) {
        return new LocalActivityResult(activityId, attempt, null, null, null, new ProcessingErrorResult(ex));
    }

    public LocalActivityResult(@Nonnull String activityId, int lastAttempt, @Nullable RespondActivityTaskCompletedRequest executionCompleted, @Nullable ExecutionFailedResult executionFailed, @Nullable RespondActivityTaskCanceledRequest executionCanceled, @Nullable ProcessingErrorResult processingError) {
        this.activityId = activityId;
        this.lastAttempt = lastAttempt;
        this.executionCompleted = executionCompleted;
        this.executionFailed = executionFailed;
        this.executionCanceled = executionCanceled;
        this.processingError = processingError;
    }

    @Nonnull
    public String getActivityId() {
        return this.activityId;
    }

    public int getLastAttempt() {
        return this.lastAttempt;
    }

    @Nullable
    public RespondActivityTaskCompletedRequest getExecutionCompleted() {
        return this.executionCompleted;
    }

    @Nullable
    public ExecutionFailedResult getExecutionFailed() {
        return this.executionFailed;
    }

    @Nullable
    public RespondActivityTaskCanceledRequest getExecutionCanceled() {
        return this.executionCanceled;
    }

    @Nullable
    public ProcessingErrorResult getProcessingError() {
        return this.processingError;
    }

    public String toString() {
        return "LocalActivityResult{activityId='" + this.activityId + '\'' + ", lastAttempt=" + this.lastAttempt + ", executionCompleted=" + this.executionCompleted + ", executionFailed=" + this.executionFailed + ", executionCanceled=" + this.executionCanceled + ", processingError=" + this.processingError + '}';
    }

    public static class ProcessingErrorResult {
        @Nonnull
        private final Throwable throwable;

        public ProcessingErrorResult(@Nonnull Throwable throwable) {
            this.throwable = throwable;
        }

        @Nonnull
        public Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            return "ProcessingErrorResult{throwable=" + this.throwable + '}';
        }
    }

    public static class ExecutionFailedResult {
        @Nonnull
        private final RetryState retryState;
        @Nonnull
        private final Failure failure;
        @Nullable
        private final Duration backoff;

        public ExecutionFailedResult(@Nonnull RetryState retryState, @Nonnull Failure failure, @Nullable Duration backoff) {
            this.retryState = retryState;
            this.failure = failure;
            this.backoff = backoff;
        }

        @Nonnull
        public RetryState getRetryState() {
            return this.retryState;
        }

        @Nonnull
        public Failure getFailure() {
            return this.failure;
        }

        @Nullable
        public Duration getBackoff() {
            return this.backoff;
        }

        public boolean isTimeout() {
            return this.failure.hasTimeoutFailureInfo();
        }

        public String toString() {
            return "ExecutionFailedResult{retryState=" + this.retryState + ", failure=" + this.failure + ", backoff=" + this.backoff + '}';
        }
    }
}

