/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import com.google.common.base.Preconditions;
import io.temporal.workflow.NexusOperationOptions;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class NexusServiceOptions {
    private static final NexusServiceOptions DEFAULT_INSTANCE = NexusServiceOptions.newBuilder().build();
    private final NexusOperationOptions operationOptions;
    private final Map<String, NexusOperationOptions> operationMethodOptions;
    private final String endpoint;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(NexusServiceOptions options) {
        return new Builder(options);
    }

    public static NexusServiceOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private NexusServiceOptions(String endpoint, NexusOperationOptions operationOptions, Map<String, NexusOperationOptions> operationMethodOptions) {
        this.endpoint = endpoint;
        this.operationOptions = operationOptions;
        this.operationMethodOptions = operationMethodOptions == null ? Collections.emptyMap() : Collections.unmodifiableMap(operationMethodOptions);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public NexusOperationOptions getOperationOptions() {
        return this.operationOptions;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, NexusOperationOptions> getOperationMethodOptions() {
        return this.operationMethodOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NexusServiceOptions that = (NexusServiceOptions)o;
        return Objects.equals(this.operationOptions, that.operationOptions) && Objects.equals(this.operationMethodOptions, that.operationMethodOptions) && Objects.equals(this.endpoint, that.endpoint);
    }

    public int hashCode() {
        return Objects.hash(this.operationOptions, this.operationMethodOptions, this.endpoint);
    }

    public String toString() {
        return "NexusServiceOptions{operationOptions=" + this.operationOptions + ", operationMethodOptions=" + this.operationMethodOptions + ", endpoint='" + this.endpoint + '\'' + '}';
    }

    public static final class Builder {
        private String endpoint;
        private NexusOperationOptions operationOptions;
        private Map<String, NexusOperationOptions> operationMethodOptions;

        public Builder setOperationOptions(NexusOperationOptions operationOptions) {
            this.operationOptions = operationOptions;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            Preconditions.checkArgument((endpoint == null || !endpoint.isEmpty() ? 1 : 0) != 0, (Object)"endpoint cannot be empty if set");
            this.endpoint = endpoint;
            return this;
        }

        public Builder setOperationMethodOptions(Map<String, NexusOperationOptions> operationMethodOptions) {
            this.operationMethodOptions = operationMethodOptions;
            return this;
        }

        private Builder() {
        }

        private Builder(NexusServiceOptions options) {
            if (options == null) {
                return;
            }
            this.endpoint = options.getEndpoint();
            this.operationOptions = options.getOperationOptions();
            this.operationMethodOptions = options.getOperationMethodOptions();
        }

        public NexusServiceOptions build() {
            return new NexusServiceOptions(this.endpoint, this.operationOptions, this.operationMethodOptions);
        }

        public Builder mergeNexusServiceOptions(NexusServiceOptions override) {
            if (override == null) {
                return this;
            }
            this.endpoint = override.endpoint == null ? this.endpoint : override.endpoint;
            this.operationOptions = override.operationOptions == null ? this.operationOptions : override.operationOptions;
            Map<String, NexusOperationOptions> mergeTo = this.operationMethodOptions;
            if (override.getOperationMethodOptions() != null) {
                override.getOperationMethodOptions().forEach((key, value) -> mergeTo.merge((String)key, (NexusOperationOptions)value, (o1, o2) -> NexusOperationOptions.newBuilder(o1).mergeNexusOperationOptions((NexusOperationOptions)o2).build()));
            }
            return this;
        }
    }
}

