/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.internal.statemachines.DynamicCallback;
import io.temporal.internal.statemachines.TransitionAction;
import java.util.Arrays;
import java.util.List;

class DynamicTransitionAction<State, Data>
implements TransitionAction<State, Data> {
    final DynamicCallback<State, Data> callback;
    State[] expectedStates;

    DynamicTransitionAction(State[] expectedStates, DynamicCallback<State, Data> callback) {
        this.expectedStates = expectedStates;
        this.callback = callback;
    }

    @Override
    public State apply(Data data) {
        State state = this.callback.apply(data);
        for (State s : this.expectedStates) {
            if (!s.equals(state)) continue;
            return state;
        }
        throw new IllegalStateException(state + " is not expected. Expected states are: " + Arrays.toString(this.expectedStates));
    }

    @Override
    public List<State> getAllowedStates() {
        return Arrays.asList(this.expectedStates);
    }

    public String toString() {
        return "DynamicTransitionAction{expectedStates=" + Arrays.toString(this.expectedStates) + '}';
    }
}

