/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.UpdateWorkflowExecutionLifecycleStage;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.errordetails.v1.MultiOperationExecutionFailure;
import io.temporal.api.failure.v1.MultiOperationExecutionAborted;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.sdk.v1.UserMetadata;
import io.temporal.api.update.v1.Input;
import io.temporal.api.update.v1.Meta;
import io.temporal.api.update.v1.Request;
import io.temporal.api.update.v1.UpdateRef;
import io.temporal.api.update.v1.WaitPolicy;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.ExecuteMultiOperationRequest;
import io.temporal.api.workflowservice.v1.ExecuteMultiOperationResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowExecutionUpdateResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequestOrBuilder;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.UpdateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.UpdateWorkflowExecutionResponse;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowExecutionDescription;
import io.temporal.client.WorkflowUpdateException;
import io.temporal.client.WorkflowUpdateHandle;
import io.temporal.client.WorkflowUpdateStage;
import io.temporal.client.WorkflowUpdateTimeoutOrCancelledException;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.internal.client.CompletedWorkflowUpdateHandleImpl;
import io.temporal.internal.client.EagerWorkflowTaskDispatcher;
import io.temporal.internal.client.LazyWorkflowUpdateHandleImpl;
import io.temporal.internal.client.WorkerFactoryRegistry;
import io.temporal.internal.client.WorkflowClientLongPollAsyncHelper;
import io.temporal.internal.client.WorkflowClientLongPollHelper;
import io.temporal.internal.client.WorkflowClientRequestFactory;
import io.temporal.internal.client.external.GenericWorkflowClient;
import io.temporal.internal.common.HeaderUtils;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.payload.context.WorkflowSerializationContext;
import io.temporal.serviceclient.StatusUtils;
import io.temporal.worker.WorkflowTaskDispatchHandle;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootWorkflowClientInvoker
implements WorkflowClientCallsInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RootWorkflowClientInvoker.class);
    private static final long POLL_UPDATE_TIMEOUT_S = 60L;
    private final GenericWorkflowClient genericClient;
    private final WorkflowClientOptions clientOptions;
    private final EagerWorkflowTaskDispatcher eagerWorkflowTaskDispatcher;
    private final WorkflowClientRequestFactory requestsHelper;

    public RootWorkflowClientInvoker(GenericWorkflowClient genericClient, WorkflowClientOptions clientOptions, WorkerFactoryRegistry workerFactoryRegistry) {
        this.genericClient = genericClient;
        this.clientOptions = clientOptions;
        this.eagerWorkflowTaskDispatcher = new EagerWorkflowTaskDispatcher(workerFactoryRegistry);
        this.requestsHelper = new WorkflowClientRequestFactory(clientOptions);
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowStartOutput start(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowId()));
        StartWorkflowExecutionRequest.Builder startRequest = this.toStartRequest(dataConverterWithWorkflowContext, input);
        try (WorkflowTaskDispatchHandle eagerDispatchHandle = this.obtainDispatchHandle(input);){
            PollWorkflowTaskQueueResponse eagerWorkflowTask;
            boolean requestEagerExecution = eagerDispatchHandle != null;
            startRequest.setRequestEagerExecution(requestEagerExecution);
            StartWorkflowExecutionResponse response = this.genericClient.start(startRequest.build());
            WorkflowExecution execution = WorkflowExecution.newBuilder().setRunId(response.getRunId()).setWorkflowId(startRequest.getWorkflowId()).build();
            PollWorkflowTaskQueueResponse pollWorkflowTaskQueueResponse = eagerWorkflowTask = requestEagerExecution && response.hasEagerWorkflowTask() ? response.getEagerWorkflowTask() : null;
            if (eagerWorkflowTask != null) {
                try {
                    eagerDispatchHandle.dispatch(eagerWorkflowTask);
                }
                catch (Exception e) {
                    log.error("[BUG] Eager Workflow Task was received from the Server, but failed to be dispatched on the local worker", (Throwable)e);
                }
            }
            WorkflowClientCallsInterceptor.WorkflowStartOutput workflowStartOutput = new WorkflowClientCallsInterceptor.WorkflowStartOutput(execution);
            return workflowStartOutput;
        }
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowSignalOutput signal(WorkflowClientCallsInterceptor.WorkflowSignalInput input) {
        SignalWorkflowExecutionRequest.Builder request = SignalWorkflowExecutionRequest.newBuilder().setSignalName(input.getSignalName()).setWorkflowExecution(input.getWorkflowExecution()).setIdentity(this.clientOptions.getIdentity()).setNamespace(this.clientOptions.getNamespace()).setRequestId(UUID.randomUUID().toString()).setHeader(HeaderUtils.toHeaderGrpc(input.getHeader(), null));
        DataConverter dataConverterWitSignalContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> inputArgs = dataConverterWitSignalContext.toPayloads(input.getArguments());
        inputArgs.ifPresent(arg_0 -> ((SignalWorkflowExecutionRequest.Builder)request).setInput(arg_0));
        this.genericClient.signal(request.build());
        return new WorkflowClientCallsInterceptor.WorkflowSignalOutput();
    }

    @Override
    public WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput signalWithStart(WorkflowClientCallsInterceptor.WorkflowSignalWithStartInput input) {
        WorkflowClientCallsInterceptor.WorkflowStartInput workflowStartInput = input.getWorkflowStartInput();
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), workflowStartInput.getWorkflowId()));
        StartWorkflowExecutionRequest.Builder startRequest = this.toStartRequest(dataConverterWithWorkflowContext, workflowStartInput);
        Optional<Payloads> signalInput = dataConverterWithWorkflowContext.toPayloads(input.getSignalArguments());
        SignalWithStartWorkflowExecutionRequest request = this.requestsHelper.newSignalWithStartWorkflowExecutionRequest((StartWorkflowExecutionRequestOrBuilder)startRequest, input.getSignalName(), signalInput.orElse(null)).build();
        SignalWithStartWorkflowExecutionResponse response = this.genericClient.signalWithStart(request);
        WorkflowExecution execution = WorkflowExecution.newBuilder().setRunId(response.getRunId()).setWorkflowId(request.getWorkflowId()).build();
        return new WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput(new WorkflowClientCallsInterceptor.WorkflowStartOutput(execution));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.WorkflowUpdateWithStartOutput<R> updateWithStart(WorkflowClientCallsInterceptor.WorkflowUpdateWithStartInput<R> input) {
        StartWorkflowExecutionResponse startResponse;
        UpdateWorkflowExecutionResponse updateResponse;
        WorkflowClientCallsInterceptor.WorkflowStartInput startInput = input.getWorkflowStartInput();
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), startInput.getWorkflowId()));
        ExecuteMultiOperationRequest request = ExecuteMultiOperationRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).addOperations(0, ExecuteMultiOperationRequest.Operation.newBuilder().setStartWorkflow(this.toStartRequest(dataConverterWithWorkflowContext, startInput)).build()).addOperations(1, ExecuteMultiOperationRequest.Operation.newBuilder().setUpdateWorkflow(this.toUpdateWorkflowExecutionRequest(input.getStartUpdateInput(), dataConverterWithWorkflowContext))).build();
        do {
            try {
                Deadline pollTimeoutDeadline = Deadline.after((long)60L, (TimeUnit)TimeUnit.SECONDS);
                ExecuteMultiOperationResponse response = this.genericClient.executeMultiOperation(request, pollTimeoutDeadline);
                if (response.getResponsesCount() != request.getOperationsCount()) {
                    throw new RuntimeException("Server sent back an invalid response: received " + response.getResponsesCount() + " instead of " + request.getOperationsCount() + " operation responses");
                }
                ExecuteMultiOperationResponse.Response firstResponse = response.getResponses(0);
                if (firstResponse.getResponseCase() != ExecuteMultiOperationResponse.Response.ResponseCase.START_WORKFLOW) {
                    throw new RuntimeException("Server sent back an invalid response type for StartWorkflow response");
                }
                startResponse = firstResponse.getStartWorkflow();
                ExecuteMultiOperationResponse.Response secondResponse = response.getResponses(1);
                if (secondResponse.getResponseCase() != ExecuteMultiOperationResponse.Response.ResponseCase.UPDATE_WORKFLOW) {
                    throw new RuntimeException("Server sent back an invalid response type for UpdateWorkflow response");
                }
                updateResponse = secondResponse.getUpdateWorkflow();
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED || e.getStatus().getCode() == Status.Code.CANCELLED) {
                    throw new WorkflowUpdateTimeoutOrCancelledException(input.getStartUpdateInput().getWorkflowExecution(), input.getStartUpdateInput().getUpdateName(), input.getStartUpdateInput().getUpdateId(), (Throwable)e);
                }
                MultiOperationExecutionFailure failure = (MultiOperationExecutionFailure)StatusUtils.getFailure((StatusRuntimeException)e, MultiOperationExecutionFailure.class);
                if (failure == null) {
                    throw e;
                }
                if (failure.getStatusesCount() != request.getOperationsCount()) {
                    throw new RuntimeException("Server sent back an invalid error response: received " + failure.getStatusesCount() + " instead of " + request.getOperationsCount() + " operation errors");
                }
                MultiOperationExecutionFailure.OperationStatus startStatus = failure.getStatuses(0);
                if (!(startStatus.getCode() == Status.Code.OK.value() || startStatus.getDetailsCount() != 0 && startStatus.getDetails(0).is(MultiOperationExecutionAborted.class))) {
                    throw Status.fromCodeValue((int)startStatus.getCode()).withDescription(startStatus.getMessage()).asRuntimeException();
                }
                MultiOperationExecutionFailure.OperationStatus updateStatus = failure.getStatuses(1);
                if (!(updateStatus.getCode() == Status.Code.OK.value() || updateStatus.getDetailsCount() != 0 && updateStatus.getDetails(0).is(MultiOperationExecutionAborted.class))) {
                    throw Status.fromCodeValue((int)updateStatus.getCode()).withDescription(updateStatus.getMessage()).asRuntimeException();
                }
                throw e;
            }
        } while (this.updateNotYetDurable(input.getStartUpdateInput(), updateResponse));
        WorkflowUpdateHandle<R> updateHandle = this.toUpdateHandle(input.getStartUpdateInput(), updateResponse, dataConverterWithWorkflowContext);
        WorkflowExecution execution = WorkflowExecution.newBuilder().setRunId(startResponse.getRunId()).setWorkflowId(this.toStartRequest(dataConverterWithWorkflowContext, startInput).build().getWorkflowId()).build();
        return new WorkflowClientCallsInterceptor.WorkflowUpdateWithStartOutput<R>(new WorkflowClientCallsInterceptor.WorkflowStartOutput(execution), updateHandle);
    }

    private StartWorkflowExecutionRequest.Builder toStartRequest(DataConverter dataConverterWithWorkflowContext, WorkflowClientCallsInterceptor.WorkflowStartInput workflowStartInput) {
        Optional<Payloads> workflowInput = dataConverterWithWorkflowContext.toPayloads(workflowStartInput.getArguments());
        Memo memo = workflowStartInput.getOptions().getMemo() != null ? Memo.newBuilder().putAllFields(HeaderUtils.intoPayloadMap(dataConverterWithWorkflowContext, workflowStartInput.getOptions().getMemo())).build() : null;
        UserMetadata userMetadata = WorkflowExecutionUtils.makeUserMetaData(workflowStartInput.getOptions().getStaticSummary(), workflowStartInput.getOptions().getStaticDetails(), dataConverterWithWorkflowContext);
        return this.requestsHelper.newStartWorkflowExecutionRequest(workflowStartInput.getWorkflowId(), workflowStartInput.getWorkflowType(), workflowStartInput.getHeader(), workflowStartInput.getOptions(), workflowInput.orElse(null), memo, userMetadata);
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.GetResultOutput<R> getResult(WorkflowClientCallsInterceptor.GetResultInput<R> input) throws TimeoutException {
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> resultValue = WorkflowClientLongPollHelper.getWorkflowExecutionResult(this.genericClient, this.requestsHelper, input.getWorkflowExecution(), input.getWorkflowType(), dataConverterWithWorkflowContext, input.getTimeout(), input.getTimeoutUnit());
        return new WorkflowClientCallsInterceptor.GetResultOutput<R>(RootWorkflowClientInvoker.convertResultPayloads(resultValue, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.GetResultAsyncOutput<R> getResultAsync(WorkflowClientCallsInterceptor.GetResultInput<R> input) {
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        CompletableFuture<Optional<Payloads>> resultValue = WorkflowClientLongPollAsyncHelper.getWorkflowExecutionResultAsync(this.genericClient, this.requestsHelper, input.getWorkflowExecution(), input.getWorkflowType(), input.getTimeout(), input.getTimeoutUnit(), dataConverterWithWorkflowContext);
        return new WorkflowClientCallsInterceptor.GetResultAsyncOutput(resultValue.thenApply(payloads -> RootWorkflowClientInvoker.convertResultPayloads(payloads, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext)));
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.QueryOutput<R> query(WorkflowClientCallsInterceptor.QueryInput<R> input) {
        WorkflowQuery.Builder query = WorkflowQuery.newBuilder().setQueryType(input.getQueryType()).setHeader(HeaderUtils.toHeaderGrpc(input.getHeader(), null));
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> inputArgs = dataConverterWithWorkflowContext.toPayloads(input.getArguments());
        inputArgs.ifPresent(arg_0 -> ((WorkflowQuery.Builder)query).setQueryArgs(arg_0));
        QueryWorkflowRequest request = QueryWorkflowRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setExecution(WorkflowExecution.newBuilder().setWorkflowId(input.getWorkflowExecution().getWorkflowId()).setRunId(input.getWorkflowExecution().getRunId())).setQuery(query).setQueryRejectCondition(this.clientOptions.getQueryRejectCondition()).build();
        QueryWorkflowResponse result = this.genericClient.query(request);
        boolean queryRejected = result.hasQueryRejected();
        WorkflowExecutionStatus rejectStatus = queryRejected ? result.getQueryRejected().getStatus() : null;
        Optional<Payloads> queryResult = result.hasQueryResult() ? Optional.of(result.getQueryResult()) : Optional.empty();
        R resultValue = RootWorkflowClientInvoker.convertResultPayloads(queryResult, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext);
        return new WorkflowClientCallsInterceptor.QueryOutput<R>(rejectStatus, resultValue);
    }

    @Override
    public <R> WorkflowUpdateHandle<R> startUpdate(WorkflowClientCallsInterceptor.StartUpdateInput<R> input) {
        UpdateWorkflowExecutionResponse result;
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        UpdateWorkflowExecutionRequest updateRequest = this.toUpdateWorkflowExecutionRequest(input, dataConverterWithWorkflowContext);
        do {
            Deadline pollTimeoutDeadline = Deadline.after((long)60L, (TimeUnit)TimeUnit.SECONDS);
            try {
                result = this.genericClient.update(updateRequest, pollTimeoutDeadline);
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED || e.getStatus().getCode() == Status.Code.CANCELLED) {
                    throw new WorkflowUpdateTimeoutOrCancelledException(input.getWorkflowExecution(), input.getUpdateName(), input.getUpdateId(), (Throwable)e);
                }
                throw e;
            }
        } while (this.updateNotYetDurable(input, result));
        return this.toUpdateHandle(input, result, dataConverterWithWorkflowContext);
    }

    private <R> boolean updateNotYetDurable(WorkflowClientCallsInterceptor.StartUpdateInput<R> input, UpdateWorkflowExecutionResponse result) {
        return result.getStage().getNumber() < input.getWaitPolicy().getLifecycleStage().getNumber() && result.getStage().getNumber() < UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_ACCEPTED.getNumber();
    }

    private <R> UpdateWorkflowExecutionRequest toUpdateWorkflowExecutionRequest(WorkflowClientCallsInterceptor.StartUpdateInput<R> input, DataConverter dataConverterWithWorkflowContext) {
        Optional<Payloads> inputArgs = dataConverterWithWorkflowContext.toPayloads(input.getArguments());
        Input.Builder updateInput = Input.newBuilder().setHeader(HeaderUtils.toHeaderGrpc(input.getHeader(), null)).setName(input.getUpdateName());
        inputArgs.ifPresent(arg_0 -> ((Input.Builder)updateInput).setArgs(arg_0));
        Request request = Request.newBuilder().setMeta(Meta.newBuilder().setUpdateId(input.getUpdateId()).setIdentity(this.clientOptions.getIdentity())).setInput(updateInput).build();
        return UpdateWorkflowExecutionRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setWaitPolicy(input.getWaitPolicy()).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId(input.getWorkflowExecution().getWorkflowId()).setRunId(input.getWorkflowExecution().getRunId())).setFirstExecutionRunId(input.getFirstExecutionRunId()).setRequest(request).build();
    }

    private <R> WorkflowUpdateHandle<R> toUpdateHandle(WorkflowClientCallsInterceptor.StartUpdateInput<R> input, UpdateWorkflowExecutionResponse result, DataConverter dataConverterWithWorkflowContext) {
        if (result.hasOutcome()) {
            switch (result.getOutcome().getValueCase()) {
                case SUCCESS: {
                    Optional<Payloads> updateResult = Optional.of(result.getOutcome().getSuccess());
                    R resultValue = RootWorkflowClientInvoker.convertResultPayloads(updateResult, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext);
                    return new CompletedWorkflowUpdateHandleImpl<R>(result.getUpdateRef().getUpdateId(), result.getUpdateRef().getWorkflowExecution(), resultValue);
                }
                case FAILURE: {
                    return new CompletedWorkflowUpdateHandleImpl(result.getUpdateRef().getUpdateId(), result.getUpdateRef().getWorkflowExecution(), new WorkflowUpdateException(result.getUpdateRef().getWorkflowExecution(), result.getUpdateRef().getUpdateId(), input.getUpdateName(), (Throwable)dataConverterWithWorkflowContext.failureToException(result.getOutcome().getFailure())));
                }
            }
            throw new RuntimeException("Received unexpected outcome from update request: " + result.getOutcome().getValueCase());
        }
        LazyWorkflowUpdateHandleImpl<R> handle = new LazyWorkflowUpdateHandleImpl<R>(this, input.getWorkflowType().orElse(null), input.getUpdateName(), result.getUpdateRef().getUpdateId(), result.getUpdateRef().getWorkflowExecution(), input.getResultClass(), input.getResultType());
        UpdateWorkflowExecutionLifecycleStage waitForStage = input.getWaitPolicy().getLifecycleStage();
        if (waitForStage == WorkflowUpdateStage.COMPLETED.getProto()) {
            handle.waitCompleted();
        }
        return handle;
    }

    @Override
    public <R> WorkflowClientCallsInterceptor.PollWorkflowUpdateOutput<R> pollWorkflowUpdate(WorkflowClientCallsInterceptor.PollWorkflowUpdateInput<R> input) {
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        UpdateRef update = UpdateRef.newBuilder().setWorkflowExecution(input.getWorkflowExecution()).setUpdateId(input.getUpdateId()).build();
        WaitPolicy waitPolicy = WaitPolicy.newBuilder().setLifecycleStage(UpdateWorkflowExecutionLifecycleStage.UPDATE_WORKFLOW_EXECUTION_LIFECYCLE_STAGE_COMPLETED).build();
        PollWorkflowExecutionUpdateRequest pollUpdateRequest = PollWorkflowExecutionUpdateRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setIdentity(this.clientOptions.getIdentity()).setUpdateRef(update).setWaitPolicy(waitPolicy).build();
        CompletableFuture<PollWorkflowExecutionUpdateResponse> future = new CompletableFuture<PollWorkflowExecutionUpdateResponse>();
        Deadline pollTimeoutDeadline = Deadline.after((long)input.getTimeout(), (TimeUnit)input.getTimeoutUnit());
        this.pollWorkflowUpdateHelper(future, pollUpdateRequest, pollTimeoutDeadline);
        return new WorkflowClientCallsInterceptor.PollWorkflowUpdateOutput(future.thenApply(result -> {
            if (result.hasOutcome()) {
                switch (result.getOutcome().getValueCase()) {
                    case SUCCESS: {
                        Optional<Payloads> updateResult = Optional.of(result.getOutcome().getSuccess());
                        return RootWorkflowClientInvoker.convertResultPayloads(updateResult, input.getResultClass(), input.getResultType(), dataConverterWithWorkflowContext);
                    }
                    case FAILURE: {
                        throw new WorkflowUpdateException(input.getWorkflowExecution(), input.getUpdateId(), input.getUpdateName(), (Throwable)dataConverterWithWorkflowContext.failureToException(result.getOutcome().getFailure()));
                    }
                }
                throw new RuntimeException("Received unexpected outcome from poll update request: " + result.getOutcome().getValueCase());
            }
            throw new RuntimeException("Received no outcome from server");
        }));
    }

    private void pollWorkflowUpdateHelper(CompletableFuture<PollWorkflowExecutionUpdateResponse> resultCF, PollWorkflowExecutionUpdateRequest request, Deadline deadline) {
        this.genericClient.pollUpdateAsync(request, deadline).whenComplete((r, e) -> {
            if (e == null && !r.hasOutcome()) {
                this.pollWorkflowUpdateHelper(resultCF, request, deadline);
                return;
            }
            if (e instanceof StatusRuntimeException && (((StatusRuntimeException)((Object)e)).getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED || ((StatusRuntimeException)((Object)e)).getStatus().getCode() == Status.Code.CANCELLED) || deadline.isExpired()) {
                resultCF.completeExceptionally(new WorkflowUpdateTimeoutOrCancelledException(request.getUpdateRef().getWorkflowExecution(), request.getUpdateRef().getUpdateId(), "", (Throwable)e));
            } else if (e != null) {
                resultCF.completeExceptionally((Throwable)e);
            } else {
                resultCF.complete((PollWorkflowExecutionUpdateResponse)r);
            }
        });
    }

    @Override
    public WorkflowClientCallsInterceptor.CancelOutput cancel(WorkflowClientCallsInterceptor.CancelInput input) {
        RequestCancelWorkflowExecutionRequest.Builder request = RequestCancelWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setWorkflowExecution(input.getWorkflowExecution()).setNamespace(this.clientOptions.getNamespace()).setIdentity(this.clientOptions.getIdentity());
        this.genericClient.requestCancel(request.build());
        return new WorkflowClientCallsInterceptor.CancelOutput();
    }

    @Override
    public WorkflowClientCallsInterceptor.TerminateOutput terminate(WorkflowClientCallsInterceptor.TerminateInput input) {
        TerminateWorkflowExecutionRequest.Builder request = TerminateWorkflowExecutionRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setIdentity(this.clientOptions.getIdentity()).setWorkflowExecution(input.getWorkflowExecution());
        if (input.getReason() != null) {
            request.setReason(input.getReason());
        }
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        Optional<Payloads> payloads = dataConverterWithWorkflowContext.toPayloads(input.getDetails());
        payloads.ifPresent(arg_0 -> ((TerminateWorkflowExecutionRequest.Builder)request).setDetails(arg_0));
        this.genericClient.terminate(request.build());
        return new WorkflowClientCallsInterceptor.TerminateOutput();
    }

    @Override
    public WorkflowClientCallsInterceptor.DescribeWorkflowOutput describe(WorkflowClientCallsInterceptor.DescribeWorkflowInput input) {
        DescribeWorkflowExecutionResponse response = this.genericClient.describeWorkflowExecution(DescribeWorkflowExecutionRequest.newBuilder().setNamespace(this.clientOptions.getNamespace()).setExecution(input.getWorkflowExecution()).build());
        DataConverter dataConverterWithWorkflowContext = this.clientOptions.getDataConverter().withContext(new WorkflowSerializationContext(this.clientOptions.getNamespace(), input.getWorkflowExecution().getWorkflowId()));
        return new WorkflowClientCallsInterceptor.DescribeWorkflowOutput(new WorkflowExecutionDescription(response, dataConverterWithWorkflowContext));
    }

    private static <R> R convertResultPayloads(Optional<Payloads> resultValue, Class<R> resultClass, Type resultType, DataConverter dataConverter) {
        return dataConverter.fromPayloads(0, resultValue, resultClass, resultType);
    }

    @Nullable
    private WorkflowTaskDispatchHandle obtainDispatchHandle(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        if (input.getOptions().isDisableEagerExecution()) {
            return null;
        }
        return this.eagerWorkflowTaskDispatcher.tryGetLocalDispatchHandler(input);
    }
}

