/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.statemachines.UnsupportedContinueAsNewRequest;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkflowExecutionHandler {
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecutionHandler.class);
    private final SyncWorkflowContext context;
    private final SyncWorkflowDefinition workflow;
    private final WorkflowExecutionStartedEventAttributes attributes;
    @Nonnull
    private final WorkflowImplementationOptions implementationOptions;
    private Optional<Payloads> output = Optional.empty();
    private boolean done;

    public WorkflowExecutionHandler(SyncWorkflowContext context, SyncWorkflowDefinition workflow, WorkflowExecutionStartedEventAttributes attributes, @Nonnull WorkflowImplementationOptions options) {
        this.implementationOptions = options;
        this.context = Objects.requireNonNull(context);
        this.workflow = Objects.requireNonNull(workflow);
        this.attributes = Objects.requireNonNull(attributes);
    }

    public void runWorkflowMethod() {
        try {
            Optional<Payloads> input = this.attributes.hasInput() ? Optional.of(this.attributes.getInput()) : Optional.empty();
            this.output = this.workflow.execute(new io.temporal.common.interceptors.Header(this.attributes.getHeader()), input);
        }
        catch (Throwable e) {
            this.applyWorkflowFailurePolicyAndRethrow(e);
        }
        finally {
            this.done = true;
        }
    }

    public void runConstructor() {
        try {
            this.workflow.initialize(this.attributes.hasInput() ? Optional.of(this.attributes.getInput()) : Optional.empty());
        }
        catch (Throwable e) {
            this.applyWorkflowFailurePolicyAndRethrow(e);
            this.done = true;
        }
    }

    public void cancel(String reason) {
    }

    public boolean isDone() {
        return this.done;
    }

    public Optional<Payloads> getOutput() {
        return this.output;
    }

    public void close() {
    }

    public void handleSignal(String signalName, Optional<Payloads> input, long eventId, Header header) {
        try {
            this.context.handleSignal(signalName, input, eventId, new io.temporal.common.interceptors.Header(header));
        }
        catch (Throwable e) {
            this.applyWorkflowFailurePolicyAndRethrow(e);
        }
    }

    public Optional<Payloads> handleQuery(String type, Header header, Optional<Payloads> args) {
        return this.context.handleQuery(type, new io.temporal.common.interceptors.Header(header), args);
    }

    public void handleValidateUpdate(String updateName, String updateId, Optional<Payloads> input, long eventId, Header header) {
        try {
            this.context.handleValidateUpdate(updateName, updateId, input, eventId, new io.temporal.common.interceptors.Header(header));
        }
        catch (Throwable e) {
            this.applyWorkflowFailurePolicyAndRethrow(e);
        }
    }

    public Optional<Payloads> handleExecuteUpdate(String updateName, String updateId, Optional<Payloads> input, long eventId, Header header) {
        try {
            return this.context.handleExecuteUpdate(updateName, updateId, input, eventId, new io.temporal.common.interceptors.Header(header));
        }
        catch (UnsupportedContinueAsNewRequest e) {
            throw e;
        }
        catch (Throwable e) {
            this.applyWorkflowFailurePolicyAndRethrow(e);
            return Optional.empty();
        }
    }

    private void applyWorkflowFailurePolicyAndRethrow(Throwable e) {
        if (e instanceof DestroyWorkflowThreadError) {
            throw (DestroyWorkflowThreadError)e;
        }
        Throwable exception = WorkflowInternal.unwrap(e);
        Class<? extends Throwable>[] failTypes = this.implementationOptions.getFailWorkflowExceptionTypes();
        if (exception instanceof TemporalFailure) {
            this.throwAndFailWorkflowExecution(exception);
        }
        for (Class<? extends Throwable> failType : failTypes) {
            if (!failType.isAssignableFrom(exception.getClass())) continue;
            this.throwAndFailWorkflowExecution(exception);
        }
        throw CheckedExceptionWrapper.wrap((Throwable)exception);
    }

    private void throwAndFailWorkflowExecution(Throwable exception) {
        ReplayWorkflowContext replayWorkflowContext = this.context.getReplayContext();
        String fullReplayDirectQueryName = replayWorkflowContext.getFullReplayDirectQueryName();
        WorkflowInfo info = Workflow.getInfo();
        if (fullReplayDirectQueryName != null) {
            if (log.isDebugEnabled() && !this.requestedCancellation(replayWorkflowContext.isCancelRequested(), exception)) {
                log.debug("Replayed workflow execution failure WorkflowId='{}', RunId={}, WorkflowType='{}' for direct query QueryType='{}'", new Object[]{info.getWorkflowId(), info.getRunId(), info.getWorkflowType(), fullReplayDirectQueryName, exception});
            }
        } else if (log.isWarnEnabled() && !this.requestedCancellation(replayWorkflowContext.isCancelRequested(), exception)) {
            log.warn("Workflow execution failure WorkflowId='{}', RunId={}, WorkflowType='{}'", new Object[]{info.getWorkflowId(), info.getRunId(), info.getWorkflowType(), exception});
        }
        throw new WorkflowExecutionException(this.context.mapWorkflowExceptionToFailure(exception));
    }

    private boolean requestedCancellation(boolean cancelRequested, Throwable exception) {
        return cancelRequested && WorkflowExecutionHandler.isCanceledCause(exception);
    }

    private static boolean isCanceledCause(Throwable exception) {
        while (exception != null) {
            if (exception instanceof CanceledFailure) {
                return true;
            }
            exception = exception.getCause();
        }
        return false;
    }
}

