/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Preconditions;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.WorkflowSemaphore;
import java.time.Duration;

class WorkflowSemaphoreImpl
implements WorkflowSemaphore {
    private int currentPermits;

    public WorkflowSemaphoreImpl(int permits) {
        this.currentPermits = permits;
    }

    @Override
    public void acquire() {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) {
        Preconditions.checkArgument((permits >= 0 ? 1 : 0) != 0, (Object)"WorkflowSemaphore.acquire called with negative permits");
        WorkflowInternal.await("WorkflowSemaphore.acquire", () -> {
            CancellationScope.throwCanceled();
            return this.currentPermits >= permits;
        });
        this.currentPermits -= permits;
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(Duration timeout) {
        return this.tryAcquire(1, timeout);
    }

    @Override
    public boolean tryAcquire(int permits) {
        WorkflowInternal.assertNotReadOnly("WorkflowSemaphore.tryAcquire");
        Preconditions.checkArgument((permits >= 0 ? 1 : 0) != 0, (Object)"WorkflowSemaphore.tryAcquire called with negative permits");
        if (this.currentPermits >= permits) {
            this.currentPermits -= permits;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAcquire(int permits, Duration timeout) {
        Preconditions.checkArgument((permits >= 0 ? 1 : 0) != 0, (Object)"WorkflowSemaphore.tryAcquire called with negative permits");
        boolean acquired = WorkflowInternal.await(timeout, "WorkflowSemaphore.tryAcquire", () -> {
            CancellationScope.throwCanceled();
            return this.currentPermits >= permits;
        });
        if (acquired) {
            this.currentPermits -= permits;
        }
        return acquired;
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        WorkflowInternal.assertNotReadOnly("WorkflowSemaphore.release");
        Preconditions.checkArgument((permits >= 0 ? 1 : 0) != 0, (Object)"WorkflowSemaphore.release called with negative permits");
        this.currentPermits += permits;
    }
}

