/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.common.RetryOptions;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import java.time.Duration;
import java.util.Optional;

final class WorkflowRetryerInternal {
    public static void retry(RetryOptions options, Optional<Duration> expiration, Functions.Proc proc) {
        WorkflowRetryerInternal.retry(options, expiration, () -> {
            proc.apply();
            return null;
        });
    }

    public static <R> R retry(RetryOptions options, Optional<Duration> expiration, Functions.Func<R> func) {
        int attempt = 1;
        long startTime = WorkflowInternal.currentTimeMillis();
        String retryId = WorkflowInternal.randomUUID().toString();
        RetryOptions retryOptions = WorkflowRetryerInternal.getRetryOptionsSideEffect(retryId, options);
        while (true) {
            long nextSleepTime = retryOptions.calculateSleepTime(attempt);
            try {
                return func.apply();
            }
            catch (Exception e) {
                long elapsed = WorkflowInternal.currentTimeMillis() - startTime;
                if (retryOptions.shouldRethrow(e, expiration, attempt, elapsed, nextSleepTime)) {
                    throw WorkflowInternal.wrap(e);
                }
                ++attempt;
                WorkflowInternal.sleep(Duration.ofMillis(nextSleepTime));
                continue;
            }
            break;
        }
    }

    public static <R> Promise<R> retryAsync(RetryOptions options, Optional<Duration> expiration, Functions.Func<Promise<R>> func) {
        String retryId = WorkflowInternal.randomUUID().toString();
        long startTime = WorkflowInternal.currentTimeMillis();
        return WorkflowRetryerInternal.retryAsync(retryId, options, expiration, func, startTime, 1L);
    }

    private static <R> Promise<R> retryAsync(String retryId, RetryOptions options, Optional<Duration> expiration, Functions.Func<Promise<R>> func, long startTime, long attempt) {
        RetryOptions retryOptions = WorkflowRetryerInternal.getRetryOptionsSideEffect(retryId, options);
        CompletablePromise funcResult = WorkflowInternal.newCompletablePromise();
        try {
            funcResult.completeFrom(func.apply());
        }
        catch (RuntimeException e2) {
            funcResult.completeExceptionally(e2);
        }
        return funcResult.handle((r, e) -> {
            long sleepTime;
            if (e == null) {
                return WorkflowInternal.newPromise(r);
            }
            long elapsed = WorkflowInternal.currentTimeMillis() - startTime;
            if (retryOptions.shouldRethrow((Throwable)e, expiration, attempt, elapsed, sleepTime = retryOptions.calculateSleepTime(attempt))) {
                throw e;
            }
            return WorkflowInternal.newTimer(Duration.ofMillis(sleepTime)).thenCompose(nil -> WorkflowRetryerInternal.retryAsync(retryId, retryOptions, expiration, func, startTime, attempt + 1L));
        }).thenCompose(r -> r);
    }

    private static RetryOptions getRetryOptionsSideEffect(String retryId, RetryOptions options) {
        long maximumIntervalMillis = options.getMaximumInterval() != null ? options.getMaximumInterval().toMillis() : 0L;
        long initialIntervalMillis = options.getInitialInterval() != null ? options.getInitialInterval().toMillis() : 0L;
        SerializableRetryOptions sOptions = new SerializableRetryOptions(initialIntervalMillis, options.getBackoffCoefficient(), options.getMaximumAttempts(), maximumIntervalMillis, options.getDoNotRetry());
        SerializableRetryOptions sRetryOptions = WorkflowInternal.mutableSideEffect(retryId, SerializableRetryOptions.class, SerializableRetryOptions.class, Object::equals, () -> sOptions);
        RetryOptions.Builder result = RetryOptions.newBuilder();
        if (sRetryOptions.getBackoffCoefficient() > 0.0) {
            result.setBackoffCoefficient(sRetryOptions.getBackoffCoefficient());
        }
        if (sRetryOptions.getInitialIntervalMillis() > 0L) {
            result.setInitialInterval(Duration.ofMillis(sRetryOptions.getInitialIntervalMillis()));
        }
        result.setDoNotRetry(sRetryOptions.getDoNotRetry());
        if (sRetryOptions.getMaximumIntervalMillis() > 0L) {
            result.setMaximumInterval(Duration.ofMillis(sRetryOptions.getMaximumIntervalMillis()));
        }
        if (sRetryOptions.getInitialIntervalMillis() > 0L) {
            result.setInitialInterval(Duration.ofMillis(sRetryOptions.getInitialIntervalMillis()));
        }
        if (sRetryOptions.getMaximumAttempts() > 0) {
            result.setMaximumAttempts(sRetryOptions.getMaximumAttempts());
        }
        return result.build();
    }

    private WorkflowRetryerInternal() {
    }

    static class SerializableRetryOptions {
        private long initialIntervalMillis;
        private double backoffCoefficient;
        private int maximumAttempts;
        private long maximumIntervalMillis;
        private String[] doNotRetry;

        public SerializableRetryOptions() {
        }

        public SerializableRetryOptions(long initialIntervalMillis, double backoffCoefficient, int maximumAttempts, long maximumIntervalMillis, String[] doNotRetry) {
            this.initialIntervalMillis = initialIntervalMillis;
            this.backoffCoefficient = backoffCoefficient;
            this.maximumAttempts = maximumAttempts;
            this.maximumIntervalMillis = maximumIntervalMillis;
            this.doNotRetry = doNotRetry;
        }

        public long getInitialIntervalMillis() {
            return this.initialIntervalMillis;
        }

        public double getBackoffCoefficient() {
            return this.backoffCoefficient;
        }

        public int getMaximumAttempts() {
            return this.maximumAttempts;
        }

        public long getMaximumIntervalMillis() {
            return this.maximumIntervalMillis;
        }

        public String[] getDoNotRetry() {
            return this.doNotRetry;
        }
    }
}

