/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.HistoryEventOrBuilder;
import io.temporal.internal.common.WorkflowExecutionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class WFTBuffer {
    private WFTState wftSequenceState = WFTState.None;
    private final List<HistoryEvent> wftBuffer = new ArrayList<HistoryEvent>();
    private Optional<HistoryEvent> workflowTaskCompletedEvent = Optional.empty();
    private final List<HistoryEvent> readyToFetch = new ArrayList<HistoryEvent>();

    public boolean addEvent(HistoryEvent event, boolean hasNextEvent) {
        if (this.readyToFetch.size() > 0) {
            throw new IllegalStateException("Can't add more events until the readyToFetch is fetched");
        }
        this.handleEvent(event, hasNextEvent);
        return !this.readyToFetch.isEmpty();
    }

    private void handleEvent(HistoryEvent event, boolean hasNextEvent) {
        if (!hasNextEvent) {
            this.flushBuffer();
            if (WFTState.Started.equals((Object)this.wftSequenceState) && event.getEventType().equals((Object)EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED)) {
                this.workflowTaskCompletedEvent = Optional.of(event);
            }
            this.wftSequenceState = WFTState.None;
            this.readyToFetch.add(event);
            return;
        }
        if (EventType.EVENT_TYPE_WORKFLOW_TASK_STARTED.equals((Object)event.getEventType())) {
            this.wftSequenceState = WFTState.Started;
            this.addToBuffer(event);
            return;
        }
        if (WFTState.Started.equals((Object)this.wftSequenceState) && WorkflowExecutionUtils.isWorkflowTaskClosedEvent((HistoryEventOrBuilder)event)) {
            if (event.getEventType().equals((Object)EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED)) {
                this.workflowTaskCompletedEvent = Optional.of(event);
                this.wftSequenceState = WFTState.Closed;
            } else {
                this.wftSequenceState = WFTState.None;
            }
            this.addToBuffer(event);
            return;
        }
        if (WFTState.Closed.equals((Object)this.wftSequenceState) && !WorkflowExecutionUtils.isCommandEvent(event)) {
            this.flushBuffer();
            this.wftSequenceState = WFTState.None;
            this.addToBuffer(event);
            return;
        }
        if (WFTState.Closed.equals((Object)this.wftSequenceState) && WorkflowExecutionUtils.isCommandEvent(event)) {
            this.addToBuffer(event);
            return;
        }
        if (WorkflowExecutionUtils.isCommandEvent(event) || WorkflowExecutionUtils.isWorkflowTaskClosedEvent((HistoryEventOrBuilder)event)) {
            this.flushBuffer();
            this.readyToFetch.add(event);
        } else {
            this.addToBuffer(event);
        }
    }

    private void flushBuffer() {
        this.readyToFetch.addAll(this.wftBuffer);
        this.wftBuffer.clear();
    }

    private void addToBuffer(HistoryEvent event) {
        this.wftBuffer.add(event);
    }

    public EventBatch fetch() {
        if (this.readyToFetch.size() == 1) {
            HistoryEvent event = this.readyToFetch.get(0);
            Optional<HistoryEvent> wftCompleted = this.workflowTaskCompletedEvent;
            this.workflowTaskCompletedEvent = Optional.empty();
            this.readyToFetch.clear();
            return new EventBatch(wftCompleted, Collections.singletonList(event));
        }
        ArrayList<HistoryEvent> result = new ArrayList<HistoryEvent>(this.readyToFetch);
        Optional<HistoryEvent> wftCompleted = this.workflowTaskCompletedEvent;
        this.workflowTaskCompletedEvent = Optional.empty();
        this.readyToFetch.clear();
        return new EventBatch(wftCompleted, result);
    }

    public static class EventBatch {
        private final List<HistoryEvent> events;
        private final Optional<HistoryEvent> workflowTaskCompletedEvent;

        public EventBatch(Optional<HistoryEvent> workflowTaskCompletedEvent, List<HistoryEvent> events) {
            this.workflowTaskCompletedEvent = workflowTaskCompletedEvent;
            this.events = events;
        }

        public List<HistoryEvent> getEvents() {
            return this.events;
        }

        public Optional<HistoryEvent> getWorkflowTaskCompletedEvent() {
            return this.workflowTaskCompletedEvent;
        }
    }

    private static enum WFTState {
        None,
        Started,
        Closed;

    }
}

