/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.health.v1.HealthCheckResponse;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.GrpcMetadataProviderInterceptor;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class NamespaceInjectWorkflowServiceStubs
implements WorkflowServiceStubs {
    private static Metadata.Key<String> TEMPORAL_NAMESPACE_HEADER_KEY = Metadata.Key.of((String)"temporal-namespace", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Metadata metadata;
    private final WorkflowServiceStubs next;

    public NamespaceInjectWorkflowServiceStubs(WorkflowServiceStubs next, String namespace) {
        this.next = next;
        this.metadata = new Metadata();
        this.metadata.put(TEMPORAL_NAMESPACE_HEADER_KEY, (Object)namespace);
    }

    public WorkflowServiceStubsOptions getOptions() {
        return this.next.getOptions();
    }

    public WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub() {
        return (WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.next.blockingStub()).withInterceptors(new ClientInterceptor[]{new GrpcMetadataProviderInterceptor(Collections.singleton(() -> this.metadata))});
    }

    public WorkflowServiceGrpc.WorkflowServiceFutureStub futureStub() {
        return (WorkflowServiceGrpc.WorkflowServiceFutureStub)((WorkflowServiceGrpc.WorkflowServiceFutureStub)this.next.futureStub()).withInterceptors(new ClientInterceptor[]{new GrpcMetadataProviderInterceptor(Collections.singleton(() -> this.metadata))});
    }

    public ManagedChannel getRawChannel() {
        return this.next.getRawChannel();
    }

    public void shutdown() {
        this.next.shutdown();
    }

    public void shutdownNow() {
        this.next.shutdownNow();
    }

    public boolean isShutdown() {
        return this.next.isShutdown();
    }

    public boolean isTerminated() {
        return this.next.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return this.next.awaitTermination(timeout, unit);
    }

    public void connect(@Nullable Duration timeout) {
        this.next.connect(timeout);
    }

    public HealthCheckResponse healthCheck() {
        return this.next.healthCheck();
    }

    public Supplier<GetSystemInfoResponse.Capabilities> getServerCapabilities() {
        return this.next.getServerCapabilities();
    }
}

