/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

class PIDController {
    private double setPoint;
    private double kP;
    private double kI;
    private double kD;
    private double minLimit = Double.NaN;
    private double maxLimit = Double.NaN;
    private double previousTime = Double.NaN;
    private double lastError = 0.0;
    private double integralError = 0.0;

    PIDController(double setPoint, double kP, double kI, double kD) {
        this.setSetpoint(setPoint);
        this.kP = kP;
        this.kI = kI;
        this.kD = kD;
    }

    double getOutput(double currentTime, double currentValue) {
        double error = this.setPoint - currentValue;
        double dt = !Double.isNaN(this.previousTime) ? currentTime - this.previousTime : 0.0;
        double derivativeError = dt != 0.0 ? (error - this.lastError) / dt : 0.0;
        this.integralError += error * dt;
        this.previousTime = currentTime;
        this.lastError = error;
        return this.checkLimits(this.kP * error + this.kI * this.integralError + this.kD * derivativeError);
    }

    void reset() {
        this.previousTime = 0.0;
        this.lastError = 0.0;
        this.integralError = 0.0;
    }

    private double checkLimits(double output) {
        if (!Double.isNaN(this.minLimit) && output < this.minLimit) {
            return this.minLimit;
        }
        if (!Double.isNaN(this.maxLimit) && output > this.maxLimit) {
            return this.maxLimit;
        }
        return output;
    }

    void setOuputLimits(double minLimit, double maxLimit) {
        if (minLimit < maxLimit) {
            this.minLimit = minLimit;
            this.maxLimit = maxLimit;
        } else {
            this.minLimit = maxLimit;
            this.maxLimit = minLimit;
        }
    }

    void removeOuputLimits() {
        this.minLimit = Double.NaN;
        this.maxLimit = Double.NaN;
    }

    public double getkP() {
        return this.kP;
    }

    void setkP(double kP) {
        this.kP = kP;
        this.reset();
    }

    double getkI() {
        return this.kI;
    }

    void setkI(double kI) {
        this.kI = kI;
        this.reset();
    }

    double getkD() {
        return this.kD;
    }

    void setkD(double kD) {
        this.kD = kD;
        this.reset();
    }

    double getSetPoint() {
        return this.setPoint;
    }

    void setSetpoint(double setPoint) {
        this.reset();
        this.setPoint = setPoint;
    }
}

